/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_21_2to1_21.storage;

import com.google.common.base.Preconditions;
import com.viaversion.viabackwards.protocol.v1_21_2to1_21.Protocol1_21_2To1_21;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundPackets1_21;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class RecipeStorage
implements StorableObject {
    public static final int RECIPE_BOOK_SETTINGS = 8;
    private static final String[] EMPTY_STRINGS = new String[0];
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<Recipe> tempRecipes = new ArrayList<Recipe>();
    private final List<StoneCutterRecipe> stoneCutterRecipes = new ArrayList<StoneCutterRecipe>();
    private boolean[] recipeBookSettings = new boolean[8];
    private final Protocol1_21_2To1_21 protocol;

    public RecipeStorage(Protocol1_21_2To1_21 protocol) {
        this.protocol = protocol;
    }

    public void sendRecipes(UserConnection connection) {
        if (!this.tempRecipes.isEmpty()) {
            this.recipes.addAll(this.tempRecipes);
            this.tempRecipes.clear();
        }
        int highestIndex = -1;
        for (Recipe recipe : this.recipes) {
            highestIndex = Math.max(highestIndex, recipe.index);
        }
        ArrayList<Recipe> recipes = new ArrayList<Recipe>(this.recipes);
        for (StoneCutterRecipe recipe : this.stoneCutterRecipes) {
            recipe.index = ++highestIndex;
            recipes.add(recipe);
        }
        recipes.sort(Comparator.comparingInt(a -> a.index));
        PacketWrapper packetWrapper = PacketWrapper.create((PacketType)ClientboundPackets1_21.UPDATE_RECIPES, (UserConnection)connection);
        packetWrapper.write((Type)Types.VAR_INT, (Object)recipes.size());
        for (Recipe recipe : recipes) {
            packetWrapper.write(Types.STRING, (Object)RecipeStorage.identifier(recipe.index));
            recipe.write(packetWrapper);
        }
        packetWrapper.send(Protocol1_21_2To1_21.class);
        this.sendUnlockedRecipes(connection, recipes);
    }

    private static String identifier(int recipeIndex) {
        return String.format("%06d", recipeIndex);
    }

    public void lockRecipes(PacketWrapper wrapper, int[] ids) {
        for (int n : ids) {
            this.recipes.removeIf(recipe -> recipe.index == id);
        }
        wrapper.write((Type)Types.VAR_INT, (Object)2);
        for (boolean bl : this.recipeBookSettings) {
            wrapper.write((Type)Types.BOOLEAN, (Object)bl);
        }
        String[] stringArray = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            stringArray[i] = RecipeStorage.identifier(ids[i]);
        }
        wrapper.write(Types.STRING_ARRAY, (Object)stringArray);
    }

    private void sendUnlockedRecipes(UserConnection connection, List<Recipe> recipes) {
        PacketWrapper wrapper = PacketWrapper.create((PacketType)ClientboundPackets1_21.RECIPE, (UserConnection)connection);
        wrapper.write((Type)Types.VAR_INT, (Object)0);
        for (boolean recipeBookSetting : this.recipeBookSettings) {
            wrapper.write((Type)Types.BOOLEAN, (Object)recipeBookSetting);
        }
        String[] recipeKeys = new String[recipes.size()];
        ArrayList<String> highlightRecipes = new ArrayList<String>();
        for (int i = 0; i < recipes.size(); ++i) {
            recipeKeys[i] = RecipeStorage.identifier(i);
            if (!recipes.get((int)i).highlight) continue;
            highlightRecipes.add(recipeKeys[i]);
        }
        wrapper.write(Types.STRING_ARRAY, (Object)recipeKeys);
        wrapper.write(Types.STRING_ARRAY, (Object)highlightRecipes.toArray(EMPTY_STRINGS));
        wrapper.send(Protocol1_21_2To1_21.class);
    }

    public void readRecipe(PacketWrapper wrapper) {
        int id = (Integer)wrapper.read((Type)Types.VAR_INT);
        int type = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        Recipe recipe = switch (type) {
            case 0 -> this.readShapeless(wrapper);
            case 1 -> this.readShaped(wrapper);
            case 2 -> this.readFurnace(wrapper);
            case 3 -> this.readStoneCutter(wrapper);
            case 4 -> this.readSmithing(wrapper);
            default -> null;
        };
        Integer group = (Integer)wrapper.read((Type)Types.OPTIONAL_VAR_INT);
        int category = (Integer)wrapper.read((Type)Types.VAR_INT);
        if (((Boolean)wrapper.read((Type)Types.BOOLEAN)).booleanValue()) {
            int ingredientsSize = (Integer)wrapper.read((Type)Types.VAR_INT);
            for (int j = 0; j < ingredientsSize; ++j) {
                wrapper.read(Types.HOLDER_SET);
            }
        }
        byte flags = (Byte)wrapper.read((Type)Types.BYTE);
        if (recipe != null) {
            recipe.index = id;
            recipe.group = group;
            recipe.category = category;
            recipe.highlight = (flags & 2) != 0;
        }
    }

    private Recipe readShapeless(PacketWrapper wrapper) {
        Item[][] ingredients = this.readSlotDisplayList(wrapper);
        Item result = this.readSingleSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        return this.add(new ShapelessRecipe(ingredients, result));
    }

    private Recipe readShaped(PacketWrapper wrapper) {
        int width = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        int height = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        Item[][] ingredients = this.readSlotDisplayList(wrapper);
        Item result = this.readSingleSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        return this.add(new ShapedRecipe(width, height, ingredients, result));
    }

    private Recipe readFurnace(PacketWrapper wrapper) {
        Item[] ingredient = this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        Item result = this.readSingleSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        int duration = (Integer)wrapper.read((Type)Types.VAR_INT);
        float experience = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
        return this.add(new FurnaceRecipe(ingredient, result, duration, experience));
    }

    private Recipe readStoneCutter(PacketWrapper wrapper) {
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        return null;
    }

    private Recipe readSmithing(PacketWrapper wrapper) {
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        this.readSlotDisplay(wrapper);
        return null;
    }

    private Recipe add(Recipe recipe) {
        this.tempRecipes.add(recipe);
        return recipe;
    }

    private Item[][] readSlotDisplayList(PacketWrapper wrapper) {
        int size = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        Item[][] ingredients = new Item[size][];
        for (int i = 0; i < size; ++i) {
            ingredients[i] = this.readSlotDisplay(wrapper);
        }
        return ingredients;
    }

    private Item readSingleSlotDisplay(PacketWrapper wrapper) {
        Item[] items = this.readSlotDisplay(wrapper);
        return items.length == 0 ? new StructuredItem(1, 1) : items[0];
    }

    private Item[] readSlotDisplay(PacketWrapper wrapper) {
        Item[] itemArray;
        int type = (Integer)wrapper.read((Type)Types.VAR_INT);
        switch (type) {
            case 2: {
                int id = (Integer)wrapper.read((Type)Types.VAR_INT);
                if (id == 0) {
                    this.protocol.getLogger().warning("Empty item id in recipe");
                    itemArray = new Item[]{};
                    break;
                }
                Item[] itemArray2 = new Item[1];
                itemArray = itemArray2;
                itemArray2[0] = new StructuredItem(this.rewriteItemId(id), 1);
                break;
            }
            case 3: {
                Item item = (Item)wrapper.read(VersionedTypes.V1_21_2.item());
                this.protocol.getItemRewriter().handleItemToClient(wrapper.user(), item);
                if (item.isEmpty()) {
                    this.protocol.getLogger().warning("Empty item in recipe");
                    itemArray = new Item[]{};
                    break;
                }
                Item[] itemArray3 = new Item[1];
                itemArray = itemArray3;
                itemArray3[0] = item;
                break;
            }
            case 4: {
                wrapper.read(Types.STRING);
                itemArray = new Item[]{};
                break;
            }
            case 5: {
                this.readSlotDisplay(wrapper);
                this.readSlotDisplay(wrapper);
                this.readSlotDisplay(wrapper);
                itemArray = new Item[]{};
                break;
            }
            case 6: {
                this.readSlotDisplay(wrapper);
                this.readSlotDisplay(wrapper);
                itemArray = new Item[]{};
                break;
            }
            case 7: {
                itemArray = this.readSlotDisplayList(wrapper)[0];
                break;
            }
            default: {
                itemArray = new Item[]{};
            }
        }
        return itemArray;
    }

    private int rewriteItemId(int id) {
        return this.protocol.getMappingData().getNewItemId(id);
    }

    public void readStoneCutterRecipes(PacketWrapper wrapper) {
        this.stoneCutterRecipes.clear();
        int stonecutterRecipesSize = (Integer)wrapper.read((Type)Types.VAR_INT);
        for (int i = 0; i < stonecutterRecipesSize; ++i) {
            Item[] ingredient = this.readHolderSet(wrapper);
            Item result = this.readSingleSlotDisplay(wrapper);
            this.stoneCutterRecipes.add(new StoneCutterRecipe(ingredient, result));
        }
    }

    private Item[] readHolderSet(PacketWrapper wrapper) {
        HolderSet holderSet = (HolderSet)wrapper.read(Types.HOLDER_SET);
        if (holderSet.hasTagKey()) {
            return new Item[]{new StructuredItem(1, 1)};
        }
        int[] ids = holderSet.ids();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.rewriteItemId(ids[i]);
        }
        Item[] ingredient = new Item[ids.length];
        for (int i = 0; i < ingredient.length; ++i) {
            ingredient[i] = new StructuredItem(ids[i], 1);
        }
        return ingredient;
    }

    public void setRecipeBookSettings(boolean[] recipeBookSettings) {
        this.recipeBookSettings = recipeBookSettings;
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    static abstract class Recipe {
        private static final int FOOD_CRAFTING_BOOK_CATEGORY = 0;
        private static final int BLOCKS_CRAFTING_BOOK_CATEGORY = 1;
        private static final int MISC_CRAFTING_BOOK_CATEGORY = 2;
        protected int index;
        private Integer group;
        private int category;
        private boolean highlight;

        Recipe() {
        }

        abstract void write(PacketWrapper var1);

        void writeGroup(PacketWrapper wrapper) {
            wrapper.write(Types.STRING, (Object)(this.group != null ? Integer.toString(this.group) : ""));
        }

        void writeIngredients(PacketWrapper wrapper, Item[][] ingredients) {
            wrapper.write((Type)Types.VAR_INT, (Object)ingredients.length);
            for (Item[] ingredient : ingredients) {
                this.writeIngredient(wrapper, ingredient);
            }
        }

        void writeIngredient(PacketWrapper wrapper, Item[] ingredient) {
            Item[] copy = new Item[ingredient.length];
            for (int i = 0; i < ingredient.length; ++i) {
                copy[i] = ingredient[i].copy();
            }
            wrapper.write(VersionedTypes.V1_21_2.itemArray(), (Object)copy);
        }

        void writeResult(PacketWrapper wrapper, Item result) {
            wrapper.write(VersionedTypes.V1_21_2.item(), (Object)result.copy());
        }

        void writeCategory(PacketWrapper wrapper) {
            int craftingBookCategory = switch (this.category) {
                case 4, 9, 12 -> 0;
                case 0, 5, 7, 10 -> 1;
                case 1, 2, 3, 6, 8, 11 -> 2;
                default -> 2;
            };
            wrapper.write((Type)Types.VAR_INT, (Object)craftingBookCategory);
        }

        int category() {
            return this.category;
        }
    }

    private static final class StoneCutterRecipe
    extends Recipe {
        private static final int SERIALIZER_ID = 19;
        private final Item[] ingredient;
        private final Item result;

        private StoneCutterRecipe(Item[] ingredient, Item result) {
            this.ingredient = ingredient;
            this.result = result;
        }

        @Override
        public void write(PacketWrapper wrapper) {
            wrapper.write((Type)Types.VAR_INT, (Object)19);
            this.writeGroup(wrapper);
            this.writeIngredient(wrapper, this.ingredient);
            this.writeResult(wrapper, this.result);
        }
    }

    private static final class ShapelessRecipe
    extends Recipe {
        private static final int SERIALIZER_ID = 1;
        private final Item[][] ingredients;
        private final Item result;

        private ShapelessRecipe(Item[][] ingredients, Item result) {
            this.ingredients = ingredients;
            this.result = result;
        }

        @Override
        public void write(PacketWrapper wrapper) {
            wrapper.write((Type)Types.VAR_INT, (Object)1);
            this.writeGroup(wrapper);
            this.writeCategory(wrapper);
            this.writeIngredients(wrapper, this.ingredients);
            this.writeResult(wrapper, this.result);
        }
    }

    private static final class ShapedRecipe
    extends Recipe {
        private static final int SERIALIZER_ID = 0;
        private final int width;
        private final int height;
        private final Item[][] ingredients;
        private final Item result;

        private ShapedRecipe(int width, int height, Item[][] ingredients, Item result) {
            this.width = width;
            this.height = height;
            this.ingredients = ingredients;
            this.result = result;
        }

        @Override
        public void write(PacketWrapper wrapper) {
            wrapper.write((Type)Types.VAR_INT, (Object)0);
            this.writeGroup(wrapper);
            this.writeCategory(wrapper);
            wrapper.write((Type)Types.VAR_INT, (Object)this.width);
            wrapper.write((Type)Types.VAR_INT, (Object)this.height);
            Preconditions.checkArgument((this.width * this.height == this.ingredients.length ? 1 : 0) != 0, (Object)"Invalid shaped recipe");
            for (Item[] ingredient : this.ingredients) {
                this.writeIngredient(wrapper, ingredient);
            }
            this.writeResult(wrapper, this.result);
            wrapper.write((Type)Types.BOOLEAN, (Object)false);
        }
    }

    private static final class FurnaceRecipe
    extends Recipe {
        private final Item[] ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;

        private FurnaceRecipe(Item[] ingredient, Item result, int cookingTime, float experience) {
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookingTime;
        }

        @Override
        public void write(PacketWrapper wrapper) {
            wrapper.write((Type)Types.VAR_INT, (Object)this.serializerId());
            this.writeGroup(wrapper);
            this.writeCategory(wrapper);
            this.writeIngredient(wrapper, this.ingredient);
            this.writeResult(wrapper, this.result);
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(this.experience));
            wrapper.write((Type)Types.VAR_INT, (Object)this.cookingTime);
        }

        private int serializerId() {
            return switch (this.category()) {
                case 4, 5, 6 -> 15;
                case 7, 8 -> 16;
                case 9 -> 17;
                case 12 -> 18;
                default -> 15;
            };
        }
    }
}

