/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;

public class SoundRewriter<C extends ClientboundPacketType>
extends com.viaversion.viaversion.rewriter.SoundRewriter<C> {
    private final BackwardsProtocol<C, ?, ?, ?> protocol;

    public SoundRewriter(BackwardsProtocol<C, ?, ?, ?> protocol) {
        super(protocol);
        this.protocol = protocol;
    }

    public void registerNamedSound(C packetType) {
        this.protocol.registerClientbound((ClientboundPacketType)packetType, wrapper -> {
            wrapper.passthrough(Types.STRING);
            this.getNamedSoundHandler().handle(wrapper);
        });
    }

    public void registerStopSound(C packetType) {
        this.protocol.registerClientbound((ClientboundPacketType)packetType, wrapper -> this.getStopSoundHandler().handle(wrapper));
    }

    public PacketHandler getNamedSoundHandler() {
        return wrapper -> {
            String soundId = (String)wrapper.get(Types.STRING, 0);
            String mappedId = this.protocol.getMappingData().getMappedNamedSound(soundId);
            if (mappedId == null) {
                return;
            }
            if (!mappedId.isEmpty()) {
                wrapper.set(Types.STRING, 0, (Object)mappedId);
            } else {
                wrapper.cancel();
            }
        };
    }

    public PacketHandler getStopSoundHandler() {
        return wrapper -> {
            byte flags = (Byte)wrapper.passthrough((Type)Types.BYTE);
            if ((flags & 2) == 0) {
                return;
            }
            if ((flags & 1) != 0) {
                wrapper.passthrough((Type)Types.VAR_INT);
            }
            String soundId = (String)wrapper.read(Types.STRING);
            String mappedId = this.protocol.getMappingData().getMappedNamedSound(soundId);
            if (mappedId == null) {
                wrapper.write(Types.STRING, (Object)soundId);
                return;
            }
            if (!mappedId.isEmpty()) {
                wrapper.write(Types.STRING, (Object)mappedId);
            } else {
                wrapper.cancel();
            }
        };
    }

    public void registerSound1_19_3(C packetType) {
        this.protocol.registerClientbound((ClientboundPacketType)packetType, this.getSoundHandler1_19_3());
    }

    public PacketHandler getSoundHandler1_19_3() {
        return wrapper -> {
            Holder soundEventHolder = (Holder)wrapper.read((Type)Types.SOUND_EVENT);
            if (soundEventHolder.isDirect()) {
                wrapper.write((Type)Types.SOUND_EVENT, this.rewriteSoundEvent(wrapper, (Holder<SoundEvent>)soundEventHolder));
                return;
            }
            int mappedId = this.idRewriter.rewrite(soundEventHolder.id());
            if (mappedId == -1) {
                wrapper.cancel();
                return;
            }
            if (mappedId != soundEventHolder.id()) {
                soundEventHolder = Holder.of((int)mappedId);
            }
            wrapper.write((Type)Types.SOUND_EVENT, (Object)soundEventHolder);
        };
    }

    public Holder<SoundEvent> rewriteSoundEvent(PacketWrapper wrapper, Holder<SoundEvent> soundEventHolder) {
        SoundEvent soundEvent = (SoundEvent)soundEventHolder.value();
        String mappedIdentifier = this.protocol.getMappingData().getMappedNamedSound(soundEvent.identifier());
        if (mappedIdentifier != null) {
            if (!mappedIdentifier.isEmpty()) {
                return Holder.of((Object)soundEvent.withIdentifier(mappedIdentifier));
            }
            wrapper.cancel();
        }
        return soundEventHolder;
    }
}

