/*
 * Decompiled with CFR 0.152.
 */
package ru.aspirez.boatplugin;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BoatPlugin
extends JavaPlugin
implements Listener {
    private static final String PERMISSION_RELOAD = "boatrestrictor.reload";
    private static final String CONFIG_PLAY_ERROR_SOUND = "play-error-sound";
    private static final String CONFIG_ERROR_SOUND = "error-sound";
    private static final String DEFAULT_LANGUAGE = "ru";
    private static final Sound DEFAULT_ERROR_SOUND = Sound.BLOCK_ANVIL_LAND;
    private final Set<String> restrictedWorlds = new HashSet<String>();
    private final Set<String> restrictedBoats = new HashSet<String>();
    private FileConfiguration languageConfig;
    private Sound errorSound;
    private boolean playErrorSound;

    public void onEnable() {
        this.setupConfigs();
        this.registerEvents();
        this.setupCommand();
        this.logPluginInfo();
    }

    private void setupConfigs() {
        this.saveDefaultConfig();
        this.loadPluginConfig();
        this.loadLanguageConfig();
    }

    private void loadPluginConfig() {
        FileConfiguration config = this.getConfig();
        this.restrictedWorlds.clear();
        this.restrictedWorlds.addAll(config.getStringList("restricted-worlds"));
        this.restrictedBoats.clear();
        config.getStringList("restricted-boats").stream().map(String::toLowerCase).forEach(this.restrictedBoats::add);
        this.playErrorSound = config.getBoolean(CONFIG_PLAY_ERROR_SOUND, true);
        this.errorSound = this.parseSound(config.getString(CONFIG_ERROR_SOUND, DEFAULT_ERROR_SOUND.name()));
    }

    private void loadLanguageConfig() {
        String language = this.getConfig().getString("lang", DEFAULT_LANGUAGE).toLowerCase(Locale.ENGLISH);
        File languageDir = new File(this.getDataFolder(), "lang");
        if (!languageDir.exists() && !languageDir.mkdirs()) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u044f\u0437\u044b\u043a\u043e\u0432\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432!");
            return;
        }
        File languageFile = new File(languageDir, language + ".yml");
        if (!languageFile.exists()) {
            String resourcePath = "lang/" + language + ".yml";
            if (this.getResource(resourcePath) != null) {
                this.saveResource(resourcePath, false);
            } else {
                this.saveResource("lang/ru.yml", false);
                languageFile = new File(languageDir, "ru.yml");
                this.getLogger().warning("\u042f\u0437\u044b\u043a\u043e\u0432\u043e\u0439 \u0444\u0430\u0439\u043b '" + language + ".yml' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u044f\u0437\u044b\u043a \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
            }
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    private Sound parseSound(String soundName) {
        try {
            return Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("\u0417\u0432\u0443\u043a '" + soundName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0437\u0432\u0443\u043a \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
            return DEFAULT_ERROR_SOUND;
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void setupCommand() {
        this.getCommand("boatrestrictor").setExecutor((sender, command, label, args) -> {
            if (sender.hasPermission(PERMISSION_RELOAD)) {
                this.reloadPlugin();
                sender.sendMessage(this.getLocalizedMessage("reload-message"));
            } else {
                sender.sendMessage(this.getLocalizedMessage("no-permission"));
            }
            return true;
        });
    }

    private void reloadPlugin() {
        this.reloadConfig();
        this.loadPluginConfig();
        this.loadLanguageConfig();
        this.getLogger().info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430.");
    }

    private void logPluginInfo() {
        Logger logger = this.getLogger();
        logger.info("\u041f\u043b\u0430\u0433\u0438\u043d BoatRestrictor \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0443\u0449\u0435\u043d!");
        logger.info("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0445 \u043c\u0438\u0440\u043e\u0432: " + this.restrictedWorlds.size());
        logger.info("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0445 \u043b\u043e\u0434\u043e\u043a: " + this.restrictedBoats.size());
        logger.info("\u0412\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0437\u0432\u0443\u043a\u0430 \u043e\u0448\u0438\u0431\u043a\u0438: " + (this.playErrorSound ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e"));
    }

    @EventHandler
    public void onBoatPlace(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !this.isRestrictedBoat(item)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isWorldRestricted(player.getWorld().getName())) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() == Material.WATER) {
            return;
        }
        event.setCancelled(true);
        this.handleRestrictedPlacement(player);
    }

    private boolean isRestrictedBoat(ItemStack item) {
        String itemType = item.getType().name().toLowerCase();
        return this.restrictedBoats.contains(itemType);
    }

    private boolean isWorldRestricted(String worldName) {
        return this.restrictedWorlds.contains(worldName);
    }

    private void handleRestrictedPlacement(Player player) {
        player.sendMessage(this.getLocalizedMessage("deny-message"));
        if (this.playErrorSound && this.errorSound != null) {
            player.playSound(player.getLocation(), this.errorSound, 1.0f, 1.0f);
        }
    }

    private String getLocalizedMessage(String key) {
        if (this.languageConfig == null) {
            return "\u00a7c[\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u044f\u0437\u044b\u043a\u0430]";
        }
        String message = this.languageConfig.getString(key);
        return message != null ? message : "\u00a7c[\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + key + "]";
    }

    Set<String> getRestrictedWorlds() {
        return Collections.unmodifiableSet(this.restrictedWorlds);
    }

    Set<String> getRestrictedBoats() {
        return Collections.unmodifiableSet(this.restrictedBoats);
    }

    Sound getErrorSound() {
        return this.errorSound;
    }

    boolean isPlayErrorSound() {
        return this.playErrorSound;
    }
}

