/*
 * Decompiled with CFR 0.152.
 */
package ru.velfan;

import java.io.File;
import java.util.ResourceBundle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class NineEyes
extends JavaPlugin
implements CommandExecutor {
    private ResourceBundle lang;

    public void onEnable() {
        this.saveDefaultConfig();
        String langCode = this.getConfig().getString("language", "en_US");
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        this.saveResource("lang/en_US.properties", true);
        this.saveResource("lang/ru_RU.properties", true);
        this.lang = ResourceBundle.getBundle("lang/" + langCode);
        this.getCommand("nightvision").setExecutor((CommandExecutor)this);
        this.getLogger().info("NineEyes plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("NineEyes plugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        try {
            String effectAction;
            if (!cmd.getName().equalsIgnoreCase("nightvision")) {
                return false;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.lang.getString("command_only_for_players"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("nineeyes.nightvision")) {
                player.sendMessage(this.lang.getString("no_permission"));
                return true;
            }
            Player target = player;
            if (args.length > 0 && (target = this.getServer().getPlayer(args[0])) == null) {
                sender.sendMessage(this.lang.getString("player_not_found"));
                return true;
            }
            boolean isSelf = target.equals((Object)player);
            if (target.hasPotionEffect(PotionEffectType.NIGHT_VISION)) {
                target.removePotionEffect(PotionEffectType.NIGHT_VISION);
                effectAction = "disabled";
                if (isSelf) {
                    player.sendMessage(this.lang.getString("night_vision_disabled"));
                } else {
                    player.sendMessage(this.lang.getString("night_vision_disabled_other").replace("%player%", target.getName()));
                }
            } else {
                int duration = this.getConfig().getInt("night_vision_duration", 6000);
                target.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, duration, 1));
                effectAction = "enabled";
                if (isSelf) {
                    player.sendMessage(this.lang.getString("night_vision_enabled"));
                } else {
                    player.sendMessage(this.lang.getString("night_vision_enabled_other").replace("%player%", target.getName()));
                }
            }
            String logMessage = String.format("[NightVision] %s %s night vision for %s", player.getName(), effectAction, isSelf ? "themselves" : target.getName());
            this.getLogger().info(logMessage);
            return true;
        }
        catch (Exception e) {
            this.getLogger().severe("Error executing command: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

