/*
 * Decompiled with CFR 0.152.
 */
package ru.VelFan.checkEffect;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class CheckEffect
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        this.getLogger().info("CheckEffect enabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("checkeffect")) {
            if (args.length == 0) {
                this.sendMessage(sender, this.getConfig().getString("consolevn", "&cUsage: /checkeffect <player|reload>"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("checkeffect.reload")) {
                    this.sendMessage(sender, this.getConfig().getString("messages.no-permission", "&cYou don't have permission!"));
                    return true;
                }
                this.reloadConfig();
                this.sendMessage(sender, this.getConfig().getString("messages.gsreload", "&aConfig reloaded!"));
                return true;
            }
            if (!sender.hasPermission("checkeffect.check")) {
                this.sendMessage(sender, this.getConfig().getString("messages.no-permission", "&cYou don't have permission!"));
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null) {
                this.sendMessage(sender, this.getConfig().getString("nulluser", "&cPlayer %player% not found!").replace("%player%", args[0]));
                return true;
            }
            String timeFormat = this.getConfig().getString("time-format", "HH:mm:ss");
            String currentTime = new SimpleDateFormat(timeFormat).format(new Date());
            String header = this.getConfig().getString("messages.effect-header", "&6Effects:").replace("%player%", target.getName()).replace("%time%", currentTime);
            this.sendMessage(sender, header);
            ConfigurationSection effects = this.getConfig().getConfigurationSection("effects");
            if (effects != null) {
                for (String effectKey : effects.getKeys(false)) {
                    PotionEffectType effectType = PotionEffectType.getByName((String)effectKey);
                    if (effectType == null) {
                        this.getLogger().warning("Invalid effect type in config: " + effectKey);
                        continue;
                    }
                    String displayName = effects.getString(effectKey, effectKey);
                    this.checkAndSendEffect(sender, target, effectType, displayName);
                }
            }
            return true;
        }
        return false;
    }

    private void checkAndSendEffect(CommandSender sender, Player target, PotionEffectType effectType, String displayName) {
        Object status;
        PotionEffect effect = target.getPotionEffect(effectType);
        if (effect != null && this.getConfig().getBoolean("show-duration", true)) {
            String duration = this.formatDuration(effect.getDuration());
            String durationMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.getConfig().getString("duration-format")).replace("%time%", duration));
            status = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("statuses.enable")) + " " + durationMsg;
        } else {
            status = effect != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("statuses.enable")) : ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("statuses.disable"));
        }
        String formattedDisplay = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName);
        sender.sendMessage(formattedDisplay + " " + (String)status);
    }

    private String formatDuration(int ticks) {
        if (ticks >= Short.MAX_VALUE || ticks <= 0) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.getConfig().getString("infinite-symbol", "&b\u267e")));
        }
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private void sendMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }
}

