/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.repository.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.repository.IUpdateRepository;

public class UpdateRepository
implements IUpdateRepository {
    private static final URL API_URL;
    private static final Gson GSON;

    @Override
    public CompletableFuture<SemanticVersion> getLatestPluginVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                BufferedReader bufferedReader = UpdateRepository.getBufferedReader();
                JsonArray result = (JsonArray)GSON.fromJson((Reader)bufferedReader, JsonArray.class);
                bufferedReader.close();
                return StreamSupport.stream(result.spliterator(), false).map(je -> je.getAsJsonObject().get("name").getAsString()).map(SemanticVersion::parse).max(Comparator.naturalOrder()).orElseThrow(() -> new RuntimeException("Can't find any version"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private static BufferedReader getBufferedReader() throws IOException {
        URLConnection connection = API_URL.openConnection();
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setRequestMethod("GET");
        httpConnection.setRequestProperty("Accept", "application/vnd.github+json");
        httpConnection.setRequestProperty("X-GitHub-Api-Version", "2022-11-28");
        httpConnection.setUseCaches(false);
        httpConnection.setDoOutput(true);
        return new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
    }

    static {
        GSON = new Gson();
        try {
            API_URL = new URL("https://api.github.com/repos/ValeraShimchuck/SimpleItemGenerator/tags");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

