/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.repository.impl;

import com.google.common.collect.Multimap;
import io.vavr.Tuple;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.config.ConfigLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.error.ConfigurationError;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.error.ErrorVisitor;
import ua.valeriishymchuk.simpleitemgenerator.common.item.HeadTexture;
import ua.valeriishymchuk.simpleitemgenerator.common.item.HeadTextureApplier;
import ua.valeriishymchuk.simpleitemgenerator.common.item.ItemPropertyType;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.item.RawItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.common.support.PapiSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.entity.CustomItemEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.CustomItemsStorageEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.result.ConfigLoadResultEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.result.ItemLoadResultEntity;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;

public class ItemRepository {
    private final IConfigRepository configRepository;
    private final ConfigLoader itemsConfigLoader;
    private final ErrorVisitor errorVisitor;
    private final Map<String, CustomItemEntity> items = new HashMap<String, CustomItemEntity>();

    public Set<String> getItemKeys() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public Option<CustomItemEntity> getItem(String key) {
        return Option.of(this.items.get(key));
    }

    public boolean hasFolder() {
        return this.itemsConfigLoader.getFolder().exists();
    }

    public void createExample() {
        this.itemsConfigLoader.save(CustomItemsStorageEntity.class, "example", new CustomItemsStorageEntity(() -> {
            HashMap<String, CustomItemEntity> map = new HashMap<String, CustomItemEntity>();
            map.put("example", CustomItemEntity.of(RawItem.EMPTY.withMaterial(Material.STONE.name()).withName("<white><bold>I have a custom name"), new ArrayList<UsageEntity>()));
            return map;
        }));
    }

    public Option<ItemStack> bakeItem(String key, @Nullable Player player) {
        CustomItemEntity customItem = (CustomItemEntity)this.getItem(key).getOrNull();
        if (customItem == null) {
            return Option.none();
        }
        ItemStack itemStack = customItem.getItemStack();
        NBTCustomItem.setCustomItemId(itemStack, key);
        this.updateItem(itemStack, player);
        return Option.some(itemStack);
    }

    public boolean updateItem(ItemStack itemStack, @Nullable Player player) {
        boolean shouldUpdateHeadTexture;
        String customItemId = (String)NBTCustomItem.getCustomItemId(itemStack).getOrNull();
        if (customItemId == null) {
            return false;
        }
        CustomItemEntity customItem = this.items.get(customItemId);
        if (customItem == null) {
            return false;
        }
        int configItemSignature = customItem.getSignature();
        Integer itemSignature = (Integer)NBTCustomItem.getSignature(itemStack).getOrNull();
        if (itemSignature != null & !customItem.autoUpdate()) {
            return false;
        }
        boolean isSameSignature = itemSignature != null && itemSignature == configItemSignature;
        String lastPlayer = (String)NBTCustomItem.getLastHolder(itemStack).getOrNull();
        String currentPlayer = (String)Option.of(player).map(OfflinePlayer::getName).getOrNull();
        Set<ItemPropertyType> itemPropertyTypes = customItem.getPropertiesToUpdate();
        boolean bl = shouldUpdateHeadTexture = itemPropertyTypes.contains((Object)ItemPropertyType.HEAD_TEXTURE) && customItem.getHeadTexture().map(t -> t.getValue().contains("%player%")).getOrElse(false) != false && !Objects.equals(lastPlayer, currentPlayer);
        if (!customItem.hasPlaceHolders() && isSameSignature && !shouldUpdateHeadTexture) {
            return false;
        }
        ItemStack configItemStack = customItem.getItemStack();
        if (shouldUpdateHeadTexture) {
            HeadTexture headTexture = customItem.getHeadTexture().get();
            HeadTextureApplier.apply(headTexture, configItemStack, s -> s.replace("%player%", player == null ? "n" : player.getName()));
            NBTCustomItem.setLastHolder(configItemStack, currentPlayer);
        }
        ItemMeta configItemMeta = configItemStack.getItemMeta();
        if (itemPropertyTypes.contains((Object)ItemPropertyType.MATERIAL) && itemStack.getType() != configItemStack.getType()) {
            itemStack.setType(configItemStack.getType());
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemPropertyTypes.forEach(type -> {
            switch (type) {
                case MATERIAL: {
                    break;
                }
                case NAME: {
                    Option.of(configItemMeta.displayName()).map(KyoriHelper::convert).map(component -> PapiSupport.tryParseComponent((OfflinePlayer)player, component)).map(KyoriHelper::convert).peek(arg_0 -> ((ItemMeta)itemMeta).displayName(arg_0));
                    break;
                }
                case LORE: {
                    itemMeta.lore(Option.of(configItemMeta.lore()).getOrElse(List.of()).stream().map(KyoriHelper::convert).map(line -> PapiSupport.tryParseComponent((OfflinePlayer)player, line)).map(KyoriHelper::convert).toList());
                    break;
                }
                case CUSTOM_MODEL_DATA: {
                    if (FeatureSupport.MODERN_CMD_SUPPORT) {
                        ReflectedRepresentations.ItemMeta.getModernCustomModelData(configItemMeta).peek(modernCmd -> ReflectedRepresentations.ItemMeta.setModernCustomModelData(itemMeta, modernCmd));
                        break;
                    }
                    if (!configItemMeta.hasCustomModelData()) break;
                    itemMeta.setCustomModelData(Integer.valueOf(configItemMeta.getCustomModelData()));
                    break;
                }
                case UNBREAKABLE: {
                    itemMeta.setUnbreakable(configItemMeta.isUnbreakable());
                    break;
                }
                case ITEM_FLAGS: {
                    Arrays.stream(ItemFlag.values()).forEach(xva$0 -> itemMeta.removeItemFlags(new ItemFlag[]{xva$0}));
                    itemMeta.addItemFlags(configItemMeta.getItemFlags().toArray(new ItemFlag[0]));
                    break;
                }
                case ENCHANTMENTS: {
                    itemMeta.getEnchants().forEach((e, l) -> itemMeta.removeEnchant(e));
                    configItemMeta.getEnchants().forEach((enchantment, level) -> itemMeta.addEnchant(enchantment, level.intValue(), true));
                    break;
                }
                case ATTRIBUTES: {
                    Multimap newAttributes;
                    Multimap oldAttributes = itemMeta.getAttributeModifiers();
                    if (oldAttributes != null) {
                        oldAttributes.keySet().forEach(arg_0 -> ((ItemMeta)itemMeta).removeAttributeModifier(arg_0));
                    }
                    if ((newAttributes = configItemMeta.getAttributeModifiers()) == null) break;
                    newAttributes.forEach((arg_0, arg_1) -> ((ItemMeta)itemMeta).addAttributeModifier(arg_0, arg_1));
                    break;
                }
                case COLOR: {
                    PotionMeta potionMeta;
                    Color newColor;
                    LeatherArmorMeta leatherArmorMeta;
                    if (configItemMeta instanceof LeatherArmorMeta) {
                        leatherArmorMeta = (LeatherArmorMeta)configItemMeta;
                        newColor = leatherArmorMeta.getColor();
                    } else if (configItemMeta instanceof PotionMeta) {
                        potionMeta = (PotionMeta)configItemMeta;
                        newColor = potionMeta.getColor();
                    } else {
                        newColor = null;
                    }
                    if (itemMeta instanceof LeatherArmorMeta) {
                        leatherArmorMeta = (LeatherArmorMeta)itemMeta;
                        leatherArmorMeta.setColor(Option.of(newColor).getOrElse(Bukkit.getItemFactory().getDefaultLeatherColor()));
                        break;
                    }
                    if (!(itemMeta instanceof PotionMeta)) break;
                    potionMeta = (PotionMeta)itemMeta;
                    potionMeta.setColor(newColor);
                    break;
                }
                case POTION_EFFECTS: {
                    if (!(configItemMeta instanceof PotionMeta)) break;
                    PotionMeta configPotionMeta = (PotionMeta)configItemMeta;
                    if (!(itemMeta instanceof PotionMeta)) break;
                    PotionMeta potionMeta = (PotionMeta)itemMeta;
                    potionMeta.clearCustomEffects();
                    potionMeta.setBasePotionData(configPotionMeta.getBasePotionData());
                    configPotionMeta.getCustomEffects().forEach(effect -> potionMeta.addCustomEffect(effect, true));
                    break;
                }
                case DURABILITY: {
                    if (!(configItemMeta instanceof Damageable)) break;
                    Damageable configDamageable = (Damageable)configItemMeta;
                    if (!(itemMeta instanceof Damageable)) break;
                    Damageable itemDamageable = (Damageable)itemMeta;
                    itemDamageable.setDamage(configDamageable.getDamage());
                }
            }
        });
        itemStack.setItemMeta(itemMeta);
        NBTCustomItem.setCustomItemId(itemStack, customItemId);
        NBTCustomItem.getSignature(configItemStack).peek(signature -> NBTCustomItem.setSignature(itemStack, signature));
        return true;
    }

    public boolean reloadItems() {
        this.items.clear();
        ConfigLoadResultEntity mainConfigLoadResult = this.configRepository.getConfig().init();
        ArrayList<InvalidConfigurationException> rawErrors = new ArrayList<InvalidConfigurationException>();
        rawErrors.addAll(mainConfigLoadResult.getItemLoad().getInvalidItems().values());
        rawErrors.addAll(mainConfigLoadResult.getExceptions());
        List<InvalidConfigurationException> errors = rawErrors.stream().map(e -> InvalidConfigurationException.format(e, "Error in file <white>%s</white>", "config.yml")).collect(Collectors.toList());
        this.items.putAll(this.configRepository.getConfig().getItems().getItems());
        Arrays.stream(this.itemsConfigLoader.getFolder().list()).map(f -> f.split("\\.")[0]).map(key -> Tuple.of(key, this.itemsConfigLoader.safeLoad(CustomItemsStorageEntity.class, (String)key))).filter(t -> {
            String configFile = (String)t._1;
            Validation result = (Validation)t._2;
            if (result.isValid() && ((Option)result.get()).isDefined()) {
                return true;
            }
            if (result.isInvalid()) {
                errors.add(InvalidConfigurationException.format(((ConfigurationError)result.getError()).asConfigException(), "Error in <white>%s.yml</white>", configFile));
                return false;
            }
            return false;
        }).map(t -> t.map2(Validation::get).map2(Option::get)).forEach(t -> {
            String key = (String)t._1;
            CustomItemsStorageEntity item = (CustomItemsStorageEntity)t._2;
            ItemLoadResultEntity loadResult = item.init(key);
            errors.addAll(loadResult.getInvalidItems().values().stream().map(e -> InvalidConfigurationException.format(e, "Error in file <white>%s</white>", "items/" + key + ".yml")).collect(Collectors.toList()));
            loadResult.getValidItems().forEach((itemKey, itemConfig) -> this.items.compute((String)itemKey, (k, v) -> {
                if (v != null) {
                    errors.add(InvalidConfigurationException.path(itemKey, InvalidConfigurationException.format("Duplicate item: <white>%s</white> in <white>%s.yml</white>", itemKey, key)));
                    return v;
                }
                return itemConfig;
            }));
        });
        errors.forEach(e -> {
            KyoriHelper.sendMessage((CommandSender)Bukkit.getConsoleSender(), "<red>[SimpleItemGenerator] Found error:</red>");
            this.errorVisitor.visitError((Throwable)e);
        });
        return errors.isEmpty();
    }

    @Generated
    public ItemRepository(IConfigRepository configRepository, ConfigLoader itemsConfigLoader, ErrorVisitor errorVisitor) {
        this.configRepository = configRepository;
        this.itemsConfigLoader = itemsConfigLoader;
        this.errorVisitor = errorVisitor;
    }
}

