/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.server;

import org.jetbrains.annotations.ApiStatus;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketSendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.ChatMessage;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.ChatMessageProcessor;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessorLegacy;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessor_v1_16;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessor_v1_19;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessor_v1_19_1;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessor_v1_19_3;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.message.reader.impl.ChatMessageProcessor_v1_21_5;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerChatMessage
extends PacketWrapper<WrapperPlayServerChatMessage> {
    private static final ChatMessageProcessor CHAT_LEGACY_PROCESSOR = new ChatMessageProcessorLegacy();
    private static final ChatMessageProcessor CHAT_V1_16_PROCESSOR = new ChatMessageProcessor_v1_16();
    private static final ChatMessageProcessor CHAT_V1_19_PROCESSOR = new ChatMessageProcessor_v1_19();
    private static final ChatMessageProcessor CHAT_V1_19_1_PROCESSOR = new ChatMessageProcessor_v1_19_1();
    private static final ChatMessageProcessor CHAT_V1_19_3_PROCESSOR = new ChatMessageProcessor_v1_19_3();
    private static final ChatMessageProcessor CHAT_V1_21_5_PROCESSOR = new ChatMessageProcessor_v1_21_5();
    private ChatMessage message;

    public WrapperPlayServerChatMessage(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerChatMessage(ChatMessage message) {
        super(PacketType.Play.Server.CHAT_MESSAGE);
        this.message = message;
    }

    @Override
    public void read() {
        this.message = this.getProcessor().readChatMessage(this);
    }

    @Override
    public void write() {
        this.getProcessor().writeChatMessage(this, this.message);
    }

    @Override
    public void copy(WrapperPlayServerChatMessage wrapper) {
        this.message = wrapper.message;
    }

    public ChatMessage getMessage() {
        return this.message;
    }

    public void setMessage(ChatMessage message) {
        this.message = message;
    }

    @ApiStatus.Internal
    protected ChatMessageProcessor getProcessor() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            return CHAT_V1_21_5_PROCESSOR;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            return CHAT_V1_19_3_PROCESSOR;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_1)) {
            return CHAT_V1_19_1_PROCESSOR;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            return CHAT_V1_19_PROCESSOR;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return CHAT_V1_16_PROCESSOR;
        }
        return CHAT_LEGACY_PROCESSOR;
    }
}

