/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.client;

import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientSetBeaconEffect
extends PacketWrapper<WrapperPlayClientSetBeaconEffect> {
    private int primaryEffect;
    private int secondaryEffect;

    public WrapperPlayClientSetBeaconEffect(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientSetBeaconEffect(int primaryEffect, int secondaryEffect) {
        super(PacketType.Play.Client.SET_BEACON_EFFECT);
        this.primaryEffect = primaryEffect;
        this.secondaryEffect = secondaryEffect;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.primaryEffect = this.readOptionalEffect();
            this.secondaryEffect = this.readOptionalEffect();
        } else {
            this.primaryEffect = this.readVarInt();
            this.secondaryEffect = this.readVarInt();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeOptionalEffect(this.primaryEffect);
            this.writeOptionalEffect(this.secondaryEffect);
        } else {
            this.writeVarInt(this.primaryEffect);
            this.writeVarInt(this.secondaryEffect);
        }
    }

    @Override
    public void copy(WrapperPlayClientSetBeaconEffect wrapper) {
        this.primaryEffect = wrapper.primaryEffect;
        this.secondaryEffect = wrapper.secondaryEffect;
    }

    public int getPrimaryEffect() {
        return this.primaryEffect;
    }

    public void setPrimaryEffect(int primaryEffect) {
        this.primaryEffect = primaryEffect;
    }

    public int getSecondaryEffect() {
        return this.secondaryEffect;
    }

    public void setSecondaryEffect(int secondaryEffect) {
        this.secondaryEffect = secondaryEffect;
    }

    private int readOptionalEffect() {
        if (this.readBoolean()) {
            return this.readVarInt();
        }
        return -1;
    }

    private void writeOptionalEffect(int effect) {
        this.writeBoolean(effect != -1);
        if (effect != -1) {
            this.writeVarInt(effect);
        }
    }
}

