/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketSendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.ProtocolPacketEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.VersionComparison;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.netty.buffer.ByteBufHelper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.netty.channel.ChannelHelper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.PacketSide;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.ChatType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.ChatTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.LastSeenMessages;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.MessageSignature;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.Node;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.Parsers;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.RemoteChatSession;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.SignedCommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.filter.FilterMask;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.filter.FilterMaskType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.data.EntityData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.data.EntityDataType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.data.EntityDataTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.data.EntityMetadataProvider;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.villager.VillagerData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.villager.profession.VillagerProfession;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.villager.type.VillagerType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.villager.type.VillagerTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.ItemStack;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.ItemStackSerialization;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTEnd;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTLimiter;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.codec.NBTCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketTypeCommon;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.GameMode;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.PublicProfileKey;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.User;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.recipe.data.MerchantItemCost;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.recipe.data.MerchantOffer;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.Dimension;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.WorldBlockPosition;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.Either;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.KnownPack;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.MathUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.StringUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.Vector3i;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.adventure.AdventureSerializer;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.crypto.MinecraftEncryptionUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.crypto.SaltSignature;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.crypto.SignatureData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.GlobalRegistryHolder;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.IRegistry;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.IRegistryHolder;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketTypeData;

public class PacketWrapper<T extends PacketWrapper<T>> {
    @Nullable
    public Object buffer;
    @ApiStatus.Internal
    public final Object bufferLock = new Object();
    protected ClientVersion clientVersion;
    protected ServerVersion serverVersion;
    private PacketTypeData packetTypeData;
    @Nullable
    protected User user;
    private static final int MODERN_MESSAGE_LENGTH = 262144;
    private static final int LEGACY_MESSAGE_LENGTH = Short.MAX_VALUE;

    public PacketWrapper(ClientVersion clientVersion, ServerVersion serverVersion, int packetID) {
        if (packetID == -1) {
            throw new IllegalArgumentException("Packet does not exist on this protocol version!");
        }
        this.clientVersion = clientVersion;
        this.serverVersion = serverVersion;
        this.buffer = null;
        this.packetTypeData = new PacketTypeData(null, packetID);
    }

    public PacketWrapper(PacketReceiveEvent event) {
        this(event, true);
    }

    public PacketWrapper(PacketReceiveEvent event, boolean readData) {
        this.clientVersion = event.getUser().getClientVersion();
        this.serverVersion = event.getServerVersion();
        this.user = event.getUser();
        this.buffer = event.getByteBuf();
        this.packetTypeData = new PacketTypeData(event.getPacketType(), event.getPacketId());
        if (readData) {
            this.readEvent(event);
        }
    }

    public PacketWrapper(PacketSendEvent event) {
        this(event, true);
    }

    public PacketWrapper(PacketSendEvent event, boolean readData) {
        this.clientVersion = event.getUser().getClientVersion();
        this.serverVersion = event.getServerVersion();
        this.buffer = event.getByteBuf();
        this.packetTypeData = new PacketTypeData(event.getPacketType(), event.getPacketId());
        this.user = event.getUser();
        if (readData) {
            this.readEvent(event);
        }
    }

    public PacketWrapper(int packetID, ClientVersion clientVersion) {
        this(clientVersion, PacketEvents.getAPI().getServerManager().getVersion(), packetID);
    }

    public PacketWrapper(int packetID) {
        if (packetID == -1) {
            throw new IllegalArgumentException("Packet does not exist on this protocol version!");
        }
        this.clientVersion = ClientVersion.UNKNOWN;
        this.serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        this.buffer = null;
        this.packetTypeData = new PacketTypeData(null, packetID);
    }

    public PacketWrapper(PacketTypeCommon packetType) {
        this.clientVersion = ClientVersion.UNKNOWN;
        this.serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        this.buffer = null;
        int id = packetType.getId(this.serverVersion.toClientVersion());
        this.packetTypeData = new PacketTypeData(packetType, id);
    }

    public static PacketWrapper<?> createDummyWrapper(ClientVersion version) {
        return new PacketWrapper(version, version.toServerVersion(), -2);
    }

    public static PacketWrapper<?> createUniversalPacketWrapper(Object byteBuf) {
        return PacketWrapper.createUniversalPacketWrapper(byteBuf, PacketEvents.getAPI().getServerManager().getVersion());
    }

    public static PacketWrapper<?> createUniversalPacketWrapper(Object byteBuf, ServerVersion version) {
        PacketWrapper wrapper = new PacketWrapper(ClientVersion.UNKNOWN, version, -2);
        wrapper.buffer = byteBuf;
        return wrapper;
    }

    public static int getChunkX(long chunkKey) {
        return (int)(chunkKey & 0xFFFFFFFFL);
    }

    public static int getChunkZ(long chunkKey) {
        return (int)(chunkKey >>> 32 & 0xFFFFFFFFL);
    }

    public static long getChunkKey(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    @ApiStatus.Internal
    public final void prepareForSend(Object channel, boolean outgoing, boolean proxy) {
        if (this.buffer == null || ByteBufHelper.refCnt(this.buffer) == 0) {
            this.buffer = ChannelHelper.pooledByteBuf(channel);
        }
        if (proxy) {
            User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
            if (this.packetTypeData.getPacketType() == null) {
                this.packetTypeData.setPacketType(PacketType.getById(outgoing ? PacketSide.SERVER : PacketSide.CLIENT, user.getConnectionState(), this.serverVersion.toClientVersion(), this.packetTypeData.getNativePacketId()));
            }
            this.serverVersion = user.getClientVersion().toServerVersion();
            int id = this.packetTypeData.getPacketType().getId(user.getClientVersion());
            this.writeVarInt(id);
        } else {
            this.writeVarInt(this.packetTypeData.getNativePacketId());
        }
        this.write();
    }

    @ApiStatus.Internal
    public final void prepareForSend(Object channel, boolean outgoing) {
        this.prepareForSend(channel, outgoing, PacketEvents.getAPI().getInjector().isProxy());
    }

    public void read() {
    }

    public void write() {
    }

    public void copy(T wrapper) {
    }

    public final void readEvent(ProtocolPacketEvent event) {
        PacketWrapper<?> last = event.getLastUsedWrapper();
        if (this.getClass().isInstance(last)) {
            this.copy(last);
        } else {
            this.read();
        }
        event.setLastUsedWrapper(this);
    }

    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public Object getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Object buffer) {
        this.buffer = buffer;
    }

    @Deprecated
    public int getPacketId() {
        return this.getNativePacketId();
    }

    @Deprecated
    public void setPacketId(int packetID) {
        this.setNativePacketId(packetID);
    }

    public int getNativePacketId() {
        return this.packetTypeData.getNativePacketId();
    }

    public void setNativePacketId(int nativePacketId) {
        this.packetTypeData.setNativePacketId(nativePacketId);
    }

    @ApiStatus.Internal
    public PacketTypeData getPacketTypeData() {
        return this.packetTypeData;
    }

    public int getMaxMessageLength() {
        return this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? 262144 : Short.MAX_VALUE;
    }

    @Deprecated
    public void resetByteBuf() {
        ByteBufHelper.clear(this.buffer);
    }

    public void resetBuffer() {
        ByteBufHelper.clear(this.buffer);
    }

    public byte readByte() {
        return ByteBufHelper.readByte(this.buffer);
    }

    public void writeByte(int value) {
        ByteBufHelper.writeByte(this.buffer, value);
    }

    public short readUnsignedByte() {
        return ByteBufHelper.readUnsignedByte(this.buffer);
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public void writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
    }

    public int readInt() {
        return ByteBufHelper.readInt(this.buffer);
    }

    public void writeInt(int value) {
        ByteBufHelper.writeInt(this.buffer, value);
    }

    public long readUnsignedInt() {
        return ByteBufHelper.readUnsignedInt(this.buffer);
    }

    public int readMedium() {
        return ByteBufHelper.readMedium(this.buffer);
    }

    public void writeMedium(int value) {
        ByteBufHelper.writeMedium(this.buffer, value);
    }

    public int readVarInt() {
        byte currentByte;
        int value = 0;
        int length = 0;
        do {
            currentByte = this.readByte();
            value |= (currentByte & 0x7F) << length * 7;
            if (++length <= 5) continue;
            throw new RuntimeException("VarInt is too large. Must be smaller than 5 bytes.");
        } while ((currentByte & 0x80) == 128);
        return value;
    }

    public void writeVarInt(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            this.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            this.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            this.writeInt(w);
            this.writeByte(value >>> 28);
        }
    }

    public <K, V> Map<K, V> readMap(Reader<K> keyFunction, Reader<V> valueFunction) {
        return this.readMap(keyFunction, valueFunction, Integer.MAX_VALUE);
    }

    public <K, V> Map<K, V> readMap(Reader<K> keyFunction, Reader<V> valueFunction, int maxSize) {
        int size = this.readVarInt();
        if (size > maxSize) {
            throw new RuntimeException(size + " elements exceeded max size of: " + maxSize);
        }
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyFunction.apply(this);
            Object value = valueFunction.apply(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> void writeMap(Map<K, V> map, Writer<K> keyConsumer, Writer<V> valueConsumer) {
        this.writeVarInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            keyConsumer.accept(this, key);
            valueConsumer.accept(this, value);
        }
    }

    public VillagerData readVillagerData() {
        VillagerType type = this.readMappedEntity((IRegistry)VillagerTypes.getRegistry());
        VillagerProfession profession = this.readMappedEntity((IRegistry)VillagerProfessions.getRegistry());
        int level = this.readVarInt();
        return new VillagerData(type, profession, level);
    }

    public void writeVillagerData(VillagerData data) {
        this.writeMappedEntity(data.getType());
        this.writeMappedEntity(data.getProfession());
        this.writeVarInt(data.getLevel());
    }

    public ItemStack readItemStackModern() {
        return ItemStackSerialization.readModern(this);
    }

    public ItemStack readPresentItemStack() {
        ItemStack itemStack = this.readItemStack();
        if (itemStack.isEmpty()) {
            throw new RuntimeException("Empty ItemStack not allowed");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack readItemStack() {
        return ItemStackSerialization.read(this);
    }

    public void writeItemStackModern(ItemStack stack) {
        ItemStackSerialization.writeModern(this, stack);
    }

    public void writePresentItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            throw new RuntimeException("Empty ItemStack not allowed");
        }
        this.writeItemStack(itemStack);
    }

    public void writeItemStack(ItemStack stack) {
        ItemStackSerialization.write(this, stack);
    }

    public NBTCompound readNBT() {
        return (NBTCompound)this.readNBTRaw();
    }

    @Nullable
    public NBT readNullableNBT() {
        NBT tag = this.readNBTRaw();
        return tag == NBTEnd.INSTANCE ? null : tag;
    }

    public NBT readNBTRaw() {
        return NBTCodec.readNBTFromBuffer(this.buffer, this.serverVersion);
    }

    public NBTCompound readUnlimitedNBT() {
        return (NBTCompound)this.readUnlimitedNBTRaw();
    }

    public NBT readUnlimitedNBTRaw() {
        return NBTCodec.readNBTFromBuffer(this.buffer, this.serverVersion, NBTLimiter.noop());
    }

    public void writeNBT(NBTCompound nbt) {
        this.writeNBTRaw(nbt);
    }

    public void writeNBTRaw(NBT nbt) {
        NBTCodec.writeNBTToBuffer(this.buffer, this.serverVersion, nbt);
    }

    public String readString() {
        return this.readString(Short.MAX_VALUE);
    }

    public String readString(int maxLen) {
        int j = this.readVarInt();
        if (j > maxLen * 4) {
            throw new RuntimeException("The received encoded string buffer length is longer than maximum allowed (" + j + " > " + maxLen * 4 + ")");
        }
        if (j < 0) {
            throw new RuntimeException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = ByteBufHelper.toString(this.buffer, ByteBufHelper.readerIndex(this.buffer), j, StandardCharsets.UTF_8);
        ByteBufHelper.readerIndex(this.buffer, ByteBufHelper.readerIndex(this.buffer) + j);
        if (s.length() > maxLen) {
            throw new RuntimeException("The received string length is longer than maximum allowed (" + j + " > " + maxLen + ")");
        }
        return s;
    }

    @Deprecated
    public String readComponentJSON() {
        return this.getSerializers().asJson(this.readComponent());
    }

    public void writeString(String s) {
        this.writeString(s, Short.MAX_VALUE);
    }

    public void writeString(String s, int maxLen) {
        this.writeString(s, maxLen, true);
    }

    public void writeString(String s, int maxLen, boolean substr) {
        if (substr) {
            s = StringUtil.maximizeLength(s, maxLen);
        }
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        if (!substr && bytes.length > maxLen) {
            throw new IllegalStateException("String too big (was " + bytes.length + " bytes encoded, max " + maxLen + ")");
        }
        this.writeVarInt(bytes.length);
        ByteBufHelper.writeBytes(this.buffer, bytes);
    }

    public AdventureSerializer getSerializers() {
        return AdventureSerializer.serializer(this);
    }

    @Deprecated
    public void writeComponentJSON(String json) {
        this.writeComponent(this.getSerializers().fromJson(json));
    }

    public Component readComponent() {
        return this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3) ? this.readComponentAsNBT() : this.readComponentAsJSON();
    }

    public Component readComponentAsNBT() {
        return this.getSerializers().fromNbtTag(this.readNBTRaw(), this);
    }

    public Component readComponentAsJSON() {
        String jsonString = this.readString(this.getMaxMessageLength());
        return this.getSerializers().fromJson(jsonString);
    }

    public void writeComponent(Component component) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.writeComponentAsNBT(component);
        } else {
            this.writeComponentAsJSON(component);
        }
    }

    public void writeComponentAsNBT(Component component) {
        this.writeNBTRaw(this.getSerializers().asNbtTag(component, this));
    }

    public void writeComponentAsJSON(Component component) {
        String jsonString = this.getSerializers().asJson(component);
        this.writeString(jsonString, this.getMaxMessageLength());
    }

    public Style readStyle() {
        return this.getSerializers().nbt().deserializeStyle(this.readNBT(), this);
    }

    public void writeStyle(Style style) {
        this.writeNBT(this.getSerializers().nbt().serializeStyle(style, this));
    }

    public ResourceLocation readIdentifier(int maxLen) {
        return new ResourceLocation(this.readString(maxLen));
    }

    public ResourceLocation readIdentifier() {
        return this.readIdentifier(Short.MAX_VALUE);
    }

    public void writeIdentifier(ResourceLocation identifier, int maxLen) {
        this.writeString(identifier.toString(), maxLen);
    }

    public void writeIdentifier(ResourceLocation identifier) {
        this.writeIdentifier(identifier, Short.MAX_VALUE);
    }

    public int readUnsignedShort() {
        return ByteBufHelper.readUnsignedShort(this.buffer);
    }

    public short readShort() {
        return ByteBufHelper.readShort(this.buffer);
    }

    public void writeShort(int value) {
        ByteBufHelper.writeShort(this.buffer, value);
    }

    public void writeShortLE(int value) {
        ByteBufHelper.writeShortLE(this.buffer, value);
    }

    public int readVarShort() {
        int low = this.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = this.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public void writeVarShort(int value) {
        int low = value & Short.MAX_VALUE;
        int high = (value & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        this.writeShort(low);
        if (high != 0) {
            this.writeByte(high);
        }
    }

    public long readLong() {
        return ByteBufHelper.readLong(this.buffer);
    }

    public void writeLong(long value) {
        ByteBufHelper.writeLong(this.buffer, value);
    }

    public long readVarLong() {
        byte b;
        long value = 0L;
        int size = 0;
        while (((b = this.readByte()) & 0x80) == 128) {
            value |= (long)(b & 0x7F) << size++ * 7;
        }
        return value | (long)(b & 0x7F) << size * 7;
    }

    public void writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
        this.writeByte((int)l);
    }

    public float readFloat() {
        return ByteBufHelper.readFloat(this.buffer);
    }

    public void writeFloat(float value) {
        ByteBufHelper.writeFloat(this.buffer, value);
    }

    public double readDouble() {
        return ByteBufHelper.readDouble(this.buffer);
    }

    public void writeDouble(double value) {
        ByteBufHelper.writeDouble(this.buffer, value);
    }

    public byte[] readRemainingBytes() {
        return this.readBytes(ByteBufHelper.readableBytes(this.buffer));
    }

    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        ByteBufHelper.readBytes(this.buffer, bytes);
        return bytes;
    }

    public void writeBytes(byte[] array) {
        ByteBufHelper.writeBytes(this.buffer, array);
    }

    public byte[] readByteArray(int maxLength) {
        int len = this.readVarInt();
        if (len > maxLength) {
            throw new RuntimeException("The received byte array length is longer than maximum allowed (" + len + " > " + maxLength + ")");
        }
        return this.readBytes(len);
    }

    public byte[] readByteArray() {
        return this.readByteArray(ByteBufHelper.readableBytes(this.buffer));
    }

    public void writeByteArray(byte[] array) {
        this.writeVarInt(array.length);
        this.writeBytes(array);
    }

    public int[] readVarIntArray() {
        int readableBytes = ByteBufHelper.readableBytes(this.buffer);
        int size = this.readVarInt();
        if (size > readableBytes) {
            throw new IllegalStateException("VarIntArray with size " + size + " is bigger than allowed " + readableBytes);
        }
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public void writeVarIntArray(int[] array) {
        this.writeVarInt(array.length);
        for (int i : array) {
            this.writeVarInt(i);
        }
    }

    public long[] readLongArray(int size) {
        long[] array = new long[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public byte[] readByteArrayOfSize(int size) {
        byte[] array = new byte[size];
        ByteBufHelper.readBytes(this.buffer, array);
        return array;
    }

    public void writeByteArrayOfSize(byte[] array) {
        ByteBufHelper.writeBytes(this.buffer, array);
    }

    public int[] readVarIntArrayOfSize(int size) {
        int[] array = new int[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public void writeVarIntArrayOfSize(int[] array) {
        for (int i : array) {
            this.writeVarInt(i);
        }
    }

    public long[] readLongArray() {
        int readableBytes = ByteBufHelper.readableBytes(this.buffer) / 8;
        int size = this.readVarInt();
        if (size > readableBytes) {
            throw new IllegalStateException("LongArray with size " + size + " is bigger than allowed " + readableBytes);
        }
        long[] array = new long[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public void writeLongArray(long[] array) {
        this.writeVarInt(array.length);
        for (long l : array) {
            this.writeLong(l);
        }
    }

    public UUID readUUID() {
        long mostSigBits = this.readLong();
        long leastSigBits = this.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public Vector3i readBlockPosition() {
        long val = this.readLong();
        return new Vector3i(val, this.serverVersion);
    }

    public void writeBlockPosition(Vector3i pos) {
        long val = pos.getSerializedPosition(this.serverVersion);
        this.writeLong(val);
    }

    public GameMode readGameMode() {
        return GameMode.getById(this.readByte());
    }

    public void writeGameMode(@Nullable GameMode mode) {
        int id = mode == null ? -1 : mode.getId();
        this.writeByte(id);
    }

    public List<EntityData<?>> readEntityMetadata() {
        ArrayList list = new ArrayList();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            short index;
            boolean v1_10 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_10);
            while ((index = this.readUnsignedByte()) != 255) {
                int typeID = v1_10 ? this.readVarInt() : (int)this.readUnsignedByte();
                EntityDataType<?> type = EntityDataTypes.getById(this.serverVersion.toClientVersion(), typeID);
                if (type == null) {
                    throw new IllegalStateException("Unknown entity metadata type id: " + typeID + " version " + (Object)((Object)this.serverVersion.toClientVersion()));
                }
                list.add(new EntityData(index, type, type.read(this)));
            }
        } else {
            byte data = this.readByte();
            while (data != 127) {
                int typeID = (data & 0xE0) >> 5;
                int index = data & 0x1F;
                EntityDataType<?> type = EntityDataTypes.getById(this.serverVersion.toClientVersion(), typeID);
                EntityData entityData = new EntityData(index, type, type.read(this));
                list.add(entityData);
                data = this.readByte();
            }
        }
        return list;
    }

    public void writeEntityMetadata(List<EntityData<?>> list) {
        if (list == null) {
            list = new ArrayList();
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            boolean v1_10 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_10);
            for (EntityData<?> entityData : list) {
                this.writeByte(entityData.getIndex());
                if (v1_10) {
                    this.writeVarInt(entityData.getType().getId(this.serverVersion.toClientVersion()));
                } else {
                    this.writeByte(entityData.getType().getId(this.serverVersion.toClientVersion()));
                }
                entityData.getType().write(this, entityData.getValue());
            }
            this.writeByte(255);
        } else {
            for (EntityData<?> entityData : list) {
                int typeID = entityData.getType().getId(this.serverVersion.toClientVersion());
                int index = entityData.getIndex();
                int data = (typeID << 5 | index & 0x1F) & 0xFF;
                this.writeByte(data);
                entityData.getType().write(this, entityData.getValue());
            }
            this.writeByte(127);
        }
    }

    public void writeEntityMetadata(EntityMetadataProvider metadata) {
        this.writeEntityMetadata(metadata.entityData(this.serverVersion.toClientVersion()));
    }

    @Deprecated
    public Dimension readDimension() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            return new Dimension(this.readVarInt());
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19) || this.serverVersion.isOlderThan(ServerVersion.V_1_16_2)) {
            Dimension dimension = new Dimension(new NBTCompound());
            dimension.setDimensionName(this.readIdentifier().toString());
            return dimension;
        }
        return new Dimension(this.readNBT());
    }

    @Deprecated
    public void writeDimension(Dimension dimension) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            this.writeVarInt(dimension.getId());
            return;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19) || this.serverVersion.isOlderThan(ServerVersion.V_1_16_2)) {
            this.writeString(dimension.getDimensionName(), Short.MAX_VALUE);
        } else {
            this.writeNBT(dimension.getAttributes());
        }
    }

    public SaltSignature readSaltSignature() {
        long salt = this.readLong();
        byte[] signature = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? (this.readBoolean() ? this.readBytes(256) : new byte[]{}) : this.readByteArray(256);
        return new SaltSignature(salt, signature);
    }

    public void writeSaltSignature(SaltSignature signature) {
        this.writeLong(signature.getSalt());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            boolean present = signature.getSignature().length != 0;
            this.writeBoolean(present);
            if (present) {
                this.writeBytes(signature.getSignature());
            }
        } else {
            this.writeByteArray(signature.getSignature());
        }
    }

    public PublicKey readPublicKey() {
        return MinecraftEncryptionUtil.publicKey(this.readByteArray(512));
    }

    public void writePublicKey(PublicKey publicKey) {
        this.writeByteArray(publicKey.getEncoded());
    }

    public PublicProfileKey readPublicProfileKey() {
        Instant expiresAt = this.readTimestamp();
        PublicKey key = this.readPublicKey();
        byte[] keySignature = this.readByteArray(4096);
        return new PublicProfileKey(expiresAt, key, keySignature);
    }

    public void writePublicProfileKey(PublicProfileKey key) {
        this.writeTimestamp(key.getExpiresAt());
        this.writePublicKey(key.getKey());
        this.writeByteArray(key.getKeySignature());
    }

    public RemoteChatSession readRemoteChatSession() {
        return new RemoteChatSession(this.readUUID(), this.readPublicProfileKey());
    }

    public void writeRemoteChatSession(RemoteChatSession chatSession) {
        this.writeUUID(chatSession.getSessionId());
        this.writePublicProfileKey(chatSession.getPublicProfileKey());
    }

    public Instant readTimestamp() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeTimestamp(Instant timestamp) {
        this.writeLong(timestamp.toEpochMilli());
    }

    public SignatureData readSignatureData() {
        return new SignatureData(this.readTimestamp(), this.readPublicKey(), this.readByteArray(4096));
    }

    public void writeSignatureData(SignatureData signatureData) {
        this.writeTimestamp(signatureData.getTimestamp());
        this.writePublicKey(signatureData.getPublicKey());
        this.writeByteArray(signatureData.getSignature());
    }

    public static <K> IntFunction<K> limitValue(IntFunction<K> function, int limit) {
        return i -> {
            if (i > limit) {
                throw new RuntimeException("Value " + i + " is larger than limit " + limit);
            }
            return function.apply(i);
        };
    }

    public WorldBlockPosition readWorldBlockPosition() {
        return new WorldBlockPosition(this.readIdentifier(), this.readBlockPosition());
    }

    public void writeWorldBlockPosition(WorldBlockPosition pos) {
        this.writeIdentifier(pos.getWorld());
        this.writeBlockPosition(pos.getBlockPosition());
    }

    public LastSeenMessages.Entry readLastSeenMessagesEntry() {
        return new LastSeenMessages.Entry(this.readUUID(), this.readByteArray());
    }

    public void writeLastMessagesEntry(LastSeenMessages.Entry entry) {
        this.writeUUID(entry.getUUID());
        this.writeByteArray(entry.getLastVerifier());
    }

    public LastSeenMessages.Update readLastSeenMessagesUpdate() {
        int signedMessages = this.readVarInt();
        BitSet seen = BitSet.valueOf(this.readBytes(3));
        byte checksum = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5) ? this.readByte() : (byte)0;
        return new LastSeenMessages.Update(signedMessages, seen, checksum);
    }

    public void writeLastSeenMessagesUpdate(LastSeenMessages.Update update) {
        this.writeVarInt(update.getOffset());
        this.writeBytes(Arrays.copyOf(update.getAcknowledged().toByteArray(), 3));
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            this.writeByte(update.getChecksum());
        }
    }

    public LastSeenMessages.LegacyUpdate readLegacyLastSeenMessagesUpdate() {
        LastSeenMessages lastSeenMessages = this.readLastSeenMessages();
        LastSeenMessages.Entry lastReceived = (LastSeenMessages.Entry)this.readOptional(PacketWrapper::readLastSeenMessagesEntry);
        return new LastSeenMessages.LegacyUpdate(lastSeenMessages, lastReceived);
    }

    public void writeLegacyLastSeenMessagesUpdate(LastSeenMessages.LegacyUpdate legacyUpdate) {
        this.writeLastSeenMessages(legacyUpdate.getLastSeenMessages());
        this.writeOptional(legacyUpdate.getLastReceived(), PacketWrapper::writeLastMessagesEntry);
    }

    public MessageSignature readMessageSignature() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            return new MessageSignature(this.readBytes(256));
        }
        return new MessageSignature(this.readByteArray());
    }

    public void writeMessageSignature(MessageSignature messageSignature) {
        this.writeBytes(messageSignature.getBytes());
    }

    public MessageSignature.Packed readMessageSignaturePacked() {
        int id = this.readVarInt() - 1;
        if (id == -1) {
            return new MessageSignature.Packed(new MessageSignature(this.readBytes(256)));
        }
        return new MessageSignature.Packed(id);
    }

    public void writeMessageSignaturePacked(MessageSignature.Packed messageSignaturePacked) {
        this.writeVarInt(messageSignaturePacked.getId() + 1);
        if (messageSignaturePacked.getFullSignature().isPresent()) {
            this.writeBytes(messageSignaturePacked.getFullSignature().get().getBytes());
        }
    }

    public LastSeenMessages.Packed readLastSeenMessagesPacked() {
        List packedMessageSignatures = this.readCollection(PacketWrapper.limitValue(ArrayList::new, 20), PacketWrapper::readMessageSignaturePacked);
        return new LastSeenMessages.Packed(packedMessageSignatures);
    }

    public void writeLastSeenMessagesPacked(LastSeenMessages.Packed lastSeenMessagesPacked) {
        this.writeCollection(lastSeenMessagesPacked.getPackedMessageSignatures(), PacketWrapper::writeMessageSignaturePacked);
    }

    public LastSeenMessages readLastSeenMessages() {
        List entries = this.readCollection(PacketWrapper.limitValue(ArrayList::new, 5), PacketWrapper::readLastSeenMessagesEntry);
        return new LastSeenMessages(entries);
    }

    public void writeLastSeenMessages(LastSeenMessages lastSeenMessages) {
        this.writeCollection(lastSeenMessages.getEntries(), PacketWrapper::writeLastMessagesEntry);
    }

    public List<SignedCommandArgument> readSignedCommandArguments() {
        return this.readCollection(PacketWrapper.limitValue(ArrayList::new, 8), _packet -> new SignedCommandArgument(this.readString(16), this.readMessageSignature()));
    }

    public void writeSignedCommandArguments(List<SignedCommandArgument> signedArguments) {
        this.writeCollection(signedArguments, (_packet, argument) -> {
            this.writeString(argument.getArgument(), 16);
            this.writeMessageSignature(argument.getSignature());
        });
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet bitSet) {
        this.writeLongArray(bitSet.toLongArray());
    }

    public FilterMask readFilterMask() {
        FilterMaskType type = FilterMaskType.getById(this.readVarInt());
        switch (type) {
            case PARTIALLY_FILTERED: {
                return new FilterMask(this.readBitSet());
            }
            case PASS_THROUGH: {
                return FilterMask.PASS_THROUGH;
            }
            case FULLY_FILTERED: {
                return FilterMask.FULLY_FILTERED;
            }
        }
        return null;
    }

    public void writeFilterMask(FilterMask filterMask) {
        this.writeVarInt(filterMask.getType().getId());
        if (filterMask.getType() == FilterMaskType.PARTIALLY_FILTERED) {
            this.writeBitSet(filterMask.getMask());
        }
    }

    public MerchantOffer readMerchantOffer() {
        ItemStack buyItemPrimary = MerchantItemCost.readItem(this);
        ItemStack sellItem = this.readItemStack();
        ItemStack buyItemSecondary = this.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) || this.getServerVersion().isOlderThan(ServerVersion.V_1_19) ? (ItemStack)this.readOptional(MerchantItemCost::readItem) : this.readItemStack();
        boolean tradeDisabled = this.readBoolean();
        int uses = this.readInt();
        int maxUses = this.readInt();
        int xp = this.readInt();
        int specialPrice = this.readInt();
        float priceMultiplier = this.readFloat();
        int demand = this.readInt();
        MerchantOffer data = MerchantOffer.of(buyItemPrimary, buyItemSecondary, sellItem, uses, maxUses, xp, specialPrice, priceMultiplier, demand);
        if (tradeDisabled) {
            data.setUses(data.getMaxUses());
        }
        return data;
    }

    public void writeMerchantOffer(MerchantOffer data) {
        MerchantItemCost.writeItem(this, data.getFirstInputItem());
        this.writeItemStack(data.getOutputItem());
        ItemStack buyItemSecondary = data.getSecondInputItem();
        if (buyItemSecondary != null && buyItemSecondary.isEmpty()) {
            buyItemSecondary = null;
        }
        if (this.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) || this.getServerVersion().isOlderThan(ServerVersion.V_1_19)) {
            this.writeOptional(buyItemSecondary, MerchantItemCost::writeItem);
        } else {
            this.writeItemStack(buyItemSecondary);
        }
        this.writeBoolean(data.getUses() >= data.getMaxUses());
        this.writeInt(data.getUses());
        this.writeInt(data.getMaxUses());
        this.writeInt(data.getXp());
        this.writeInt(data.getSpecialPrice());
        this.writeFloat(data.getPriceMultiplier());
        this.writeInt(data.getDemand());
    }

    public ChatType.Bound readChatTypeBoundNetwork() {
        ChatType type = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21) ? this.readMappedEntityOrDirect((IRegistry)ChatTypes.getRegistry(), ChatType::readDirect) : this.readMappedEntity((IRegistry)ChatTypes.getRegistry());
        Component name = this.readComponent();
        Component targetName = (Component)this.readOptional(PacketWrapper::readComponent);
        return new ChatType.Bound(type, name, targetName);
    }

    public void writeChatTypeBoundNetwork(ChatType.Bound chatFormatting) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
            this.writeMappedEntityOrDirect(chatFormatting.getType(), ChatType::writeDirect);
        } else {
            this.writeMappedEntity(chatFormatting.getType());
        }
        this.writeComponent(chatFormatting.getName());
        this.writeOptional(chatFormatting.getTargetName(), PacketWrapper::writeComponent);
    }

    public Node readNode() {
        int redirectNodeIndex;
        byte flags = this.readByte();
        int nodeType = flags & 3;
        List<Integer> children = this.readList(PacketWrapper::readVarInt);
        int n = redirectNodeIndex = (flags & 8) != 0 ? this.readVarInt() : 0;
        if (nodeType == 2) {
            String name = this.readString();
            Parsers.Parser parser = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19) ? this.readMappedEntity(Parsers::getById) : Parsers.getByName(this.readIdentifier().toString());
            List properties = parser.readProperties(this).orElse(null);
            ResourceLocation suggestionType = (flags & 0x10) != 0 ? this.readIdentifier() : null;
            return new Node(flags, children, redirectNodeIndex, name, parser, (List<Object>)properties, suggestionType);
        }
        if (nodeType == 1) {
            String name = this.readString();
            return new Node(flags, children, redirectNodeIndex, name, (Parsers.Parser)null, null, null);
        }
        return new Node(flags, children, redirectNodeIndex, null, (Parsers.Parser)null, null, null);
    }

    public void writeNode(Node node) {
        this.writeByte(node.getFlags());
        this.writeList(node.getChildren(), PacketWrapper::writeVarInt);
        if ((node.getFlags() & 8) != 0) {
            this.writeVarInt(node.getRedirectNodeIndex());
        }
        node.getName().ifPresent(this::writeString);
        if (node.getParser().isPresent()) {
            Parsers.Parser parser = node.getParser().get();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                this.writeMappedEntity(parser);
            } else {
                this.writeIdentifier(parser.getName());
            }
            if (node.getProperties().isPresent()) {
                parser.writeProperties(this, node.getProperties().get());
            }
        }
        node.getSuggestionsType().ifPresent(this::writeIdentifier);
    }

    public KnownPack readKnownPack() {
        String namespace = this.readString();
        String id = this.readString();
        String version = this.readString();
        return new KnownPack(namespace, id, version);
    }

    public void writeKnownPack(KnownPack knownPack) {
        this.writeString(knownPack.getNamespace());
        this.writeString(knownPack.getId());
        this.writeString(knownPack.getVersion());
    }

    public <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> enumClazz) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        byte[] bytes = new byte[-Math.floorDiv(-values.length, 8)];
        ByteBufHelper.readBytes(this.getBuffer(), bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        EnumSet<T> set = EnumSet.noneOf(enumClazz);
        for (int i = 0; i < values.length; ++i) {
            if (!bitSet.get(i)) continue;
            set.add(values[i]);
        }
        return set;
    }

    public <T extends Enum<T>> void writeEnumSet(EnumSet<T> set, Class<T> enumClazz) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        BitSet bitSet = new BitSet(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (!set.contains(values[i])) continue;
            bitSet.set(i);
        }
        this.writeBytes(Arrays.copyOf(bitSet.toByteArray(), -Math.floorDiv(-values.length, 8)));
    }

    @ApiStatus.Experimental
    public <U, V, R> U readMultiVersional(VersionComparison version, ServerVersion target, Reader<V> first, Reader<R> second) {
        if (this.serverVersion.is(version, target)) {
            return (U)first.apply(this);
        }
        return (U)second.apply(this);
    }

    @ApiStatus.Experimental
    public <V> void writeMultiVersional(VersionComparison version, ServerVersion target, V value, Writer<V> first, Writer<V> second) {
        if (this.serverVersion.is(version, target)) {
            first.accept(this, value);
        } else {
            second.accept(this, value);
        }
    }

    @Nullable
    public <R> R readOptional(Reader<R> reader) {
        return this.readBoolean() ? (R)reader.apply(this) : null;
    }

    public <V> void writeOptional(@Nullable V value, Writer<V> writer) {
        if (value != null) {
            this.writeBoolean(true);
            writer.accept(this, value);
        } else {
            this.writeBoolean(false);
        }
    }

    public <R> Optional<R> readJavaOptional(Reader<R> reader) {
        return this.readBoolean() ? Optional.of(reader.apply(this)) : Optional.empty();
    }

    public <V> void writeJavaOptional(Optional<V> value, Writer<V> writer) {
        if (value.isPresent()) {
            this.writeBoolean(true);
            writer.accept(this, value.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <K, C extends Collection<K>> C readCollection(IntFunction<C> function, Reader<K> reader) {
        int size = this.readVarInt();
        return this._readCollection(function, reader, size);
    }

    public <K, C extends Collection<K>> C readCollection(IntFunction<C> function, Reader<K> reader, int maxSize) {
        int size = this.readVarInt();
        if (size > maxSize) {
            throw new RuntimeException(size + " elements exceeded max size of: " + maxSize);
        }
        return this._readCollection(function, reader, size);
    }

    private <K, C extends Collection<K>> C _readCollection(IntFunction<C> function, Reader<K> reader, int size) {
        Collection collection = (Collection)function.apply(size);
        for (int i = 0; i < size; ++i) {
            collection.add(reader.apply(this));
        }
        return (C)collection;
    }

    public <K> void writeCollection(Collection<K> collection, Writer<K> writer) {
        this.writeVarInt(collection.size());
        for (K key : collection) {
            writer.accept(this, key);
        }
    }

    public <K> List<K> readList(Reader<K> reader) {
        return this.readCollection(ArrayList::new, reader);
    }

    public <K> List<K> readList(Reader<K> reader, int maxSize) {
        return this.readCollection(ArrayList::new, reader, maxSize);
    }

    public <K> void writeList(List<K> list, Writer<K> writer) {
        this.writeVarInt(list.size());
        for (K key : list) {
            writer.accept(this, key);
        }
    }

    public <K> Set<K> readSet(Reader<K> reader) {
        return this.readCollection(HashSet::new, reader);
    }

    public <K> Set<K> readSet(Reader<K> reader, int maxSize) {
        return this.readCollection(HashSet::new, reader, maxSize);
    }

    public <K> void writeSet(Set<K> set, Writer<K> writer) {
        this.writeVarInt(set.size());
        for (K key : set) {
            writer.accept(this, key);
        }
    }

    public <K> K[] readArray(Reader<K> reader, Class<K> clazz) {
        int length = this.readVarInt();
        Object[] array = (Object[])Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            array[i] = reader.apply(this);
        }
        return array;
    }

    public <K> void writeArray(K[] array, Writer<K> writer) {
        this.writeVarInt(array.length);
        for (K element : array) {
            writer.accept(this, element);
        }
    }

    public <Z extends Enum<?>> Z readEnum(Class<Z> clazz) {
        return (Z)this.readEnum((Enum[])clazz.getEnumConstants());
    }

    public <Z extends Enum<?>> Z readEnum(Z[] values) {
        return values[this.readVarInt()];
    }

    public <Z extends Enum<?>> Z readEnum(Class<Z> clazz, Z fallback) {
        return (Z)this.readEnum((Enum[])clazz.getEnumConstants(), fallback);
    }

    public <Z extends Enum<?>> Z readEnum(Z[] values, Z fallback) {
        int id = this.readVarInt();
        if (id < 0 || id >= values.length) {
            return fallback;
        }
        return values[id];
    }

    public void writeEnum(Enum<?> value) {
        this.writeVarInt(value.ordinal());
    }

    public <Z extends MappedEntity> Z readMappedEntity(BiFunction<ClientVersion, Integer, Z> getter) {
        int id = this.readVarInt();
        MappedEntity entity = (MappedEntity)getter.apply(this.serverVersion.toClientVersion(), id);
        if (entity == null) {
            throw new IllegalStateException("Can't find mapped entity with id " + id + " using " + getter);
        }
        return (Z)entity;
    }

    public <Z extends MappedEntity> IRegistry<Z> replaceRegistry(IRegistry<Z> registry) {
        return this.getRegistryHolder().getRegistryOr(registry, this.serverVersion.toClientVersion());
    }

    public IRegistryHolder getRegistryHolder() {
        return this.user != null ? this.user : GlobalRegistryHolder.INSTANCE;
    }

    public <Z extends MappedEntity> Z readMappedEntityOrDirect(BiFunction<ClientVersion, Integer, Z> getter, Reader<Z> directReader) {
        int id = this.readVarInt();
        if (id == 0) {
            return (Z)((MappedEntity)directReader.apply(this));
        }
        MappedEntity entity = (MappedEntity)getter.apply(this.serverVersion.toClientVersion(), id - 1);
        if (entity == null) {
            throw new IllegalStateException("Can't find mapped entity with id " + id + " using " + getter);
        }
        return (Z)entity;
    }

    public <Z extends MappedEntity> Z readMappedEntity(IRegistry<Z> registry) {
        IRegistry<Z> replacedRegistry = this.getRegistryHolder().getRegistryOr(registry, this.serverVersion.toClientVersion());
        return this.readMappedEntity((BiFunction<ClientVersion, Integer, Z>)replacedRegistry);
    }

    public <Z extends MappedEntity> Z readMappedEntityOrDirect(IRegistry<Z> registry, Reader<Z> directReader) {
        IRegistry<Z> replacedRegistry = this.getRegistryHolder().getRegistryOr(registry, this.serverVersion.toClientVersion());
        return this.readMappedEntityOrDirect((BiFunction<ClientVersion, Integer, Z>)replacedRegistry, directReader);
    }

    public void writeMappedEntity(MappedEntity entity) {
        if (!entity.isRegistered()) {
            throw new IllegalArgumentException("Can't write id of unregistered entity " + entity.getName() + " (" + entity + ")");
        }
        this.writeVarInt(entity.getId(this.serverVersion.toClientVersion()));
    }

    public <Z extends MappedEntity> void writeMappedEntityOrDirect(Z entity, Writer<Z> writer) {
        if (!entity.isRegistered()) {
            this.writeVarInt(0);
            writer.accept(this, entity);
            return;
        }
        int id = entity.getId(this.serverVersion.toClientVersion());
        this.writeVarInt(id + 1);
    }

    public int readContainerId() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            return this.readVarInt();
        }
        return this.readUnsignedByte();
    }

    public void writeContainerId(int containerId) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            this.writeVarInt(containerId);
        } else {
            this.writeByte(containerId);
        }
    }

    public <L, R> Either<L, R> readEither(Reader<L> leftReader, Reader<R> rightReader) {
        return this.readBoolean() ? Either.createLeft(leftReader.apply(this)) : Either.createRight(rightReader.apply(this));
    }

    public <L, R> void writeEither(Either<L, R> either, Writer<L> leftWriter, Writer<R> rightWriter) {
        if (either.isLeft()) {
            this.writeBoolean(true);
            leftWriter.accept(this, either.getLeft());
        } else {
            this.writeBoolean(false);
            rightWriter.accept(this, either.getRight());
        }
    }

    public void writeRotation(float rotation) {
        this.writeByte((byte)MathUtil.floor(rotation * 256.0f / 360.0f));
    }

    public float readRotation() {
        return (float)(this.readByte() * 360) / 256.0f;
    }

    @Nullable
    public Integer readNullableVarInt() {
        int i = this.readVarInt();
        return i == 0 ? null : Integer.valueOf(i - 1);
    }

    public void writeNullableVarInt(@Nullable Integer i) {
        this.writeVarInt(i == null ? 0 : i + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Z> Z readLengthPrefixed(int maxLength, Reader<Z> reader) {
        int length = this.readVarInt();
        if (length > maxLength) {
            throw new RuntimeException("Buffer size " + length + " is larger than allowed limit of " + maxLength);
        }
        Object prevBuffer = this.buffer;
        try {
            this.buffer = ByteBufHelper.readSlice(prevBuffer, length);
            Object r = reader.apply(this);
            return (Z)r;
        }
        finally {
            this.buffer = prevBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Z> void writeLengthPrefixed(Z value, Writer<Z> writer) {
        Object payloadBuffer = ByteBufHelper.allocateNewBuffer(this.buffer);
        Object prevBuffer = this.buffer;
        try {
            this.buffer = payloadBuffer;
            writer.accept(this, value);
        }
        finally {
            this.buffer = prevBuffer;
        }
        this.writeVarInt(ByteBufHelper.readableBytes(payloadBuffer));
        ByteBufHelper.writeBytes(prevBuffer, payloadBuffer);
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<PacketWrapper<?>, T> {
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<PacketWrapper<?>, T> {
    }
}

