/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.MapUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.VersionRange;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.IRegistry;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.MappingHelper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilder;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;

@NullMarked
public final class VersionedRegistry<T extends MappedEntity>
implements IRegistry<T> {
    private static final String REGISTRY_MAPPINGS_PREFIX = "registries/";
    private final ResourceLocation registryKey;
    private final TypesBuilder typesBuilder;
    private final ClientVersion[] extraSteps;
    private final Map<String, T>[] typeNames;
    private final Map<Integer, T>[] typeIds;
    private final Set<T> entries = new HashSet<T>();

    public VersionedRegistry(String registry) {
        this(registry, new ClientVersion[0]);
    }

    public VersionedRegistry(String registry, ClientVersion ... extraSteps) {
        this(registry, REGISTRY_MAPPINGS_PREFIX + registry, extraSteps);
    }

    public VersionedRegistry(String registry, String mappingsPath) {
        this(registry, mappingsPath, new ClientVersion[0]);
    }

    public VersionedRegistry(String registry, String mappingsPath, ClientVersion ... extraSteps) {
        this(new ResourceLocation(registry), mappingsPath, extraSteps);
    }

    public VersionedRegistry(ResourceLocation registryKey, String mappingsPath) {
        this(registryKey, mappingsPath, new ClientVersion[0]);
    }

    public VersionedRegistry(ResourceLocation registryKey, String mappingsPath, ClientVersion ... extraSteps) {
        this.registryKey = registryKey;
        this.typesBuilder = new TypesBuilder(mappingsPath);
        this.extraSteps = extraSteps;
        this.postLoadMappings();
        int versions = this.typesBuilder.getVersionMapper().size();
        this.typeNames = new Map[versions];
        this.typeIds = new Map[versions];
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, Function<TypesBuilderData, Z> builder) {
        return this.define(name, VersionRange.ALL_VERSIONS, builder);
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, VersionRange range, Function<TypesBuilderData, Z> builder) {
        TypesBuilderData typeData = this.typesBuilder.define(name, range);
        MappedEntity instance = (MappedEntity)builder.apply(typeData);
        MappingHelper.registerMapping(this.typesBuilder, this.typeNames, this.typeIds, typeData, instance);
        return (Z)instance;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public TypesBuilder getTypesBuilder() {
        return this.typesBuilder;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void postLoadMappings() {
        this.typesBuilder.registry = this;
        for (ClientVersion extraStep : this.extraSteps) {
            this.typesBuilder.addExtraVersionStep(extraStep);
        }
    }

    @ApiStatus.Internal
    public void unloadMappings() {
        this.typesBuilder.unloadFileMappings();
        Map<String, T> lastNameMap = this.typeNames[0];
        for (int i = 1; i < this.typeNames.length; ++i) {
            Map<String, T> nameMap = this.typeNames[i];
            if (MapUtil.isDeepEqual(lastNameMap, nameMap)) {
                this.typeNames[i] = lastNameMap;
                continue;
            }
            lastNameMap = nameMap;
        }
        HashSet<String> entryNames = new HashSet<String>();
        for (int i = this.typeNames.length - 1; i >= 0; --i) {
            for (Map.Entry<String, T> entry : this.typeNames[i].entrySet()) {
                if (!entryNames.add(entry.getKey())) continue;
                this.entries.add((MappedEntity)entry.getValue());
            }
        }
    }

    @Override
    @Nullable
    public T getByName(ClientVersion version, ResourceLocation name) {
        int index = this.typesBuilder.getDataIndex(version);
        return (T)((MappedEntity)this.typeNames[index].get(name.toString()));
    }

    @Override
    @Nullable
    public T getByName(ClientVersion version, String name) {
        int index = this.typesBuilder.getDataIndex(version);
        return (T)((MappedEntity)this.typeNames[index].get(ResourceLocation.normString(name)));
    }

    @Override
    @Nullable
    public T getByName(ResourceLocation name) {
        ClientVersion version = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        return this.getByName(version, name);
    }

    @Override
    @Nullable
    public T getByName(String name) {
        ClientVersion version = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        return this.getByName(version, name);
    }

    @Override
    @Nullable
    public T getById(ClientVersion version, int id) {
        int index = this.typesBuilder.getDataIndex(version);
        return (T)((MappedEntity)this.typeIds[index].get(id));
    }

    @Override
    public int getId(MappedEntity entity, ClientVersion version) {
        return entity.getId(version);
    }

    @Override
    public Collection<T> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String toString() {
        return "VersionedRegistry[" + this.registryKey + ']';
    }
}

