/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.impl.v1_16;

import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.stream.NetStreamInput;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.stream.NetStreamInputWrapper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.stream.NetStreamOutput;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.stream.NetStreamOutputWrapper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.BaseChunk;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.NibbleArray3d;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.palette.DataPalette;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.palette.PaletteType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class Chunk_v1_9
implements BaseChunk {
    private static final int AIR = 0;
    private static final int LIGHT_NIBBLES_SIZE = 2048;
    private int blockCount;
    private final DataPalette dataPalette;
    @Nullable
    private NibbleArray3d blockLight;
    @Nullable
    private NibbleArray3d skyLight;

    public Chunk_v1_9(int blockCount, DataPalette dataPalette) {
        this(blockCount, dataPalette, null, null);
    }

    public Chunk_v1_9(int blockCount, DataPalette dataPalette, @Nullable NibbleArray3d blockLight, @Nullable NibbleArray3d skyLight) {
        this.blockCount = blockCount;
        this.dataPalette = dataPalette;
        this.blockLight = blockLight;
        this.skyLight = skyLight;
    }

    @Deprecated
    public Chunk_v1_9(NetStreamInput in, boolean hasBlockLight, boolean hasSkyLight) {
        this(in, hasBlockLight, hasSkyLight, PacketEvents.getAPI().getServerManager().getVersion());
    }

    @Deprecated
    private Chunk_v1_9(NetStreamInput in, boolean hasBlockLight, boolean hasSkyLight, ServerVersion version) {
        this.blockCount = version.isNewerThanOrEquals(ServerVersion.V_1_14) ? (int)in.readShort() : Integer.MAX_VALUE;
        this.dataPalette = version.isNewerThanOrEquals(ServerVersion.V_1_16) ? DataPalette.read(in, PaletteType.CHUNK, false) : DataPalette.readLegacy(in);
        this.blockLight = hasBlockLight ? new NibbleArray3d(in, 2048) : null;
        this.skyLight = hasSkyLight ? new NibbleArray3d(in, 2048) : null;
    }

    public static Chunk_v1_9 read(PacketWrapper<?> wrapper, boolean hasBlockLight, boolean hasSkyLight) {
        NetStreamInputWrapper legacyInput = new NetStreamInputWrapper(wrapper);
        return new Chunk_v1_9(legacyInput, hasBlockLight, hasSkyLight, wrapper.getServerVersion());
    }

    public static void write(PacketWrapper<?> wrapper, Chunk_v1_9 chunk) {
        NetStreamOutputWrapper legacyOutput = new NetStreamOutputWrapper(wrapper);
        Chunk_v1_9.write(legacyOutput, chunk, wrapper.getServerVersion());
    }

    @Deprecated
    public static void write(NetStreamOutput out, Chunk_v1_9 chunk) {
        Chunk_v1_9.write(out, chunk, PacketEvents.getAPI().getServerManager().getVersion());
    }

    @Deprecated
    private static void write(NetStreamOutput out, Chunk_v1_9 chunk, ServerVersion version) {
        if (version.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            out.writeShort(chunk.blockCount);
        }
        DataPalette.write(out, chunk.dataPalette);
        if (chunk.blockLight != null) {
            out.writeBytes(chunk.blockLight.getData());
        }
        if (chunk.skyLight != null) {
            out.writeBytes(chunk.skyLight.getData());
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.dataPalette.get(x, y, z);
    }

    @Override
    public void set(int x, int y, int z, int state) {
        int curr = this.dataPalette.set(x, y, z, state);
        if (this.blockCount == Integer.MAX_VALUE) {
            return;
        }
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blockCount == Integer.MAX_VALUE) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (this.dataPalette.get(x, y, z) == 0) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return this.blockCount == 0;
    }

    @Nullable
    public NibbleArray3d getSkyLight() {
        return this.skyLight;
    }

    public void setSkyLight(@Nullable NibbleArray3d skyLight) {
        this.skyLight = skyLight;
    }

    @Nullable
    public NibbleArray3d getBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(@Nullable NibbleArray3d blockLight) {
        this.blockLight = blockLight;
    }
}

