/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines;

import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.CopyableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.DeepComparableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTInt;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecException;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecs;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtMapCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.EnvironmentAttribute;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.EnvironmentAttributes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines.StaticTimeline;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines.TimelineTrack;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

@NullMarked
public interface Timeline
extends MappedEntity,
CopyableEntity<Timeline>,
DeepComparableEntity {
    public static final NbtCodec<Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>>> TRACK_CODEC = NbtMapCodec.codecOfMap(NbtCodecs.forRegistry(EnvironmentAttributes.getRegistry()), TimelineTrack::codec).codec();
    public static final NbtCodec<Timeline> CODEC = new NbtMapCodec<Timeline>(){

        @Override
        public Timeline decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            Integer periodTicks = compound.getOrNull("period_ticks", NbtCodecs.INT, wrapper);
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks = compound.getOr("tracks", TRACK_CODEC, Collections.emptyMap(), wrapper);
            return new StaticTimeline(periodTicks, tracks);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Timeline value) throws NbtCodecException {
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks;
            Integer periodTicks = value.getPeriodTicks();
            if (periodTicks != null) {
                compound.setTag("period_ticks", new NBTInt(periodTicks));
            }
            if (!(tracks = value.getTracks()).isEmpty()) {
                compound.set("tracks", tracks, TRACK_CODEC, wrapper);
            }
        }
    }.codec();

    public @Nullable Integer getPeriodTicks();

    public Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> getTracks();
}

