/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers;

import org.jspecify.annotations.NullMarked;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.AlphaColor;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.Color;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecs;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.EnvironmentAttribute;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers.AttributeModifier;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers.BlendToGrayArgument;

@NullMarked
public interface ColorModifier<A>
extends AttributeModifier<Color, A> {
    public static final ColorModifier<AlphaColor> ALPHA_BLEND = Color::blendWith;
    public static final ColorModifier<Color> ADD = Color::plus;
    public static final ColorModifier<Color> SUBTRACT = Color::minus;
    public static final ColorModifier<Color> MULTIPLY = Color::times;
    public static final ColorModifier<BlendToGrayArgument> BLEND_TO_GRAY = new ColorModifier<BlendToGrayArgument>(){

        @Override
        public Color apply(Color value, BlendToGrayArgument arg) {
            return arg.blend(value);
        }

        @Override
        public NbtCodec<BlendToGrayArgument> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return BlendToGrayArgument.CODEC;
        }
    };

    @FunctionalInterface
    public static interface ArgbModifier
    extends ColorModifier<AlphaColor> {
        @Override
        default public NbtCodec<AlphaColor> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.ARGB_COLOR;
        }
    }

    @FunctionalInterface
    public static interface RgbModifier
    extends ColorModifier<Color> {
        @Override
        default public NbtCodec<Color> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.RGB_COLOR;
        }
    }
}

