/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world;

import org.jetbrains.annotations.NotNull;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.Dimension;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.dimension.DimensionType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.Vector3i;

public class WorldBlockPosition {
    public static final ResourceLocation OVERWORLD_DIMENSION = ResourceLocation.minecraft("overworld");
    private ResourceLocation world;
    private Vector3i blockPosition;

    public WorldBlockPosition(@NotNull ResourceLocation world, @NotNull Vector3i blockPosition) {
        this.world = world;
        this.blockPosition = blockPosition;
    }

    public WorldBlockPosition(@NotNull ResourceLocation world, int x, int y, int z) {
        this.world = world;
        this.blockPosition = new Vector3i(x, y, z);
    }

    @Deprecated
    public WorldBlockPosition(@NotNull Dimension dimension, @NotNull Vector3i blockPosition) {
        this(new ResourceLocation(dimension.getDimensionName()), blockPosition);
    }

    public WorldBlockPosition(@NotNull DimensionType dimensionType, @NotNull Vector3i blockPosition) {
        this(dimensionType.getName(), blockPosition);
    }

    public ResourceLocation getWorld() {
        return this.world;
    }

    public void setWorld(ResourceLocation world) {
        this.world = world;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }
}

