/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.instrument;

import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.instrument.Instruments;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.instrument.StaticInstrument;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.CopyableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.DeepComparableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTFloat;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.sound.Sound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.MathUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public interface Instrument
extends MappedEntity,
CopyableEntity<Instrument>,
DeepComparableEntity {
    public Sound getSound();

    public float getUseSeconds();

    default public int getUseDuration() {
        return MathUtil.floor(this.getUseSeconds() * 20.0f);
    }

    public float getRange();

    public Component getDescription();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments.getRegistry(), Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        float useSeconds = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readFloat() : (float)wrapper.readVarInt() * 20.0f;
        float range = wrapper.readFloat();
        Component description = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readComponent() : Component.empty();
        return new StaticInstrument(sound, useSeconds, range, description);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeFloat(instrument.getUseSeconds());
        } else {
            wrapper.writeVarInt(instrument.getUseDuration());
        }
        wrapper.writeFloat(instrument.getRange());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeComponent(instrument.getDescription());
        }
    }

    @Deprecated
    public static Instrument decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return Instrument.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static Instrument decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = compound.getOrThrow("sound_event", Sound.CODEC, wrapper);
        float useSeconds = compound.getNumberTagOrThrow("use_duration").getAsFloat();
        float range = compound.getNumberTagOrThrow("range").getAsFloat();
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        return new StaticInstrument(data, sound, useSeconds, range, description);
    }

    @Deprecated
    public static NBT encode(Instrument instrument, ClientVersion version) {
        return Instrument.encode(PacketWrapper.createDummyWrapper(version), instrument);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Instrument instrument) {
        NBTCompound compound = new NBTCompound();
        compound.set("sound_event", instrument.getSound(), Sound.CODEC, wrapper);
        compound.setTag("use_duration", new NBTFloat(instrument.getUseSeconds()));
        compound.setTag("range", new NBTFloat(instrument.getRange()));
        compound.set("description", instrument.getDescription(), wrapper.getSerializers(), wrapper);
        return compound;
    }
}

