/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cat;

import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cat.CatVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cat.StaticCatVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.CopyableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.DeepComparableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTString;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

