/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.dialog.button;

import net.kyori.adventure.text.Component;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTInt;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.adventure.AdventureSerializer;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

@NullMarked
public class CommonButtonData {
    private final Component label;
    private final @Nullable Component tooltip;
    private final int width;

    public CommonButtonData(Component label, @Nullable Component tooltip, int width) {
        this.label = label;
        this.tooltip = tooltip;
        this.width = width;
    }

    public static CommonButtonData decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        AdventureSerializer serializer = AdventureSerializer.serializer(wrapper);
        Component label = compound.getOrThrow("label", serializer, wrapper);
        Component tooltip = compound.getOrNull("tooltip", serializer, wrapper);
        int width = compound.getNumberTagValueOrDefault("width", 150).intValue();
        return new CommonButtonData(label, tooltip, width);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, CommonButtonData button) {
        AdventureSerializer serializer = AdventureSerializer.serializer(wrapper);
        compound.set("label", button.label, serializer, wrapper);
        if (button.tooltip != null) {
            compound.set("tooltip", button.tooltip, serializer, wrapper);
        }
        if (button.width != 150) {
            compound.setTag("width", new NBTInt(button.width));
        }
    }

    public Component getLabel() {
        return this.label;
    }

    public @Nullable Component getTooltip() {
        return this.tooltip;
    }

    public int getWidth() {
        return this.width;
    }
}

