/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.builtin.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTList;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTString;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class ItemRecipes {
    private List<ResourceLocation> recipes;

    public ItemRecipes(List<ResourceLocation> recipes) {
        this.recipes = recipes;
    }

    public static ItemRecipes read(PacketWrapper<?> wrapper) {
        NBTList recipes = (NBTList)wrapper.readNBTRaw();
        int size = recipes.size();
        ArrayList<ResourceLocation> recipeKeys = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            NBTString tag = (NBTString)recipes.getTag(i);
            recipeKeys.add(new ResourceLocation(tag.getValue()));
        }
        return new ItemRecipes(recipeKeys);
    }

    public static void write(PacketWrapper<?> wrapper, ItemRecipes recipes) {
        NBTList<NBTString> recipesTag = NBTList.createStringList();
        for (ResourceLocation recipeKey : recipes.recipes) {
            recipesTag.addTag(new NBTString(recipeKey.toString()));
        }
        wrapper.writeNBTRaw(recipesTag);
    }

    public void addRecipe(ResourceLocation recipeKey) {
        this.recipes.add(recipeKey);
    }

    public void removeRecipe(ResourceLocation recipeKey) {
        this.recipes.remove(recipeKey);
    }

    public List<ResourceLocation> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(List<ResourceLocation> recipes) {
        this.recipes = recipes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemRecipes)) {
            return false;
        }
        ItemRecipes that = (ItemRecipes)obj;
        return this.recipes.equals(that.recipes);
    }

    public int hashCode() {
        return Objects.hashCode(this.recipes);
    }
}

