/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.builtin.item;

import java.util.List;
import java.util.Objects;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.consumables.ConsumeEffect;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.sound.Sound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class ItemConsumable {
    private float consumeSeconds;
    private Animation animation;
    private Sound sound;
    private boolean consumeParticles;
    private List<ConsumeEffect<?>> effects;

    public ItemConsumable(float consumeSeconds, Animation animation, Sound sound, boolean consumeParticles, List<ConsumeEffect<?>> effects) {
        this.consumeSeconds = consumeSeconds;
        this.animation = animation;
        this.sound = sound;
        this.consumeParticles = consumeParticles;
        this.effects = effects;
    }

    public static ItemConsumable read(PacketWrapper<?> wrapper) {
        float consumeSeconds = wrapper.readFloat();
        Animation animation = (Animation)wrapper.readEnum(Animation.values());
        Sound sound = Sound.read(wrapper);
        boolean consumeParticles = wrapper.readBoolean();
        List<ConsumeEffect<?>> effects = wrapper.readList(ConsumeEffect::readFull);
        return new ItemConsumable(consumeSeconds, animation, sound, consumeParticles, effects);
    }

    public static void write(PacketWrapper<?> wrapper, ItemConsumable consumable) {
        wrapper.writeFloat(consumable.consumeSeconds);
        wrapper.writeEnum(consumable.animation);
        Sound.write(wrapper, consumable.sound);
        wrapper.writeBoolean(consumable.consumeParticles);
        wrapper.writeList(consumable.effects, ConsumeEffect::writeFull);
    }

    public float getConsumeSeconds() {
        return this.consumeSeconds;
    }

    public void setConsumeSeconds(float consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public boolean isConsumeParticles() {
        return this.consumeParticles;
    }

    public void setConsumeParticles(boolean consumeParticles) {
        this.consumeParticles = consumeParticles;
    }

    public List<ConsumeEffect<?>> getEffects() {
        return this.effects;
    }

    public void setEffects(List<ConsumeEffect<?>> effects) {
        this.effects = effects;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemConsumable)) {
            return false;
        }
        ItemConsumable that = (ItemConsumable)obj;
        if (Float.compare(that.consumeSeconds, this.consumeSeconds) != 0) {
            return false;
        }
        if (this.consumeParticles != that.consumeParticles) {
            return false;
        }
        if (this.animation != that.animation) {
            return false;
        }
        if (!this.sound.equals(that.sound)) {
            return false;
        }
        return this.effects.equals(that.effects);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.consumeSeconds), this.animation, this.sound, this.consumeParticles, this.effects});
    }

    public String toString() {
        return "ItemConsumable{consumeSeconds=" + this.consumeSeconds + ", animation=" + (Object)((Object)this.animation) + ", sound=" + this.sound + ", consumeParticles=" + this.consumeParticles + ", effects=" + this.effects + '}';
    }

    public static enum Animation {
        NONE,
        EAT,
        DRINK,
        BLOCK,
        BOW,
        SPEAR,
        CROSSBOW,
        SPYGLASS,
        TOOT_HORN,
        BRUSH,
        BUNDLE;

    }
}

