/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.event;

import java.util.ArrayList;
import java.util.List;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketListenerCommon;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.ProtocolPacketEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.exception.PacketProcessException;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.netty.buffer.ByteBufHelper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.PacketSide;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketTypeCommon;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.User;

public class PacketSendEvent
extends ProtocolPacketEvent {
    private List<Runnable> tasksAfterSend = null;

    protected PacketSendEvent(Object channel, User user, Object player, Object rawByteBuf, boolean autoProtocolTranslation) throws PacketProcessException {
        super(PacketSide.SERVER, channel, user, player, rawByteBuf, autoProtocolTranslation);
    }

    protected PacketSendEvent(int packetID, PacketTypeCommon packetType, ServerVersion serverVersion, Object channel, User user, Object player, Object byteBuf) throws PacketProcessException {
        super(packetID, packetType, serverVersion, channel, user, player, byteBuf);
    }

    @Override
    public void call(PacketListenerCommon listener) {
        listener.onPacketSend(this);
    }

    public List<Runnable> getTasksAfterSend() {
        if (this.tasksAfterSend == null) {
            this.tasksAfterSend = new ArrayList<Runnable>();
        }
        return this.tasksAfterSend;
    }

    public boolean hasTasksAfterSend() {
        return this.tasksAfterSend != null && !this.tasksAfterSend.isEmpty();
    }

    @Override
    public PacketSendEvent clone() {
        try {
            Object clonedBuffer = ByteBufHelper.retainedDuplicate(this.getByteBuf());
            return new PacketSendEvent(this.getPacketId(), this.getPacketType(), this.getServerVersion(), this.getChannel(), this.getUser(), this.getPlayer(), clonedBuffer);
        }
        catch (PacketProcessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

