/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.entity;

import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;
import ua.valeriishymchuk.simpleitemgenerator.common.cooldown.CooldownType;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;
import ua.valeriishymchuk.simpleitemgenerator.common.placeholders.PlaceholdersHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.regex.RegexUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.Predicate;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.PredicateInput;
import ua.valeriishymchuk.simpleitemgenerator.domain.CooldownQueryDomain;
import ua.valeriishymchuk.simpleitemgenerator.dto.CommandExecutionDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;

public class UsageEntity {
    private static final Pattern TIME_PATTERN = Pattern.compile("%time_(?<timeunit>[a-z])(\\.(?<precision>\\d+)f)?%");
    public static UsageEntity EMPTY = new UsageEntity(Collections.emptyList(), 0L, 0L, false, Consume.NONE, Collections.emptyList(), Collections.emptyList(), CooldownType.PER_ITEM);
    public static UsageEntity DEFAULT = EMPTY.withCancel(true);
    private List<Predicate> predicates;
    private long cooldownMillis;
    private long cooldownFreezeTimeMillis;
    private boolean cancel;
    private Consume consume;
    private List<Command> onCooldown;
    private List<Command> commands;
    private CooldownType cooldownType;

    public List<CommandExecutionDTO> prepareCommands(Player player, Map<String, String> placeholders) {
        return this.getCommands().stream().map(command -> command.prepare(player, placeholders)).collect(Collectors.toList());
    }

    public ItemUsageResultDTO prepareCooldownCommands(CooldownQueryDomain queryDomain, Player player, Map<String, String> placeholders, PipelineDebug pipelineDebug) {
        List<CommandExecutionDTO> commands = this.getOnCooldown().stream().map(it -> it.prepareCooldown(queryDomain.getRemainingCooldownTime().get(), player, placeholders)).collect(Collectors.toList());
        return ItemUsageResultDTO.CANCELLED.withCommands(commands).withPipelineDebug(pipelineDebug.appendAndReturnSelf("Preparing cooldown commands", new PipelineDebug.Tag[0]));
    }

    public AcceptResult accepts(PredicateInput input) {
        if (this.predicates.isEmpty() && input.getTrigger() != PredicateInput.Trigger.TICK) {
            return new AcceptResult(true, Collections.singletonList(PipelineDebug.root("Predicates are empty, so its true", new PipelineDebug.Tag[0])));
        }
        ArrayList<PipelineDebug> debugs = new ArrayList<PipelineDebug>();
        boolean isAccepted = this.predicates.stream().anyMatch(t -> {
            Predicate.TestResult result = t.test(input);
            debugs.add(PipelineDebug.root("Predicate (" + result.isTestResult() + ") - " + this.predicates.indexOf(t), new PipelineDebug.Tag[0]).appendAllAndReturnSelf(result.getDebugs()));
            return result.isTestResult();
        });
        return new AcceptResult(isAccepted, debugs);
    }

    @Generated
    public UsageEntity(List<Predicate> predicates, long cooldownMillis, long cooldownFreezeTimeMillis, boolean cancel, Consume consume, List<Command> onCooldown, List<Command> commands, CooldownType cooldownType) {
        this.predicates = predicates;
        this.cooldownMillis = cooldownMillis;
        this.cooldownFreezeTimeMillis = cooldownFreezeTimeMillis;
        this.cancel = cancel;
        this.consume = consume;
        this.onCooldown = onCooldown;
        this.commands = commands;
        this.cooldownType = cooldownType;
    }

    @Generated
    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Generated
    public long getCooldownMillis() {
        return this.cooldownMillis;
    }

    @Generated
    public long getCooldownFreezeTimeMillis() {
        return this.cooldownFreezeTimeMillis;
    }

    @Generated
    public boolean isCancel() {
        return this.cancel;
    }

    @Generated
    public Consume getConsume() {
        return this.consume;
    }

    @Generated
    public List<Command> getOnCooldown() {
        return this.onCooldown;
    }

    @Generated
    public List<Command> getCommands() {
        return this.commands;
    }

    @Generated
    public CooldownType getCooldownType() {
        return this.cooldownType;
    }

    @Generated
    public UsageEntity withPredicates(List<Predicate> predicates) {
        return this.predicates == predicates ? this : new UsageEntity(predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.consume, this.onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withCooldownMillis(long cooldownMillis) {
        return this.cooldownMillis == cooldownMillis ? this : new UsageEntity(this.predicates, cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.consume, this.onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withCooldownFreezeTimeMillis(long cooldownFreezeTimeMillis) {
        return this.cooldownFreezeTimeMillis == cooldownFreezeTimeMillis ? this : new UsageEntity(this.predicates, this.cooldownMillis, cooldownFreezeTimeMillis, this.cancel, this.consume, this.onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withCancel(boolean cancel) {
        return this.cancel == cancel ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, cancel, this.consume, this.onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withConsume(Consume consume) {
        return this.consume == consume ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, consume, this.onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withOnCooldown(List<Command> onCooldown) {
        return this.onCooldown == onCooldown ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.consume, onCooldown, this.commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withCommands(List<Command> commands) {
        return this.commands == commands ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.consume, this.onCooldown, commands, this.cooldownType);
    }

    @Generated
    public UsageEntity withCooldownType(CooldownType cooldownType) {
        return this.cooldownType == cooldownType ? this : new UsageEntity(this.predicates, this.cooldownMillis, this.cooldownFreezeTimeMillis, this.cancel, this.consume, this.onCooldown, this.commands, cooldownType);
    }

    @Generated
    public String toString() {
        return "UsageEntity(predicates=" + this.getPredicates() + ", cooldownMillis=" + this.getCooldownMillis() + ", cooldownFreezeTimeMillis=" + this.getCooldownFreezeTimeMillis() + ", cancel=" + this.isCancel() + ", consume=" + this.getConsume() + ", onCooldown=" + this.getOnCooldown() + ", commands=" + this.getCommands() + ", cooldownType=" + this.getCooldownType() + ")";
    }

    public static class AcceptResult {
        private final boolean isAccepted;
        private final List<PipelineDebug> pipelineDebugs;

        @Generated
        public AcceptResult(boolean isAccepted, List<PipelineDebug> pipelineDebugs) {
            this.isAccepted = isAccepted;
            this.pipelineDebugs = pipelineDebugs;
        }

        @Generated
        public boolean isAccepted() {
            return this.isAccepted;
        }

        @Generated
        public List<PipelineDebug> getPipelineDebugs() {
            return this.pipelineDebugs;
        }
    }

    public static class Consume {
        public static Consume NONE = new Consume(ConsumeType.NONE, 0);
        private final ConsumeType consumeType;
        private final int amount;

        public boolean isNone() {
            return this.consumeType == ConsumeType.NONE;
        }

        public boolean isAmount() {
            return this.consumeType == ConsumeType.AMOUNT;
        }

        @Generated
        public Consume(ConsumeType consumeType, int amount) {
            this.consumeType = consumeType;
            this.amount = amount;
        }

        @Generated
        public ConsumeType getConsumeType() {
            return this.consumeType;
        }

        @Generated
        public int getAmount() {
            return this.amount;
        }

        @Generated
        public Consume withConsumeType(ConsumeType consumeType) {
            return this.consumeType == consumeType ? this : new Consume(consumeType, this.amount);
        }

        @Generated
        public Consume withAmount(int amount) {
            return this.amount == amount ? this : new Consume(this.consumeType, amount);
        }
    }

    public static class Command {
        private final boolean executeAsConsole;
        private final String command;

        public Command replace(UnaryOperator<String> replacer) {
            return new Command(this.executeAsConsole, (String)replacer.apply(this.command));
        }

        private CommandExecutionDTO prepare(Player player, Map<String, String> placeholders) {
            String rawCommand = PlaceholdersHelper.replacePlayer(this.command, player);
            AtomicReference<String> strAtomic = new AtomicReference<String>(rawCommand);
            placeholders.forEach((placeholder, value) -> strAtomic.set(((String)strAtomic.get()).replace((CharSequence)placeholder, (CharSequence)value)));
            return new CommandExecutionDTO(this.executeAsConsole, strAtomic.get());
        }

        private CommandExecutionDTO prepareCooldown(long milliseconds, Player player, Map<String, String> placeholders) {
            CommandExecutionDTO halfPreparedDto = this.prepare(player, placeholders);
            String rawCommand = halfPreparedDto.getCommand();
            String finalCommand = RegexUtils.replaceAll(TIME_PATTERN.matcher(rawCommand), matcher -> {
                String timeUnit = matcher.group("timeunit").toLowerCase();
                int precision = Option.of(matcher.group("precision")).map(Integer::parseInt).getOrElse(0);
                return String.format(Locale.ROOT, "%." + precision + "f", switch (timeUnit) {
                    case "s" -> (double)milliseconds / 1000.0;
                    case "m" -> (double)milliseconds / 1000.0 / 60.0;
                    case "h" -> (double)milliseconds / 1000.0 / 60.0 / 60.0;
                    case "t" -> (double)milliseconds / 50.0;
                    default -> throw new IllegalStateException("Unknown time unit: " + timeUnit);
                });
            });
            return new CommandExecutionDTO(halfPreparedDto.isExecuteAsConsole(), finalCommand);
        }

        @Generated
        public Command(boolean executeAsConsole, String command) {
            this.executeAsConsole = executeAsConsole;
            this.command = command;
        }

        @Generated
        public boolean isExecuteAsConsole() {
            return this.executeAsConsole;
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public Command withExecuteAsConsole(boolean executeAsConsole) {
            return this.executeAsConsole == executeAsConsole ? this : new Command(executeAsConsole, this.command);
        }

        @Generated
        public Command withCommand(String command) {
            return this.command == command ? this : new Command(this.executeAsConsole, command);
        }
    }

    public static enum ConsumeType {
        AMOUNT,
        NONE,
        STACK,
        ALL;

    }
}

