/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import io.vavr.control.Option;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.scheduler.BukkitTaskScheduler;
import ua.valeriishymchuk.simpleitemgenerator.common.slot.EquipmentToSlotConverter;
import ua.valeriishymchuk.simpleitemgenerator.common.tick.TickTimer;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.SlotPredicate;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageGeneralDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.service.InfoService;
import ua.valeriishymchuk.simpleitemgenerator.service.ItemService;

public class TickController {
    private final ItemService itemService;
    private final InfoService infoService;
    private final BukkitTaskScheduler taskScheduler;
    private final TickTimer tickerTime;

    public void start() {
        this.startUpdatingItems();
        this.startTickingItems();
        this.taskScheduler.runTaskTimerAsynchronously(this.itemService::cooldownAutoSave, 6000L, 6000L);
    }

    private void startUpdatingItems() {
        this.taskScheduler.runTaskLater(() -> {
            this.updateItems();
            this.startUpdatingItems();
        }, this.itemService.getPlaceholderUpdatePeriodTicks());
    }

    private void startTickingItems() {
        this.taskScheduler.runTaskLater(() -> {
            this.tickItems();
            this.startTickingItems();
        }, this.itemService.getItemUpdatePeriodTicks());
    }

    private void tickItems() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            ItemStack[] contents = player.getInventory().getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (item == null || item.getType().name().endsWith("AIR")) continue;
                ItemUsageResultDTO result = this.itemService.tickItem(new ItemUsageGeneralDTO((Player)player, item, this.tickerTime.getTick(), new SlotPredicate.Input(i, (EquipmentSlot)EquipmentToSlotConverter.convert(i, player).getOrNull(), true)), PipelineDebug.root("Ticking", PipelineDebug.Tag.TICK));
                this.handleResult(result, item, (Player)player);
            }
        });
    }

    private void handleResult(ItemUsageResultDTO result, ItemStack item, Player player) {
        if (this.infoService.isDebugTick()) {
            result.getPipelineDebug().print(new PipelineDebug.Tag[0]);
        }
        result.getCommands().forEach(commands -> {
            ConsoleCommandSender sender = commands.isExecuteAsConsole() ? Bukkit.getConsoleSender() : player;
            Bukkit.dispatchCommand((CommandSender)sender, (String)commands.getCommand());
        });
        result.getMessage().peek(message -> KyoriHelper.sendMessage((CommandSender)player, message));
        if (!result.getConsume().isNone() && item != null) {
            ItemStack clonedItem = item.clone();
            if (result.getConsume().isAmount()) {
                AtomicInteger totalAmount = new AtomicInteger(result.getConsume().getAmount());
                player.getInventory().forEach(itemCons -> {
                    if (itemCons == null || itemCons.getType().name().endsWith("AIR")) {
                        return;
                    }
                    if (this.itemService.areNotEqual((ItemStack)itemCons, clonedItem)) {
                        return;
                    }
                    if (totalAmount.get() <= 0) {
                        return;
                    }
                    int toRemove = Math.min(totalAmount.get(), itemCons.getAmount());
                    itemCons.setAmount(itemCons.getAmount() - toRemove);
                    totalAmount.set(totalAmount.get() - toRemove);
                });
            } else {
                boolean onlyStack;
                boolean bl = onlyStack = result.getConsume().getConsumeType() == UsageEntity.ConsumeType.STACK;
                if (onlyStack) {
                    item.setAmount(0);
                } else {
                    player.getInventory().forEach(itemCons -> {
                        if (itemCons == null || itemCons.getType().name().endsWith("AIR")) {
                            return;
                        }
                        if (this.itemService.areNotEqual((ItemStack)itemCons, clonedItem)) {
                            return;
                        }
                        itemCons.setAmount(0);
                    });
                }
            }
        }
    }

    private void updateItems() {
        HashSet worlds = new HashSet();
        Bukkit.getOnlinePlayers().forEach(player -> {
            worlds.add(player.getWorld());
            InventoryView inventoryView = player.getOpenInventory();
            Stream.of(inventoryView.getTopInventory().getContents(), inventoryView.getBottomInventory().getContents()).flatMap(Arrays::stream).filter(Objects::nonNull).filter(ItemStack::hasItemMeta).forEach(item -> this.itemService.updateItem((ItemStack)item, (Player)player));
        });
        worlds.stream().flatMap(w -> w.getEntitiesByClass(Item.class).stream()).filter(item -> item.getItemStack().hasItemMeta()).forEach(item -> {
            ItemStack itemStack = item.getItemStack();
            this.itemService.updateItem(itemStack, null).peek(arg_0 -> ((Item)item).setItemStack(arg_0));
        });
        worlds.stream().flatMap(w -> w.getEntitiesByClass(LivingEntity.class).stream()).filter(e -> !(e instanceof Player)).forEach(e -> {
            EntityEquipment equipment = e.getEquipment();
            Option.of(equipment.getBoots()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setBoots(arg_0));
            Option.of(equipment.getLeggings()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setLeggings(arg_0));
            Option.of(equipment.getChestplate()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setChestplate(arg_0));
            Option.of(equipment.getHelmet()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setHelmet(arg_0));
            Option.of(equipment.getItemInMainHand()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setItemInMainHand(arg_0));
            Option.of(equipment.getItemInOffHand()).filter(ItemStack::hasItemMeta).flatMap(item -> this.itemService.updateItem((ItemStack)item, null)).peek(arg_0 -> ((EntityEquipment)equipment).setItemInOffHand(arg_0));
        });
    }

    @Generated
    public TickController(ItemService itemService, InfoService infoService, BukkitTaskScheduler taskScheduler, TickTimer tickerTime) {
        this.itemService = itemService;
        this.infoService = infoService;
        this.taskScheduler = taskScheduler;
        this.tickerTime = tickerTime;
    }
}

