/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import io.vavr.Tuple;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.Command;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.EnumArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.IntegerArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.StringArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.PlayerArgument;
import ua.valeriishymchuk.simpleitemgenerator.common.commands.ArgumentParserWrapper;
import ua.valeriishymchuk.simpleitemgenerator.common.commands.argument.CustomPlayerArgument;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.dto.GiveItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.WithdrawItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.service.InfoService;
import ua.valeriishymchuk.simpleitemgenerator.service.ItemService;

public class CommandsController {
    private static final String COMMAND_PERMISSION = "simpleitemgenerator.commands";
    private static final String COMMAND_PERMISSION_PREPEND = "simpleitemgenerator.commands.";
    private final ItemService itemService;
    private final InfoService infoService;

    private void addItemToInventory(Option<ItemStack> itemOpt, int amount, Player player, Component dropMessage) {
        itemOpt.map(item -> Tuple.of(player, item)).peek(t -> ((ItemStack)t._2).setAmount(amount)).map(tuple -> ((Player)tuple._1).getInventory().addItem(new ItemStack[]{(ItemStack)tuple._2})).peek(items -> this.dropItems((Map<Integer, ItemStack>)items, player.getLocation(), player, dropMessage));
    }

    public void setupCommands(CommandManager<CommandSender> commandManager) {
        Command.Builder<CommandSender> builder = commandManager.commandBuilder("simpleitemgenerator", "sig").permission("simpleitemgenerator.commands.general");
        commandManager.command(builder.handler(ctx -> KyoriHelper.sendMessage((CommandSender)ctx.getSender(), this.infoService.getUsage())));
        commandManager.command(builder.literal("give", new String[0]).permission("simpleitemgenerator.commands.give").argument(StringArgument.builder("key").withSuggestionsProvider((ctx, s) -> this.itemService.getItemKeys().stream().filter(line -> line.contains((CharSequence)s)).collect(Collectors.toList()))).argument(CustomPlayerArgument.builder("player").asOptional().withParser(new ArgumentParserWrapper(new PlayerArgument.PlayerParser(), e -> {
            if (e instanceof PlayerArgument.PlayerParseException) {
                PlayerArgument.PlayerParseException ex = (PlayerArgument.PlayerParseException)e;
                return this.itemService.playerNotFound(ex.getInput());
            }
            return this.itemService.playerNotFound("[blank]");
        }))).argument(IntegerArgument.builder("amount").withMin(1).asOptional()).handler(ctx -> {
            String key = (String)ctx.get("key");
            int amount = ctx.getOrDefault("amount", Integer.valueOf(1));
            Option playerOpt = Option.ofOptional(ctx.getOptional("player")).orElse(() -> Option.when(ctx.getSender() instanceof Player, () -> (Player)ctx.getSender()));
            GiveItemDTO result = this.itemService.giveItem(key, (Player)playerOpt.getOrNull());
            KyoriHelper.sendMessage((CommandSender)ctx.getSender(), result.getMessage());
            playerOpt.peek(p -> this.addItemToInventory(result.getItemStack(), amount, (Player)p, result.getDropMessage()));
        }));
        commandManager.command(builder.literal("set_slot", new String[0]).permission("simpleitemgenerator.commands.set_slot").argument(StringArgument.builder("key").withSuggestionsProvider((ctx, s) -> this.itemService.getItemKeys().stream().filter(line -> line.contains((CharSequence)s)).collect(Collectors.toList()))).argument(IntegerArgument.builder("slot").withMin(0).withMax(InventoryType.PLAYER.getDefaultSize() - 1)).argument(CustomPlayerArgument.builder("player").asOptional().withParser(new ArgumentParserWrapper(new PlayerArgument.PlayerParser(), e -> {
            if (e instanceof PlayerArgument.PlayerParseException) {
                PlayerArgument.PlayerParseException ex = (PlayerArgument.PlayerParseException)e;
                return this.itemService.playerNotFound(ex.getInput());
            }
            return this.itemService.playerNotFound("[blank]");
        }))).argument(IntegerArgument.builder("amount").withMin(1).asOptional()).argument(EnumArgument.builder(OccupiedSlotHandling.class, "occupied_slot_handling").asOptionalWithDefault(OccupiedSlotHandling.REPLACE.name()).build()).handler(ctx -> {
            String key = (String)ctx.get("key");
            int slot = (Integer)ctx.get("slot");
            Option<Player> playerOpt = Option.ofOptional(ctx.getOptional("player")).orElse(() -> Option.when(ctx.getSender() instanceof Player, () -> (Player)ctx.getSender()));
            GiveItemDTO result = this.itemService.giveItem(key, (Player)playerOpt.getOrNull(), slot);
            KyoriHelper.sendMessage((CommandSender)ctx.getSender(), result.getMessage());
            playerOpt.flatMap(player -> result.getItemStack().map(item -> Tuple.of(player, item))).peek(t -> ((ItemStack)t._2).setAmount(ctx.getOrDefault("amount", Integer.valueOf(1)).intValue())).peek(tuple -> {
                boolean isSlotOccupied;
                OccupiedSlotHandling occupiedSlotHandling = (OccupiedSlotHandling)((Object)((Object)((Object)ctx.get("occupied_slot_handling"))));
                ItemStack slotItem = ((Player)tuple._1).getInventory().getItem(slot);
                boolean bl = isSlotOccupied = slotItem != null && !slotItem.getType().name().endsWith("AIR");
                if (!isSlotOccupied || occupiedSlotHandling == OccupiedSlotHandling.REPLACE) {
                    ((Player)tuple._1).getInventory().setItem(slot, (ItemStack)tuple._2);
                } else {
                    this.addItemToInventory(Option.of((ItemStack)tuple._2), ((ItemStack)tuple._2).getAmount(), (Player)playerOpt.get(), result.getDropMessage());
                }
            });
        }));
        commandManager.command(builder.literal("reload", new String[0]).permission("simpleitemgenerator.commands.reload").handler(ctx -> KyoriHelper.sendMessage((CommandSender)ctx.getSender(), this.itemService.reload())));
        commandManager.command(builder.literal("try_withdraw", new String[0]).permission("simpleitemgenerator.commands.try_withdraw").argument(StringArgument.builder("key").withSuggestionsProvider((ctx, s) -> this.itemService.getItemKeys().stream().filter(line -> line.contains((CharSequence)s)).collect(Collectors.toList()))).argument(CustomPlayerArgument.builder("player").withParser(new ArgumentParserWrapper(new PlayerArgument.PlayerParser(), e -> {
            if (e instanceof PlayerArgument.PlayerParseException) {
                PlayerArgument.PlayerParseException ex = (PlayerArgument.PlayerParseException)e;
                return this.itemService.playerNotFound(ex.getInput());
            }
            return this.itemService.playerNotFound("[blank]");
        }))).argument(IntegerArgument.builder("amount").withMin(1)).argument(StringArgument.greedy("command")).handler(ctx -> {
            String key = (String)ctx.get("key");
            Option playerOpt = Option.ofOptional(ctx.getOptional("player")).orElse(() -> Option.when(ctx.getSender() instanceof Player, () -> (Player)ctx.getSender()));
            int amount = ctx.getOrDefault("amount", Integer.valueOf(1));
            WithdrawItemDTO result = this.itemService.withdrawItem(key, (Player)playerOpt.getOrNull(), amount);
            KyoriHelper.sendMessage((CommandSender)ctx.getSender(), result.getSenderMessage());
            result.getReceiverMessage().peek(c -> KyoriHelper.sendMessage((CommandSender)ctx.getSender(), c));
            if (!result.isSuccess()) {
                return;
            }
            playerOpt.peek(player -> {
                AtomicInteger remainingAmount = new AtomicInteger(amount);
                Arrays.stream(player.getInventory().getContents()).filter(item -> NBTCustomItem.getCustomItemId(item).map(s -> s.equals(key)).getOrElse(false)).forEach(item -> {
                    if (remainingAmount.get() <= 0) {
                        return;
                    }
                    int toRemove = Math.min(remainingAmount.get(), item.getAmount());
                    remainingAmount.set(remainingAmount.get() - toRemove);
                    item.setAmount(item.getAmount() - toRemove);
                    if (item.getAmount() == 0) {
                        player.getInventory().remove(item);
                    }
                });
            });
            Bukkit.dispatchCommand((CommandSender)((CommandSender)ctx.getSender()), (String)((String)ctx.get("command")));
        }));
    }

    private void dropItems(Map<Integer, ItemStack> items, Location location, Player player, Component message) {
        int totalItems = items.values().stream().map(ItemStack::getAmount).reduce(Integer::sum).orElse(0);
        if (totalItems > 0) {
            KyoriHelper.sendMessage((CommandSender)player, message);
        }
        items.forEach((idx, item) -> {
            AtomicInteger totalAmount = new AtomicInteger(item.getAmount());
            int stack = item.getMaxStackSize();
            while (totalAmount.get() > 0) {
                int toRemove = Math.min(totalAmount.get(), stack);
                totalAmount.set(totalAmount.get() - toRemove);
                ItemStack clone = item.clone();
                clone.setAmount(toRemove);
                location.getWorld().dropItemNaturally(location, clone);
            }
        });
    }

    @Generated
    public CommandsController(ItemService itemService, InfoService infoService) {
        this.itemService = itemService;
        this.infoService = infoService;
    }

    private static enum OccupiedSlotHandling {
        REPLACE,
        ADD;

    }
}

