/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.usage;

import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;
import ua.valeriishymchuk.simpleitemgenerator.common.support.WorldGuardSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickAt;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickButton;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.PredicateInput;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.SlotPredicate;

public class Predicate {
    private static final boolean DEBUG = true;
    private static final boolean SLOT_DEBUG = false;
    @Nullable
    private final ClickButton button;
    @Nullable
    private final ClickAt at;
    @Nullable
    private final Map<String, Boolean> stateFlags;
    @Nullable
    private final Amount amount;
    @Nullable
    private final List<String> permissions;
    @Nullable
    private final List<Integer> timeTick;
    @Nullable
    private final SlotPredicate slots;
    @Nullable
    private final SlotPredicate prevSlots;

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)o;
        return this.button == predicate.button && this.at == predicate.at && Objects.equals(this.stateFlags, predicate.stateFlags) && Objects.equals(this.amount, predicate.amount) && Objects.equals(this.permissions, predicate.permissions) && Objects.equals(this.timeTick, predicate.timeTick) && Objects.equals(this.slots, predicate.slots);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.button, this.at, this.stateFlags, this.amount, this.permissions, this.timeTick, this.slots});
    }

    public Option<ClickButton> getButton() {
        return Option.of(this.button);
    }

    public Option<SlotPredicate> getSlots() {
        return Option.of(this.slots);
    }

    public Option<SlotPredicate> getPrevSlots() {
        return Option.of(this.prevSlots);
    }

    public Option<ClickAt> getAt() {
        return Option.of(this.at);
    }

    public Map<String, Boolean> getStateFlags() {
        return Option.of(this.stateFlags).getOrElse(Collections.EMPTY_MAP);
    }

    public List<String> getPermissions() {
        return Option.of(this.permissions).getOrElse(Collections.emptyList());
    }

    public Option<Amount> getAmount() {
        return Option.of(this.amount);
    }

    public List<Integer> getTimeTick() {
        return Option.of(this.timeTick).getOrElse(Collections.emptyList());
    }

    private <T> boolean isEmptyOrAnyMatch(List<T> list, java.util.function.Predicate<T> predicate) {
        if (list.isEmpty()) {
            return true;
        }
        return list.stream().anyMatch(predicate);
    }

    private boolean checkTime(PredicateInput input) {
        if (this.getTimeTick().isEmpty() && input.getTrigger() == PredicateInput.Trigger.TICK) {
            return false;
        }
        return this.isEmptyOrAnyMatch(this.getTimeTick(), tick -> input.getCurrentTick() % (long)tick.intValue() == 0L);
    }

    private static void printDebug(String msg) {
        System.out.println(msg);
    }

    public TestResult test(PredicateInput input) {
        boolean tickPass;
        Location location = input.getLocation().getOrElse(input.getPlayer().getLocation());
        boolean bl = tickPass = this.getTimeTick().isEmpty() && input.getTrigger() == PredicateInput.Trigger.TICK;
        if (tickPass) {
            return new TestResult(false, Collections.singletonList(PipelineDebug.root("Tick predicate is empty and its triggered by tick, skip...", new PipelineDebug.Tag[0])));
        }
        ArrayList<PipelineDebug> pipelineDebugs = new ArrayList<PipelineDebug>();
        boolean buttonMatch = this.getButton().map(side1 -> input.getButton().map(button -> button == side1).getOrElse(false)).getOrElse(true);
        if (this.getButton().isDefined()) {
            pipelineDebugs.add(PipelineDebug.root("Button match - " + buttonMatch, new PipelineDebug.Tag[0]));
        }
        boolean timeMatch = this.checkTime(input);
        if (!this.getTimeTick().isEmpty()) {
            pipelineDebugs.add(PipelineDebug.root("Time match - " + timeMatch, new PipelineDebug.Tag[0]));
        }
        boolean matchSlots = this.getSlots().map(slots1 -> {
            if (!input.getSlot().isOccupied()) {
                return false;
            }
            SlotPredicate.PredicateResult result = slots1.matches(input.getSlot());
            PipelineDebug slotMatchPipelineDebug = PipelineDebug.root("Slots match - " + result.isResult(), new PipelineDebug.Tag[0]);
            pipelineDebugs.add(slotMatchPipelineDebug.appendAllAndReturnSelf(result.getPipelineDebugs()));
            return result.isResult();
        }).getOrElse(true);
        boolean matchPrevSlots = this.getPrevSlots().map(slots1 -> {
            if (input.getSlot().isOccupied()) {
                return false;
            }
            SlotPredicate.PredicateResult result = slots1.matches(input.getSlot());
            PipelineDebug slotMatchPipelineDebug = PipelineDebug.root("Previous slots match - " + result.isResult(), new PipelineDebug.Tag[0]);
            pipelineDebugs.add(slotMatchPipelineDebug.appendAllAndReturnSelf(result.getPipelineDebugs()));
            return result.isResult();
        }).getOrElse(true);
        boolean matchAt = this.getAt().map(at1 -> at1 == input.getClickAt()).getOrElse(true);
        if (this.getAt().isDefined()) {
            pipelineDebugs.add(PipelineDebug.root("Match at - " + matchAt, new PipelineDebug.Tag[0]));
        }
        boolean matchAmount = this.getAmount().map(amount1 -> amount1.test(input.getAmount())).getOrElse(true);
        if (this.getAmount().isDefined()) {
            pipelineDebugs.add(PipelineDebug.root("Amount match - " + matchAmount, new PipelineDebug.Tag[0]));
        }
        boolean matchPermission = this.getPermissions().stream().allMatch(s -> input.getPlayer().hasPermission(s));
        if (!this.getPermissions().isEmpty()) {
            pipelineDebugs.add(PipelineDebug.root("Permission match - " + matchPermission, new PipelineDebug.Tag[0]));
        }
        boolean matchWg = HashMap.ofAll(this.getStateFlags()).forAll(t -> WorldGuardSupport.checkState(input.getPlayer(), location, (String)t._1).get() == t._2);
        if (!this.getStateFlags().isEmpty()) {
            pipelineDebugs.add(PipelineDebug.root("WG match - " + matchWg, new PipelineDebug.Tag[0]));
        }
        boolean testResult = buttonMatch && timeMatch && matchSlots && matchAt && matchAmount && matchPermission && matchWg && matchPrevSlots;
        return new TestResult(testResult, pipelineDebugs);
    }

    @Generated
    public Predicate(@Nullable ClickButton button, @Nullable ClickAt at, @Nullable Map<String, Boolean> stateFlags, @Nullable Amount amount, @Nullable List<String> permissions, @Nullable List<Integer> timeTick, @Nullable SlotPredicate slots, @Nullable SlotPredicate prevSlots) {
        this.button = button;
        this.at = at;
        this.stateFlags = stateFlags;
        this.amount = amount;
        this.permissions = permissions;
        this.timeTick = timeTick;
        this.slots = slots;
        this.prevSlots = prevSlots;
    }

    @Generated
    public String toString() {
        return "Predicate(button=" + this.getButton() + ", at=" + this.getAt() + ", stateFlags=" + this.getStateFlags() + ", amount=" + this.getAmount() + ", permissions=" + this.getPermissions() + ", timeTick=" + this.getTimeTick() + ", slots=" + this.getSlots() + ", prevSlots=" + this.getPrevSlots() + ")";
    }

    @Generated
    public Predicate withButton(@Nullable ClickButton button) {
        return this.button == button ? this : new Predicate(button, this.at, this.stateFlags, this.amount, this.permissions, this.timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withAt(@Nullable ClickAt at) {
        return this.at == at ? this : new Predicate(this.button, at, this.stateFlags, this.amount, this.permissions, this.timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withStateFlags(@Nullable Map<String, Boolean> stateFlags) {
        return this.stateFlags == stateFlags ? this : new Predicate(this.button, this.at, stateFlags, this.amount, this.permissions, this.timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withAmount(@Nullable Amount amount) {
        return this.amount == amount ? this : new Predicate(this.button, this.at, this.stateFlags, amount, this.permissions, this.timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withPermissions(@Nullable List<String> permissions) {
        return this.permissions == permissions ? this : new Predicate(this.button, this.at, this.stateFlags, this.amount, permissions, this.timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withTimeTick(@Nullable List<Integer> timeTick) {
        return this.timeTick == timeTick ? this : new Predicate(this.button, this.at, this.stateFlags, this.amount, this.permissions, timeTick, this.slots, this.prevSlots);
    }

    @Generated
    public Predicate withSlots(@Nullable SlotPredicate slots) {
        return this.slots == slots ? this : new Predicate(this.button, this.at, this.stateFlags, this.amount, this.permissions, this.timeTick, slots, this.prevSlots);
    }

    @Generated
    public Predicate withPrevSlots(@Nullable SlotPredicate prevSlots) {
        return this.prevSlots == prevSlots ? this : new Predicate(this.button, this.at, this.stateFlags, this.amount, this.permissions, this.timeTick, this.slots, prevSlots);
    }

    public static class Amount {
        private final Integer totalAmount;
        private final Integer stackAmount;

        public Option<Integer> getTotalAmount() {
            return Option.of(this.totalAmount);
        }

        public Option<Integer> getStackAmount() {
            return Option.of(this.stackAmount);
        }

        public boolean test(PredicateInput.Amount input) {
            return this.getStackAmount().map(stackAmount1 -> stackAmount1 <= input.getStackAmount()).getOrElse(true) != false && this.getTotalAmount().map(totalAmount1 -> totalAmount1 <= input.getTotalAmount()).getOrElse(true) != false;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Amount amount = (Amount)o;
            return Objects.equals(this.totalAmount, amount.totalAmount) && Objects.equals(this.stackAmount, amount.stackAmount);
        }

        public int hashCode() {
            return Objects.hash(this.totalAmount, this.stackAmount);
        }

        @Generated
        public Amount(Integer totalAmount, Integer stackAmount) {
            this.totalAmount = totalAmount;
            this.stackAmount = stackAmount;
        }
    }

    public static class TestResult {
        private final boolean testResult;
        private final List<PipelineDebug> debugs;

        @Generated
        public TestResult(boolean testResult, List<PipelineDebug> debugs) {
            this.testResult = testResult;
            this.debugs = debugs;
        }

        @Generated
        public boolean isTestResult() {
            return this.testResult;
        }

        @Generated
        public List<PipelineDebug> getDebugs() {
            return this.debugs;
        }
    }
}

