/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.support;

import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;

public class PapiSupport {
    private static final String NAME = "PlaceholderAPI";

    public static boolean isPluginEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled(NAME);
    }

    public static void ensureEnabled() {
        if (!PapiSupport.isPluginEnabled()) {
            throw new IllegalStateException("Plugin PlaceholderAPI is not enabled!");
        }
    }

    public static String parse(OfflinePlayer player, String text) {
        PapiSupport.ensureEnabled();
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
    }

    public static String tryParse(@Nullable OfflinePlayer player, String text) {
        if (!PapiSupport.isPluginEnabled()) {
            return text;
        }
        if (player == null) {
            return text;
        }
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
    }

    public static Component tryParseComponent(@Nullable OfflinePlayer player, Component text) {
        if (!PapiSupport.isPluginEnabled()) {
            return text;
        }
        if (player == null) {
            return text;
        }
        String rawText = KyoriHelper.toJson(text);
        String output = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)rawText);
        return KyoriHelper.fromJson(output);
    }
}

