/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.support;

import io.vavr.Lazy;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class NexoSupport {
    private static final String NAME = "Nexo";
    private static final String NEXO_PACKAGE = "com.nexomc.nexo";
    private static final String NEXO_API_PACKAGE = "com.nexomc.nexo.api";
    private static final Lazy<Class<?>> NEXO_ITEMS_CLASS_LAZY = Lazy.of(() -> {
        try {
            return Class.forName(NEXO_API_PACKAGE + ".NexoItems");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    });

    public static ItemStack getItem(String key) {
        NexoSupport.ensureEnabled();
        Class<?> nexoItemsClass = NEXO_ITEMS_CLASS_LAZY.get();
        Optional<ItemStack> instance = ((Optional)nexoItemsClass.getMethod("optionalItemFromId", String.class).invoke(null, key)).map(itemBuilder -> {
            try {
                return (ItemStack)itemBuilder.getClass().getMethod("build", new Class[0]).invoke(itemBuilder, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        return instance.orElseThrow(() -> new IllegalArgumentException("Unknown item: " + key));
    }

    public static void ensureEnabled() {
        if (!NexoSupport.isPluginEnabled()) {
            throw new IllegalStateException("Plugin Nexo is not enabled!");
        }
    }

    public static boolean isPluginEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled(NAME);
    }
}

