/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.reflection;

import io.vavr.control.Option;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;

public class ReflectionObject {
    private final Class<?> clazz;
    private final Object object;

    public static ReflectionObject of(Object object) {
        return new ReflectionObject(object.getClass(), object);
    }

    public static ReflectionObject[] ofArray(Object ... objects) {
        return (ReflectionObject[])Arrays.stream(objects).map(ReflectionObject::of).toArray(ReflectionObject[]::new);
    }

    public static ReflectionObject ofStatic(Class<?> clazz) {
        return new ReflectionObject(clazz, null);
    }

    public static ReflectionObject newInstance(Class<?> clazz, Object ... args) {
        return ReflectionObject.newInstance(clazz, ReflectionObject.ofArray(args));
    }

    public static ReflectionObject newInstance(Class<?> clazz, ReflectionObject ... args) {
        return new ReflectionObject(clazz, clazz.getConstructor(ReflectionObject.toClassesArray(args)).newInstance(ReflectionObject.toObjectsArray(args)));
    }

    public static Class<?>[] toClassesArray(ReflectionObject ... args) {
        return (Class[])Arrays.stream(args).map(ReflectionObject::getClazz).toArray(Class[]::new);
    }

    public static Object[] toObjectsArray(ReflectionObject ... args) {
        return Arrays.stream(args).map(ReflectionObject::getObject).toArray();
    }

    public <T> T cast() {
        return (T)this.object;
    }

    public Option<ReflectionObject> invokePublic(String methodName, Object ... args) {
        return this.invokePublic(methodName, ReflectionObject.ofArray(args));
    }

    public boolean hasPublicMethod(String methodName, Class<?> ... args) {
        try {
            this.clazz.getMethod(methodName, args);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public Option<ReflectionObject> invokePublic(String methodName, ReflectionObject ... args) {
        Method method = Arrays.stream(this.clazz.getMethods()).filter(filterMethod -> filterMethod.getName().equals(methodName)).filter(filterMethod -> {
            if (filterMethod.getParameterCount() != args.length) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                if (filterMethod.getParameterTypes()[i].isAssignableFrom(args[i].getClazz())) continue;
                return false;
            }
            return true;
        }).findFirst().orElseThrow(() -> new NullPointerException("Method " + methodName + " with parameters " + Arrays.toString(ReflectionObject.toClassesArray(args)) + " not found.\nPossible methods:\n" + Arrays.toString(Arrays.stream(this.clazz.getMethods()).filter(m -> m.getName().contains(methodName)).map(m -> m.getName() + "(" + String.join((CharSequence)",", Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.toList())) + ")\n").toArray())));
        Class<?> returnClass = method.getReturnType();
        return Option.of(method.invoke(this.object, ReflectionObject.toObjectsArray(args))).map(obj -> new ReflectionObject(returnClass, obj));
    }

    @Generated
    public ReflectionObject(Class<?> clazz, Object object) {
        this.clazz = clazz;
        this.object = object;
    }

    @Generated
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Generated
    public Object getObject() {
        return this.object;
    }
}

