/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.reflection;

import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import ua.valeriishymchuk.libs.net.kyori.adventure.key.Key;
import ua.valeriishymchuk.simpleitemgenerator.common.boundingbox.BoundingBox;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.MinecraftReflection;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectionObject;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.Color;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.builtin.item.ItemCustomModelData;

public class ReflectedRepresentations {

    public static class Enchantment {
        public static final Class<org.bukkit.enchantments.Enchantment> CLASS = org.bukkit.enchantments.Enchantment.class;

        @Deprecated(forRemoval=true)
        public static org.bukkit.enchantments.Enchantment getByKey(Key key) {
            return Enchantment.getByKey(key.asString());
        }

        @Deprecated(forRemoval=true)
        public static Option<org.bukkit.enchantments.Enchantment> tryGetByKey(Key key) {
            return Enchantment.tryGetByKey(key.asString());
        }

        @Deprecated(forRemoval=true)
        public static Option<org.bukkit.enchantments.Enchantment> tryGetByKey(String key) {
            return Option.of(Enchantment.getByKey(key));
        }

        @Deprecated(forRemoval=true)
        public static org.bukkit.enchantments.Enchantment getByKey(String key) {
            return org.bukkit.enchantments.Enchantment.getByKey((org.bukkit.NamespacedKey)org.bukkit.NamespacedKey.fromString((String)key));
        }

        @Deprecated(forRemoval=true)
        public static ReflectionObject getNamespacedKey(org.bukkit.enchantments.Enchantment enchantment) {
            Enchantment.ensureNamespacedEnchantmentsSupport();
            return new ReflectionObject(CLASS, enchantment).invokePublic("getKey", new ReflectionObject[0]).get();
        }

        @Deprecated(forRemoval=true)
        public static Option<Key> tryGetKey(org.bukkit.enchantments.Enchantment enchantment) {
            return Option.of(Enchantment.getKyoriKey(enchantment));
        }

        @Deprecated(forRemoval=true)
        public static Key getKyoriKey(org.bukkit.enchantments.Enchantment enchantment) {
            Enchantment.ensureNamespacedEnchantmentsSupport();
            return NamespacedKey.getKyoriKey(Enchantment.getNamespacedKey(enchantment));
        }

        private static void ensureNamespacedEnchantmentsSupport() {
            if (!FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT) {
                throw new IllegalStateException("Namespaced enchantments is supported from >=1.13. Current version " + SemanticVersion.CURRENT_MINECRAFT);
            }
        }
    }

    public static class ItemMeta {
        public static final Class<org.bukkit.inventory.meta.ItemMeta> CLASS = org.bukkit.inventory.meta.ItemMeta.class;
        public static final Class<?> CRAFT_META = MinecraftReflection.getCraftBukkit("inventory.CraftMetaItem");
        public static final Field DISPLAY_NAME_FIELD;
        public static final Field LORE_FIELD;

        public static void clearToolComponent(org.bukkit.inventory.meta.ItemMeta meta) {
            try {
                Method getTool = org.bukkit.inventory.meta.ItemMeta.class.getMethod("getTool", new Class[0]);
                getTool.setAccessible(true);
                Class<?> toolClass = getTool.getReturnType();
                Method setTool = org.bukkit.inventory.meta.ItemMeta.class.getMethod("setTool", toolClass);
                setTool.setAccessible(true);
                setTool.invoke((Object)meta, new Object[]{null});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void copyToolComponent(org.bukkit.inventory.meta.ItemMeta src, org.bukkit.inventory.meta.ItemMeta dst) {
            try {
                Method getTool = org.bukkit.inventory.meta.ItemMeta.class.getMethod("getTool", new Class[0]);
                getTool.setAccessible(true);
                Class<?> toolClass = getTool.getReturnType();
                Object tool = getTool.invoke((Object)src, new Object[0]);
                Method setTool = org.bukkit.inventory.meta.ItemMeta.class.getMethod("setTool", toolClass);
                setTool.invoke((Object)dst, tool);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }

        public static Option<ItemCustomModelData> getModernCustomModelData(org.bukkit.inventory.meta.ItemMeta itemMeta) {
            if (!FeatureSupport.MODERN_CMD_SUPPORT) {
                return Option.none();
            }
            Class<?> cmdBukkitComponentClass = Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
            Object bukkitCmdComponent = CLASS.getMethod("getCustomModelDataComponent", new Class[0]).invoke((Object)itemMeta, new Object[0]);
            Method getFloats = cmdBukkitComponentClass.getMethod("getFloats", new Class[0]);
            Method getFlags = cmdBukkitComponentClass.getMethod("getFlags", new Class[0]);
            Method getStrings = cmdBukkitComponentClass.getMethod("getStrings", new Class[0]);
            Method getColors = cmdBukkitComponentClass.getMethod("getColors", new Class[0]);
            return Option.some(new ItemCustomModelData((List)getFloats.invoke(bukkitCmdComponent, new Object[0]), (List)getFlags.invoke(bukkitCmdComponent, new Object[0]), (List)getStrings.invoke(bukkitCmdComponent, new Object[0]), ((List)getColors.invoke(bukkitCmdComponent, new Object[0])).stream().map(bukkitColor -> new Color(bukkitColor.getRed(), bukkitColor.getGreen(), bukkitColor.getBlue())).toList()));
        }

        public static void setModernCustomModelData(org.bukkit.inventory.meta.ItemMeta itemMeta, ItemCustomModelData customModelData) {
            if (!FeatureSupport.MODERN_CMD_SUPPORT) {
                return;
            }
            Class<?> cmdBukkitComponentClass = Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
            Object bukkitCmdComponent = CLASS.getMethod("getCustomModelDataComponent", new Class[0]).invoke((Object)itemMeta, new Object[0]);
            Method setFloats = cmdBukkitComponentClass.getMethod("setFloats", List.class);
            Method setFlags = cmdBukkitComponentClass.getMethod("setFlags", List.class);
            Method setStrings = cmdBukkitComponentClass.getMethod("setStrings", List.class);
            Method setColors = cmdBukkitComponentClass.getMethod("setColors", List.class);
            setFloats.invoke(bukkitCmdComponent, customModelData.getFloats());
            setFlags.invoke(bukkitCmdComponent, customModelData.getFlags());
            setStrings.invoke(bukkitCmdComponent, customModelData.getStrings());
            setColors.invoke(bukkitCmdComponent, customModelData.getColors().stream().map(packetEventsColor -> org.bukkit.Color.fromRGB((int)packetEventsColor.asRGB())).toList());
        }

        static {
            try {
                DISPLAY_NAME_FIELD = CRAFT_META.getDeclaredField("displayName");
                LORE_FIELD = CRAFT_META.getDeclaredField("lore");
                DISPLAY_NAME_FIELD.setAccessible(true);
                LORE_FIELD.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class NamespacedKey {
        public static final Class<?> CLASS;

        @Deprecated(forRemoval=true)
        public static ReflectionObject of(String namespace, String key) {
            NamespacedKey.validate();
            return ReflectionObject.newInstance(CLASS, namespace, key);
        }

        @Deprecated(forRemoval=true)
        public static ReflectionObject from(Key key) {
            return NamespacedKey.of(key.namespace(), key.value());
        }

        @Deprecated(forRemoval=true)
        public static ReflectionObject from(String key) {
            return NamespacedKey.from(Key.key(key));
        }

        @Deprecated(forRemoval=true)
        public static Key getKyoriKey(ReflectionObject reflectionObject) {
            NamespacedKey.validate();
            if (reflectionObject.getClazz() != CLASS) {
                throw new IllegalArgumentException("Not a namespaced key " + reflectionObject.getClazz() + " " + reflectionObject.getObject());
            }
            return Key.key(reflectionObject.getObject().toString());
        }

        private static void validate() {
            if (CLASS == null) {
                SemanticVersion.CURRENT_MINECRAFT.assertAtLeast(1, 13);
            }
        }

        static {
            try {
                CLASS = SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 13) ? Class.forName("org.bukkit.NamespacedKey") : null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Entity {
        public static final Class<org.bukkit.entity.Entity> CLASS = org.bukkit.entity.Entity.class;
        public static final Class<?> CRAFT_ENTITY = MinecraftReflection.getCraftBukkit("entity.CraftEntity");

        private static Class<?> getEntityClass(@NonNull Class<?> entityDerivative) {
            if (entityDerivative == null) {
                throw new NullPointerException("entityDerivative is marked non-null but is null");
            }
            if (entityDerivative.getName().endsWith("Entity")) {
                return entityDerivative;
            }
            return Entity.getEntityClass(entityDerivative.getSuperclass());
        }

        public static BoundingBox getEntitiesBoundingBox(org.bukkit.entity.Entity entity) {
            Object nmsEntity = CRAFT_ENTITY.getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
            Class<?> nmsEntityClass = Entity.getEntityClass(nmsEntity.getClass());
            boolean hasBoundingBoxMethod = Arrays.stream(nmsEntityClass.getMethods()).anyMatch(m -> m.getName().equals("getBoundingBox"));
            Object nmsBoundingBox = hasBoundingBoxMethod ? nmsEntity.getClass().getMethod("getBoundingBox", new Class[0]).invoke(nmsEntity, new Object[0]) : Arrays.stream(nmsEntityClass.getDeclaredFields()).filter(field -> field.getType().getName().endsWith("BB")).filter(field -> (field.getModifiers() & 8) == 0).peek(f -> f.setAccessible(true)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find AABB field in " + nmsEntityClass.getName())).get(nmsEntity);
            double[] inputs = Arrays.stream(nmsBoundingBox.getClass().getFields()).map(CheckedFunction1.of(field -> (double)((Double)field.get(nmsBoundingBox))).unchecked()).mapToDouble(i -> i).toArray();
            return new BoundingBox(inputs[0], inputs[1], inputs[2], inputs[3], inputs[4], inputs[5]);
        }
    }

    public static class PotionEffect {
        public static final Class<org.bukkit.potion.PotionEffect> CLASS = org.bukkit.potion.PotionEffect.class;

        public static Option<org.bukkit.potion.PotionEffect> create(PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles, boolean icon) {
            Constructor constructor = Arrays.stream(CLASS.getConstructors()).filter(c -> c.getParameterCount() == 6 && c.getParameterTypes()[0].equals(PotionEffectType.class) && c.getParameterTypes()[1].equals(Integer.TYPE) && c.getParameterTypes()[2].equals(Integer.TYPE) && c.getParameterTypes()[3].equals(Boolean.TYPE) && c.getParameterTypes()[4].equals(Boolean.TYPE) && c.getParameterTypes()[5].equals(Boolean.TYPE)).findFirst().orElse(null);
            if (constructor == null) {
                return Option.none();
            }
            return Option.some((org.bukkit.potion.PotionEffect)constructor.newInstance(type, duration, amplifier, ambient, particles, icon));
        }
    }

    public static class PotionMeta {
        public static final Class<org.bukkit.inventory.meta.PotionMeta> CLASS = org.bukkit.inventory.meta.PotionMeta.class;

        public static boolean setColor(org.bukkit.inventory.meta.PotionMeta meta, org.bukkit.Color color) {
            AtomicBoolean result = new AtomicBoolean(false);
            Arrays.stream(CLASS.getMethods()).filter(m -> m.getParameterTypes().length == 1 && m.getParameterTypes()[0].equals(org.bukkit.Color.class)).findFirst().ifPresent(m -> {
                try {
                    m.invoke((Object)meta, color);
                    result.set(true);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
            return result.get();
        }
    }

    public static class World {
        public static final Class<org.bukkit.World> CLASS = org.bukkit.World.class;

        public static int getMinHeight(org.bukkit.World world) {
            try {
                Method getMinHeight = CLASS.getMethod("getMinHeight", new Class[0]);
                return (Integer)getMinHeight.invoke((Object)world, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return 0;
            }
        }
    }

    public static class Material {
        @Deprecated(forRemoval=true)
        public static boolean isItem(org.bukkit.Material material) {
            return material.isItem();
        }
    }

    public static class EntityEquipment {
        public static final Class<org.bukkit.inventory.EntityEquipment> CLASS = org.bukkit.inventory.EntityEquipment.class;

        @Deprecated(forRemoval=true)
        public static void setItemInOffhand(org.bukkit.inventory.EntityEquipment equipment, org.bukkit.inventory.ItemStack item) {
            equipment.setItem(EquipmentSlot.OFF_HAND, item);
        }

        @Deprecated(forRemoval=true)
        public static Option<org.bukkit.inventory.ItemStack> getItemInOffhand(org.bukkit.inventory.EntityEquipment equipment) {
            return Option.of(equipment.getItem(EquipmentSlot.OFF_HAND)).filter(itemStack -> itemStack.getType().isAir());
        }
    }

    public static class PlayerInteractEvent {
        @Deprecated(forRemoval=true)
        public static EquipmentSlot getClickedItemSlot(org.bukkit.event.player.PlayerInteractEvent event) {
            return event.getHand();
        }
    }

    public static class ItemStack {
        public static Class<org.bukkit.inventory.ItemStack> ITEM_STACK_CLASS = org.bukkit.inventory.ItemStack.class;

        public static org.bukkit.inventory.ItemStack createItemStack(org.bukkit.Material material) {
            try {
                Method method = ITEM_STACK_CLASS.getMethod("of", org.bukkit.Material.class);
                return (org.bukkit.inventory.ItemStack)method.invoke(null, material);
            }
            catch (Throwable e) {
                return new org.bukkit.inventory.ItemStack(material);
            }
        }
    }
}

