/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.nbt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.BinaryTagIO;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.CompoundBinaryTag;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadWriteNBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadableNBT;

public class NBTConverter {
    public static CompoundBinaryTag fromNBTApi(ReadableNBT nbt) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        nbt.writeCompound(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return BinaryTagIO.reader().read(bais, BinaryTagIO.Compression.GZIP);
    }

    public static ReadWriteNBT toNBTApi(CompoundBinaryTag nbt) {
        Objects.requireNonNull(nbt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryTagIO.writer().write(nbt, baos, BinaryTagIO.Compression.GZIP);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return NBT.readNBT(bais);
    }
}

