/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import io.vavr.control.Option;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class NBTCustomItem {
    private static final NamespacedKey CUSTOM_ITEM_ID_KEY = NBTCustomItem.key("custom_item_id");
    private static final NamespacedKey CUSTOM_ITEM_COOLDOWN_KEY = NBTCustomItem.key("custom_item_cooldown");
    private static final NamespacedKey CUSTOM_ITEM_COOLDOWN_FREEZETIME_KEY = NBTCustomItem.key("custom_item_freezetime");
    private static final NamespacedKey CUSTOM_ITEM_SIGNATURE = NBTCustomItem.key("custom_item_signature");
    private static final NamespacedKey CUSTOM_ITEM_LAST_HOLDER = NBTCustomItem.key("last_holder");

    private static NamespacedKey key(String value) {
        return NamespacedKey.fromString((String)("simpleitemgenerator:" + value));
    }

    private static NamespacedKey cooldown(int cooldownId) {
        return NamespacedKey.fromString((String)(CUSTOM_ITEM_COOLDOWN_KEY.asString() + cooldownId));
    }

    private static NamespacedKey freezeTime(int cooldownId) {
        return NamespacedKey.fromString((String)(CUSTOM_ITEM_COOLDOWN_FREEZETIME_KEY.asString() + cooldownId));
    }

    public static Option<String> getCustomItemId(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return Option.none();
        }
        return Option.of((String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING));
    }

    public static boolean hasCustomItemId(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING);
    }

    public static void setCustomItemId(ItemStack item, String customItemId) {
        NBTCustomItem.updateNBT(item, persistentDataContainer -> persistentDataContainer.set(CUSTOM_ITEM_ID_KEY, PersistentDataType.STRING, (Object)customItemId));
    }

    private static void updateNBT(ItemStack item, Consumer<PersistentDataContainer> consumer) {
        ItemMeta itemMeta = item.getItemMeta();
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        consumer.accept(persistentDataContainer);
        item.setItemMeta(itemMeta);
    }

    public static void setSignature(ItemStack item, int signature) {
        NBTCustomItem.updateNBT(item, persistentDataContainer -> persistentDataContainer.set(CUSTOM_ITEM_SIGNATURE, PersistentDataType.INTEGER, (Object)signature));
    }

    public static Option<Integer> getSignature(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return Option.none();
        }
        return Option.of((Integer)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_SIGNATURE, PersistentDataType.INTEGER));
    }

    public static Option<String> getLastHolder(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return Option.none();
        }
        return Option.of((String)item.getItemMeta().getPersistentDataContainer().get(CUSTOM_ITEM_LAST_HOLDER, PersistentDataType.STRING));
    }

    public static void setLastHolder(ItemStack item, @Nullable String userName) {
        if (item == null || item.getType().isAir()) {
            return;
        }
        NBTCustomItem.updateNBT(item, persistentDataContainer -> {
            if (userName != null) {
                persistentDataContainer.set(CUSTOM_ITEM_LAST_HOLDER, PersistentDataType.STRING, (Object)userName);
            } else {
                persistentDataContainer.remove(CUSTOM_ITEM_LAST_HOLDER);
            }
        });
    }

    public static Cooldown getCooldown(ItemStack itemStack, int cooldownId) {
        PersistentDataContainer persistentDataContainer = itemStack.getItemMeta().getPersistentDataContainer();
        Long cooldown = (Long)persistentDataContainer.get(NBTCustomItem.cooldown(cooldownId), PersistentDataType.LONG);
        Long freezetime = (Long)persistentDataContainer.get(NBTCustomItem.freezeTime(cooldownId), PersistentDataType.LONG);
        if (cooldown == null || cooldown < System.currentTimeMillis()) {
            return CooldownType.NONE.toCooldown(0L);
        }
        if (freezetime == null || freezetime < System.currentTimeMillis()) {
            return CooldownType.DEFAULT.toCooldown(cooldown);
        }
        return CooldownType.FROZEN.toCooldown(freezetime);
    }

    public static Cooldown queryCooldown(ItemStack itemStack, long cooldownMillis, long freezetimeMillis, int cooldownId) {
        Cooldown cooldown = NBTCustomItem.getCooldown(itemStack, cooldownId);
        if (cooldown.isFrozen()) {
            return cooldown;
        }
        if (cooldown.isAbsent()) {
            NBTCustomItem.updateCooldown(itemStack, cooldownMillis <= 0L ? null : Long.valueOf(System.currentTimeMillis() + cooldownMillis), cooldownId);
            NBTCustomItem.updateFreezetime(itemStack, freezetimeMillis <= 0L || cooldownMillis <= 0L ? null : Long.valueOf(System.currentTimeMillis() + freezetimeMillis), cooldownId);
            return CooldownType.NONE.toCooldown(0L);
        }
        NBTCustomItem.updateFreezetime(itemStack, System.currentTimeMillis() + freezetimeMillis, cooldownId);
        return cooldown;
    }

    public static void updateCooldown(ItemStack itemStack, @Nullable Long cooldown, int cooldownId) {
        if (cooldown == null) {
            return;
        }
        if (cooldown <= 0L) {
            return;
        }
        NBTCustomItem.updateNBT(itemStack, persistentDataContainer -> persistentDataContainer.set(NBTCustomItem.cooldown(cooldownId), PersistentDataType.LONG, (Object)cooldown));
    }

    public static void updateFreezetime(ItemStack itemStack, @Nullable Long freezetime, int cooldownId) {
        if (freezetime == null) {
            return;
        }
        if (freezetime <= 0L) {
            return;
        }
        NBTCustomItem.updateNBT(itemStack, persistentDataContainer -> persistentDataContainer.set(NBTCustomItem.freezeTime(cooldownId), PersistentDataType.LONG, (Object)freezetime));
    }

    public static enum CooldownType {
        NONE,
        DEFAULT,
        FROZEN;


        public Cooldown toCooldown(long epoch) {
            return new Cooldown(this, epoch - System.currentTimeMillis());
        }
    }

    public static class Cooldown {
        private final CooldownType type;
        private final long remainingMillis;

        public boolean isFrozen() {
            return this.type == CooldownType.FROZEN;
        }

        public boolean isDefault() {
            return this.type == CooldownType.DEFAULT;
        }

        public boolean isAbsent() {
            return this.type == CooldownType.NONE;
        }

        @Generated
        public Cooldown(CooldownType type, long remainingMillis) {
            this.type = type;
            this.remainingMillis = remainingMillis;
        }

        @Generated
        public CooldownType getType() {
            return this.type;
        }

        @Generated
        public long getRemainingMillis() {
            return this.remainingMillis;
        }
    }
}

