/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import lombok.Generated;

public class PipelineDebug {
    private static final Logger LOGGER = Logger.getLogger("SIG-PIPELINE");
    private final String name;
    private final List<PipelineDebug> children = new ArrayList<PipelineDebug>();
    private final Set<Tag> tags = new HashSet<Tag>();

    public static PipelineDebug prepend(PipelineDebug other, String name, Tag ... tags) {
        PipelineDebug debug = new PipelineDebug(name);
        debug.tags.addAll(Arrays.asList(tags));
        debug.children.add(other);
        return debug;
    }

    public static PipelineDebug root(String name, Tag ... tags) {
        PipelineDebug debug = new PipelineDebug(name);
        debug.tags.addAll(Arrays.asList(tags));
        return debug;
    }

    public PipelineDebug append(String name, Tag ... tags) {
        PipelineDebug newChild = new PipelineDebug(name);
        newChild.tags.addAll(Arrays.asList(tags));
        this.children.add(newChild);
        return newChild;
    }

    public PipelineDebug appendAndReturnSelf(String name, Tag ... tags) {
        this.append(name, tags);
        return this;
    }

    public PipelineDebug appendAllAndReturnSelf(Collection<PipelineDebug> debugs) {
        this.children.addAll(debugs);
        return this;
    }

    public void print(Tag ... excludeTags) {
        LOGGER.info(this.get(excludeTags));
    }

    public String get(Tag ... excludeTags) {
        StringBuilder sb = new StringBuilder(this.name).append('\n');
        this.children.stream().filter(debug -> Arrays.stream(excludeTags).noneMatch(this.tags::contains)).forEach(child -> {
            sb.append(child.name).append('\n');
            child.children.stream().filter(debug -> Arrays.stream(excludeTags).noneMatch(this.tags::contains)).forEach(grandChild -> Arrays.stream(grandChild.getDescenders(excludeTags).split("\n")).map(s -> "|--" + s + "\n").forEach(sb::append));
        });
        return sb.toString();
    }

    private String getDescenders(Tag ... excludeTags) {
        StringBuilder sb = new StringBuilder(">").append(this.name).append('\n');
        this.children.stream().filter(debug -> Arrays.stream(excludeTags).noneMatch(this.tags::contains)).forEach(debug -> Arrays.stream(debug.getDescenders(excludeTags).split("\n")).map(s -> "--" + s + "\n").forEach(sb::append));
        return sb.toString();
    }

    @Generated
    private PipelineDebug(String name) {
        this.name = name;
    }

    public static enum Tag {
        TICK,
        INVENTORY,
        OTHER;

    }
}

