/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.config.tools;

import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.util.Arrays;
import java.util.List;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.text.StringSimilarityUtils;

public class ConfigParsingHelper {
    public static <E extends Enum<E>> Validation<InvalidConfigurationException, E> parseEnum(Class<E> eClass, String raw, String optionName) {
        return ConfigParsingHelper.parseEnum(eClass, raw, optionName, optionName);
    }

    public static <E extends Enum<E>> Validation<InvalidConfigurationException, E> parseEnum(Class<E> eClass, String raw, String optionName, String path) {
        return ConfigParsingHelper.parseEnumWithoutPath(eClass, raw, optionName).mapError(InvalidConfigurationException.Lambda.path(path));
    }

    public static <E extends Enum<E>> Validation<InvalidConfigurationException, E> parseEnumWithoutPath(Class<E> eClass, String raw, String optionName) {
        String upper = raw.toUpperCase();
        return Validation.fromTry(Try.ofSupplier(() -> Enum.valueOf(eClass, upper))).mapError(e -> {
            if (e instanceof IllegalArgumentException) {
                List<String> suggestions = StringSimilarityUtils.getSuggestions(upper, Arrays.stream((Enum[])eClass.getEnumConstants()).map(Enum::name));
                return InvalidConfigurationException.unknownOption(optionName, raw, suggestions);
            }
            return InvalidConfigurationException.unhandledException(e);
        });
    }
}

