/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.config;

import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.config.IConfigLoaderConfigurator;
import ua.valeriishymchuk.simpleitemgenerator.common.config.error.ConfigurationError;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader.ConfigurationLoader;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;

public class ConfigLoader {
    private final File folder;
    private final String extension;
    private final IConfigLoaderConfigurator configurator;

    public <T, C> T applyContext(Class<C> clazz, String key, Function<ContextLoader<C>, T> mapper) {
        this.validateConfigClass(clazz);
        return mapper.apply(new ContextLoader<C>(clazz, key));
    }

    public <C> Validation<ConfigurationError, C> loadOrSave(Class<C> clazz, String key, C defaultConfig) {
        return this.applyContext(clazz, key, c -> {
            Validation loadResult = c.load();
            if (loadResult.isValid()) {
                return loadResult;
            }
            if (loadResult.getError().isFileNotPresent()) {
                return c.save(defaultConfig).map(v -> defaultConfig);
            }
            return loadResult;
        });
    }

    public <C> Validation<ConfigurationError, C> loadOrSave(Class<C> clazz, String key) {
        try {
            this.validateConfigClass(clazz);
            return this.loadOrSave(clazz, key, this.emptyConstructor(clazz).apply());
        }
        catch (Throwable e) {
            return ConfigurationError.handleValidationException(e);
        }
    }

    public <C> Validation<ConfigurationError, Option<C>> safeLoad(Class<C> clazz, String key) {
        Validation<ConfigurationError, C> rawResult = this.load(clazz, key);
        if (rawResult.isValid()) {
            return Validation.valid(Option.some(rawResult.get()));
        }
        ConfigurationError err = rawResult.getError();
        if (err instanceof ConfigurationError.FileNotPresent) {
            return Validation.valid(Option.none());
        }
        return Validation.invalid(err);
    }

    /*
     * Loose catch block
     */
    public <C> Validation<ConfigurationError, C> load(Class<C> clazz, String key) {
        try {
            this.validateConfigClass(clazz);
            File file = this.getFile(key);
            if (!file.exists()) {
                return Validation.invalid(ConfigurationError.FileNotPresent.INSTANCE);
            }
            ConfigurationLoader<?> loader = this.configurator.configure(file);
            Object rootNode = loader.load();
            return Validation.valid(Objects.requireNonNull(rootNode.get(clazz)));
        }
        catch (Throwable e) {
            return ConfigurationError.handleValidationException(e);
            {
                catch (Throwable $ex) {
                    throw $ex;
                }
            }
        }
    }

    public boolean exists(String key) {
        File file = this.getFile(key);
        return file.exists() && file.isFile();
    }

    public <C> Validation<ConfigurationError, C> loadOrDefault(Class<C> clazz, String key, C defaultConfig) {
        Validation<ConfigurationError, C> loadResult = this.load(clazz, key);
        if (loadResult.isValid()) {
            return loadResult;
        }
        if (loadResult.getError().isFileNotPresent()) {
            return Validation.valid(defaultConfig);
        }
        return loadResult;
    }

    public <C> Validation<ConfigurationError, C> loadOrDefault(Class<C> clazz, String key) {
        try {
            this.validateConfigClass(clazz);
            return this.loadOrDefault(clazz, key, this.emptyConstructor(clazz).apply());
        }
        catch (Throwable e) {
            return ConfigurationError.handleValidationException(e);
        }
    }

    public <C> Validation<ConfigurationError, Void> save(Class<C> clazz, String key, C config) {
        try {
            this.validateConfigClass(clazz);
            File file = this.getFile(key);
            ConfigurationLoader<?> loader = this.configurator.configure(file);
            Object rootNode = loader.load();
            rootNode.set(clazz, config);
            loader.save((ConfigurationNode)rootNode);
            return Validation.valid(null);
        }
        catch (Throwable e) {
            return ConfigurationError.handleValidationException(e);
        }
    }

    public <C> Validation<ConfigurationError, Void> saveDefault(Class<C> clazz, String key) {
        try {
            this.validateConfigClass(clazz);
            return this.save(clazz, key, this.emptyConstructor(clazz).apply());
        }
        catch (Throwable e) {
            return ConfigurationError.handleValidationException(e);
        }
    }

    private <C> CheckedFunction0<C> emptyConstructor(Class<C> clazz) {
        Constructor constructor = Stream.of(clazz.getConstructors(), clazz.getDeclaredConstructors()).flatMap(Arrays::stream).filter(c -> c.getParameterCount() == 0).peek(c -> c.setAccessible(true)).findFirst().get();
        return () -> constructor.newInstance(new Object[0]);
    }

    private File getFile(String key) {
        return new File(this.folder, key + this.extension);
    }

    private void validateConfigClass(Class<?> clazz) {
        this.validateAnnotation(clazz);
        this.validateEmptyConstructor(clazz);
    }

    private void validateAnnotation(Class<?> clazz) {
        this.validate(Arrays.stream(clazz.getAnnotations()).anyMatch(a -> a instanceof ConfigSerializable), "Your %s class doesn't have a %s annotation", clazz.getName(), ConfigSerializable.class.getName());
    }

    private void validateEmptyConstructor(Class<?> clazz) {
        this.validate(Stream.of(clazz.getConstructors(), clazz.getDeclaredConstructors()).flatMap(Arrays::stream).anyMatch(c -> c.getParameterCount() == 0), "Your %s class doesn't have an empty constructor", clazz.getName());
    }

    private void validate(Boolean validationCondition, String errorMessage, Object ... args) {
        if (validationCondition.booleanValue()) {
            return;
        }
        throw new IllegalStateException(String.format(errorMessage, args));
    }

    @Generated
    public ConfigLoader(File folder, String extension, IConfigLoaderConfigurator configurator) {
        this.folder = folder;
        this.extension = extension;
        this.configurator = configurator;
    }

    @Generated
    public File getFolder() {
        return this.folder;
    }

    public class ContextLoader<C> {
        private final Class<C> clazz;
        private final String key;

        public Validation<ConfigurationError, C> load() {
            return ConfigLoader.this.load(this.clazz, this.key);
        }

        public Validation<ConfigurationError, C> loadOrDefault(C defaultConfig) {
            return ConfigLoader.this.loadOrDefault(this.clazz, this.key, defaultConfig);
        }

        public Validation<ConfigurationError, C> loadOrDefault() {
            return ConfigLoader.this.loadOrDefault(this.clazz, this.key);
        }

        public Validation<ConfigurationError, Void> save(C config) {
            return ConfigLoader.this.save(this.clazz, this.key, config);
        }

        public Validation<ConfigurationError, Void> saveDefault() {
            return ConfigLoader.this.saveDefault(this.clazz, this.key);
        }

        @Generated
        public ContextLoader(Class<C> clazz, String key) {
            this.clazz = clazz;
            this.key = key;
        }
    }
}

