/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.commands.argument;

import java.util.List;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.parsers.PlayerArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;

public class CustomPlayerArgument<C>
extends CommandArgument<C, Player> {
    private CustomPlayerArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @NonNull ArgumentParser<C, Player> parser, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, parser, defaultValue, Player.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> Builder<C> newBuilder(@NonNull String name) {
        return CustomPlayerArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Player> of(@NonNull String name) {
        return PlayerArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Player> optional(@NonNull String name) {
        return PlayerArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Player> optional(@NonNull String name, @NonNull String defaultPlayer) {
        return PlayerArgument.builder(name).asOptionalWithDefault(defaultPlayer).build();
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Player> {
        private Builder(@NonNull String name) {
            super(Player.class, name);
        }

        public @NonNull CustomPlayerArgument<C> build() {
            return new CustomPlayerArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getParser(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

