/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples;

import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples.Tuple;

@API(status=API.Status.STABLE)
public class Pair<U, V>
implements Tuple {
    private final U first;
    private final V second;

    protected Pair(U first, V second) {
        this.first = first;
        this.second = second;
    }

    public static <U, V> @NonNull Pair<U, V> of(U first, V second) {
        return new Pair<U, V>(first, second);
    }

    public final U getFirst() {
        return this.first;
    }

    public final V getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.getFirst(), pair.getFirst()) && Objects.equals(this.getSecond(), pair.getSecond());
    }

    public final int hashCode() {
        return Objects.hash(this.getFirst(), this.getSecond());
    }

    public final String toString() {
        return String.format("(%s, %s)", this.first, this.second);
    }

    @Override
    public final int getSize() {
        return 2;
    }

    @Override
    public final @NonNull Object @NonNull [] toArray() {
        Object[] array = new Object[]{this.first, this.second};
        return array;
    }
}

