/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.api;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemGenerator {
    private static SimpleItemGenerator instance = null;
    private static final CompletableFuture<SimpleItemGenerator> LOAD_FUTURE = new CompletableFuture();

    protected SimpleItemGenerator() {
        SimpleItemGenerator.init(this);
    }

    public abstract Optional<ItemStack> bakeItem(String var1, @Nullable Player var2);

    public abstract boolean hasKey(String var1);

    public abstract Optional<String> getCustomItemKey(ItemStack var1);

    public boolean isCustomItem(ItemStack item) {
        return this.getCustomItemKey(item).isPresent();
    }

    public abstract boolean updateItem(ItemStack var1, @Nullable Player var2);

    public static SimpleItemGenerator get() {
        SimpleItemGenerator.ensureInitialized();
        return instance;
    }

    public static boolean isLoaded() {
        return instance != null;
    }

    public static CompletableFuture<SimpleItemGenerator> loadFuture() {
        return LOAD_FUTURE.thenApply(s -> s);
    }

    public static void onInit(Consumer<SimpleItemGenerator> callback) {
        ((CompletableFuture)SimpleItemGenerator.loadFuture().thenAccept((Consumer)callback)).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    private static void ensureInitialized() {
        if (instance == null) {
            throw new IllegalStateException("SimpleItemGenerator not initialized!");
        }
    }

    private static void ensureNotInitialized() {
        if (instance != null) {
            throw new IllegalStateException("SimpleItemGenerator is already initialized!");
        }
    }

    private static void init(SimpleItemGenerator api) {
        SimpleItemGenerator.ensureNotInitialized();
        instance = api;
        LOAD_FUTURE.complete(api);
    }
}

