/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.arcaniax.hdb.api.DatabaseLoadEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.CompoundBinaryTag;
import ua.valeriishymchuk.simpleitemgenerator.api.SimpleItemGenerator;
import ua.valeriishymchuk.simpleitemgenerator.api.event.SimpleItemGeneratorLoadEvent;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.IntegerArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.bukkit.BukkitCommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.ArgumentParseException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.InvalidSyntaxException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.exceptions.NoPermissionException;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.execution.CommandExecutionCoordinator;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.minecraft.extras.MinecraftExceptionHandler;
import ua.valeriishymchuk.simpleitemgenerator.common.commands.CommandException;
import ua.valeriishymchuk.simpleitemgenerator.common.config.ConfigLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.builder.ConfigLoaderConfigurationBuilder;
import ua.valeriishymchuk.simpleitemgenerator.common.config.serializer.nbt.v2.CompoundBinaryTagTypeSerializer;
import ua.valeriishymchuk.simpleitemgenerator.common.error.ErrorVisitor;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.metrics.MetricsHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.scheduler.BukkitTaskScheduler;
import ua.valeriishymchuk.simpleitemgenerator.common.support.HeadDatabaseSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.tick.TickTimer;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.controller.CommandsController;
import ua.valeriishymchuk.simpleitemgenerator.controller.EventsController;
import ua.valeriishymchuk.simpleitemgenerator.controller.TickController;
import ua.valeriishymchuk.simpleitemgenerator.io.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.settings.PacketEventsSettings;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.ConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.CooldownRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.ItemRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.UpdateRepository;
import ua.valeriishymchuk.simpleitemgenerator.service.InfoService;
import ua.valeriishymchuk.simpleitemgenerator.service.ItemService;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.yaml.NodeStyle;

public final class SimpleItemGeneratorPlugin
extends JavaPlugin {
    public IConfigRepository configRepository;
    private CommandManager<CommandSender> commandManager;
    private BukkitTaskScheduler taskScheduler = new BukkitTaskScheduler((Plugin)this);
    private ConfigLoader configLoader;
    private ConfigLoader itemsConfigLoader;
    private ItemService itemService;
    private InfoService infoService;
    public ItemRepository itemRepository;
    private CooldownRepository cooldownRepository = null;
    private boolean isHDBLoaded = false;

    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this, new PacketEventsSettings().checkForUpdates(false)));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        if (!this.isHDBLoaded) {
            PacketEvents.getAPI().init();
            if (!this.checkFor1132()) {
                return;
            }
            this.commandManager = this.setupCommandManager();
            this.configLoader = this.configLoader();
            File itemsFolder = new File(this.getDataFolder(), "items");
            itemsFolder.mkdirs();
            this.itemsConfigLoader = this.configLoader(itemsFolder);
            ErrorVisitor errorVisitor = new ErrorVisitor(this.getLogger(), message -> KyoriHelper.sendMessage((CommandSender)Bukkit.getConsoleSender(), message));
            this.configRepository = new ConfigRepository(this.configLoader, errorVisitor);
            this.itemRepository = new ItemRepository(this.configRepository, this.itemsConfigLoader, errorVisitor);
            UpdateRepository updateRepository = new UpdateRepository();
            this.cooldownRepository = new CooldownRepository(this.cooldownLoader(), errorVisitor);
            SemanticVersion currentVersion = SemanticVersion.parse(this.getDescription().getVersion());
            this.infoService = new InfoService(updateRepository, this.configRepository, currentVersion);
            this.itemService = new ItemService(this.configRepository, this.itemRepository, this.cooldownRepository, this.infoService);
            new CommandsController(this.itemService, this.infoService).setupCommands(this.commandManager);
        }
        if (!this.isHDBLoaded && HeadDatabaseSupport.isPluginEnabled()) {
            this.getLogger().info("Hooked into HeadDatabase. Waiting for database...");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                private void onDatabaseLoad(DatabaseLoadEvent event) {
                    SimpleItemGeneratorPlugin.this.getLogger().info("HeadDatabase is loaded fully. Enabling plugin...");
                    HeadDatabaseSupport.init();
                    SimpleItemGeneratorPlugin.this.isHDBLoaded = true;
                    SimpleItemGeneratorPlugin.this.onEnable();
                }
            }, (Plugin)this);
            return;
        }
        this.taskScheduler.runTask(() -> {
            Stream<Boolean> repositoryLoadStatus;
            boolean shouldCreateExample;
            boolean bl = shouldCreateExample = !this.configRepository.doesMainConfigExist() && this.itemRepository.hasFolder() && this.itemRepository.getItemKeys().isEmpty();
            if (shouldCreateExample) {
                this.getLogger().info("Can't find items folder, creating one...");
                this.itemRepository.createExample();
            }
            if (!(repositoryLoadStatus = Stream.of(this.cooldownRepository.reload(), this.configRepository.reload(), this.itemRepository.reloadItems())).allMatch(b -> b)) {
                this.getLogger().severe("Failed to load config. Shutting down...");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            TickTimer tickerTime = new TickTimer(this.taskScheduler);
            tickerTime.start();
            Bukkit.getPluginManager().registerEvents((Listener)new EventsController(this.itemService, this.infoService, tickerTime, this.taskScheduler), (Plugin)this);
            new TickController(this.itemService, this.infoService, this.taskScheduler, tickerTime).start();
            new API();
            Bukkit.getPluginManager().callEvent((Event)new SimpleItemGeneratorLoadEvent());
            MetricsHelper.init(this);
            MetricsHelper.initTotalItemsChart(() -> this.itemRepository.getItemKeys().size());
            MetricsHelper.initPluginActivityChart(() -> this.infoService.isUsedActively());
        });
    }

    private boolean checkFor1132() {
        if (SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 13) && !SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 14)) {
            this.getLogger().severe("SimpleItemGenerator is not supported for 1.13-1.13.2. Shutting down...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    public void onDisable() {
        if (this.cooldownRepository != null) {
            this.cooldownRepository.save();
        }
        MetricsHelper.shutdown();
        PacketEvents.getAPI().terminate();
    }

    private ConfigLoader configLoader() {
        return this.configLoader(this.getDataFolder());
    }

    private ConfigLoader configLoader(File folder) {
        return new ConfigLoader(folder, ".yml", ConfigLoaderConfigurationBuilder.yaml().peekBuilder(b -> b.indent(2).nodeStyle(NodeStyle.BLOCK)).defaultOptions(opts -> opts.serializers(b -> b.register(CompoundBinaryTag.class, new CompoundBinaryTagTypeSerializer()))).build());
    }

    private ConfigLoader cooldownLoader() {
        return new ConfigLoader(new File(this.getDataFolder(), "cooldowns"), ".yml", ConfigLoaderConfigurationBuilder.yaml().peekBuilder(b -> b.indent(2).nodeStyle(NodeStyle.BLOCK)).defaultOptions(opts -> opts.serializers(b -> b.register(CompoundBinaryTag.class, new CompoundBinaryTagTypeSerializer()))).build());
    }

    private CommandManager<CommandSender> setupCommandManager() {
        BukkitCommandManager<CommandSender> manager = new BukkitCommandManager<CommandSender>((Plugin)this, CommandExecutionCoordinator.simpleCoordinator(), Function.identity(), Function.identity());
        new MinecraftExceptionHandler().withDefaultHandlers().withHandler(MinecraftExceptionHandler.ExceptionType.NO_PERMISSION, (sender, exception) -> this.configRepository.getLang().getNoPermission().replaceText("%permission%", ((NoPermissionException)exception).getMissingPermission()).bake()).withHandler(MinecraftExceptionHandler.ExceptionType.INVALID_SYNTAX, (sender, exception) -> this.configRepository.getLang().getInvalidCommandSyntax().replaceText("%usage%", ((InvalidSyntaxException)exception).getCorrectSyntax()).bake()).withHandler(MinecraftExceptionHandler.ExceptionType.ARGUMENT_PARSING, (sender, exception) -> {
            ArgumentParseException argumentParseException = (ArgumentParseException)exception;
            if (argumentParseException.getCause() instanceof CommandException) {
                return KyoriHelper.convert(((CommandException)argumentParseException.getCause()).getErrorMessage());
            }
            if (argumentParseException.getCause() instanceof IntegerArgument.IntegerParseException) {
                IntegerArgument.IntegerParseException integerParseException = (IntegerArgument.IntegerParseException)argumentParseException.getCause();
                return this.configRepository.getLang().getInvalidIntegerError().replaceText("%number%", integerParseException.getInput()).replaceText("%min%", integerParseException.getMin()).replaceText("%max%", integerParseException.getMax()).bake();
            }
            this.getLogger().log(Level.SEVERE, "An unknown argument error occurred", argumentParseException.getCause());
            return this.configRepository.getLang().getUnknownArgumentError().replaceText("%error%", argumentParseException.getCause()).bake();
        }).apply(manager, s -> s);
        return manager;
    }

    private class API
    extends SimpleItemGenerator {
        private API() {
        }

        @Override
        public Optional<ItemStack> bakeItem(String key, @Nullable Player player) {
            Objects.requireNonNull(key);
            SimpleItemGeneratorPlugin.this.infoService.updatePluginActivity();
            return SimpleItemGeneratorPlugin.this.itemRepository.bakeItem(key, player).toJavaOptional();
        }

        @Override
        public boolean hasKey(String key) {
            Objects.requireNonNull(key);
            SimpleItemGeneratorPlugin.this.infoService.updatePluginActivity();
            return SimpleItemGeneratorPlugin.this.itemRepository.getItemKeys().contains(key);
        }

        @Override
        public Optional<String> getCustomItemKey(ItemStack item) {
            Objects.requireNonNull(item);
            SimpleItemGeneratorPlugin.this.infoService.updatePluginActivity();
            return NBTCustomItem.getCustomItemId(item).toJavaOptional();
        }

        @Override
        public boolean updateItem(ItemStack item, @Nullable Player player) {
            Objects.requireNonNull(item);
            if (!this.isCustomItem(item)) {
                return false;
            }
            SimpleItemGeneratorPlugin.this.infoService.updatePluginActivity();
            SimpleItemGeneratorPlugin.this.itemRepository.updateItem(item, player);
            return true;
        }
    }
}

