/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.service;

import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.api.event.SimpleItemGeneratorReloadEvent;
import ua.valeriishymchuk.simpleitemgenerator.common.component.RawComponent;
import ua.valeriishymchuk.simpleitemgenerator.common.cooldown.CooldownType;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.placeholders.PlaceholdersHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.IRayTraceResult;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceBlockResult;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceEntityResult;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickAt;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickButton;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.PredicateInput;
import ua.valeriishymchuk.simpleitemgenerator.domain.CooldownQueryDomain;
import ua.valeriishymchuk.simpleitemgenerator.dto.CommandExecutionDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.GiveItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageBlockDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageEntityDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageGeneralDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.SlotChangeDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.WithdrawItemDTO;
import ua.valeriishymchuk.simpleitemgenerator.entity.CustomItemEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.LangEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.MainConfigEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.CooldownRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.impl.ItemRepository;
import ua.valeriishymchuk.simpleitemgenerator.service.InfoService;

public class ItemService {
    private final IConfigRepository configRepository;
    private final ItemRepository itemRepository;
    private final CooldownRepository cooldownRepository;
    private final InfoService infoService;

    private MainConfigEntity config() {
        return this.configRepository.getConfig();
    }

    private LangEntity lang() {
        return this.configRepository.getLang();
    }

    private int getTotalItems(ItemStack item, Player player) {
        if (item == null || item.getType().name().endsWith("AIR")) {
            return 0;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return 0;
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            return 0;
        }
        return Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).filter(i -> NBTCustomItem.getCustomItemId(i).map(s -> s.equals(customItemId)).getOrElse(false)).mapToInt(ItemStack::getAmount).sum();
    }

    public ItemUsageResultDTO useItem(ItemUsageBlockDTO itemUsageBlockDTO, PipelineDebug pipelineDebug) {
        boolean isBlock = itemUsageBlockDTO.getClickedBlock().isDefined();
        boolean isLeftClick = itemUsageBlockDTO.getAction() == Action.LEFT_CLICK_AIR || itemUsageBlockDTO.getAction() == Action.LEFT_CLICK_BLOCK;
        ItemUsageResultDTO nop = new ItemUsageResultDTO(null, Collections.emptyList(), false, UsageEntity.Consume.NONE, pipelineDebug);
        if (itemUsageBlockDTO.getAction() == Action.PHYSICAL) {
            return nop;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (isBlock) {
            placeholders.putAll(PlaceholdersHelper.placeholdersFor(itemUsageBlockDTO.getClickedBlock().get(), itemUsageBlockDTO.getClickedFace().get()));
        }
        PredicateInput predicateInput = new PredicateInput(itemUsageBlockDTO.getPlayer(), isBlock ? itemUsageBlockDTO.getClickedBlock().get().getLocation() : null, isLeftClick ? ClickButton.LEFT : ClickButton.RIGHT, isBlock ? ClickAt.BLOCK : ClickAt.AIR, new PredicateInput.Amount(this.getTotalItems(itemUsageBlockDTO.getItem(), itemUsageBlockDTO.getPlayer()), itemUsageBlockDTO.getItem() == null ? 0 : itemUsageBlockDTO.getItem().getAmount()), itemUsageBlockDTO.getCurrentTick(), itemUsageBlockDTO.getSlot(), PredicateInput.Trigger.WORLD_CLICK);
        return this.useItem0(itemUsageBlockDTO.getPlayer(), itemUsageBlockDTO.getItem(), predicateInput, placeholders, pipelineDebug);
    }

    public ItemUsageResultDTO dropItem(ItemUsageGeneralDTO itemUsageGeneralDTO, PipelineDebug pipelineDebug) {
        Player player = itemUsageGeneralDTO.getPlayer();
        ItemStack item = itemUsageGeneralDTO.getItemStack();
        RaytraceResultDomain raytraceResult = this.raytrace(itemUsageGeneralDTO.getPlayer());
        ItemUsageResultDTO usageResult = this.useItem0(player, item, new PredicateInput(player, raytraceResult.useLoc, ClickButton.DROP, raytraceResult.clickAt, new PredicateInput.Amount(this.getTotalItems(item, player), item == null ? 0 : item.getAmount()), itemUsageGeneralDTO.getCurrentTick(), itemUsageGeneralDTO.getSlot(), PredicateInput.Trigger.DROP_ITEM), raytraceResult.placeholders, pipelineDebug);
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (usageResult.isShouldCancel() && player.getGameMode() == GameMode.CREATIVE && customItemId != null) {
            usageResult = usageResult.withMessage(this.lang().getCreativeDrop().replaceText("%key%", customItemId).bakeInternal());
        }
        return usageResult;
    }

    private ItemUsageResultDTO mergeUsages(ItemUsageResultDTO acc, ItemUsageResultDTO usage, boolean isPlainItem, PipelineDebug pipelineDebug) {
        UsageEntity.Consume consume;
        boolean anyNone;
        boolean isAccNone = acc.getConsume().isNone();
        boolean bl = anyNone = acc.getConsume().isNone() || usage.getConsume().isNone();
        if (anyNone) {
            consume = isAccNone ? usage.getConsume() : acc.getConsume();
        } else {
            int eIndex;
            List<UsageEntity.ConsumeType> typesHierarchy;
            int accIndex;
            boolean isBothAmount;
            boolean bl2 = isBothAmount = acc.getConsume().isAmount() && usage.getConsume().isAmount();
            consume = isBothAmount ? new UsageEntity.Consume(UsageEntity.ConsumeType.AMOUNT, acc.getConsume().getAmount() + usage.getConsume().getAmount()) : (acc.getConsume().getConsumeType() == usage.getConsume().getConsumeType() ? acc.getConsume() : ((accIndex = (typesHierarchy = Arrays.asList(UsageEntity.ConsumeType.STACK, UsageEntity.ConsumeType.ALL)).indexOf((Object)acc.getConsume().getConsumeType())) > (eIndex = typesHierarchy.indexOf((Object)usage.getConsume().getConsumeType())) ? acc.getConsume() : usage.getConsume()));
        }
        return new ItemUsageResultDTO(null, Stream.of(acc, usage).map(ItemUsageResultDTO::getCommands).flatMap(Collection::stream).collect(Collectors.toList()), (acc.isShouldCancel() || usage.isShouldCancel()) && !isPlainItem, consume, pipelineDebug);
    }

    private CooldownQueryDomain queryPerItem(ItemStack item, UsageEntity usage, int id) {
        NBTCustomItem.Cooldown cooldown = NBTCustomItem.queryCooldown(item, usage.getCooldownMillis(), usage.getCooldownFreezeTimeMillis(), id);
        boolean isOnCooldown = cooldown.isDefault();
        boolean isFreeze = cooldown.isFrozen();
        Long remainingCooldownTime = isOnCooldown ? Long.valueOf(cooldown.getRemainingMillis()) : null;
        return new CooldownQueryDomain(isOnCooldown, isFreeze, remainingCooldownTime, null);
    }

    private CooldownQueryDomain queryGlobal(String customItemId, UsageEntity usage, int id) {
        Long remainingCooldownTime;
        boolean isFreeze;
        Option<Long> lastUsage = this.cooldownRepository.lastUsageGlobal(customItemId, id, false);
        boolean isOnCooldown = lastUsage.map(l -> l + usage.getCooldownMillis() > System.currentTimeMillis()).getOrElse(false);
        if (isOnCooldown) {
            isFreeze = this.cooldownRepository.lastUsageGlobal(customItemId, id, true).map(l -> l + usage.getCooldownFreezeTimeMillis() > System.currentTimeMillis()).getOrElse(false);
            if (!isFreeze) {
                this.cooldownRepository.updateGlobal(customItemId, id, true);
            }
            remainingCooldownTime = lastUsage.getOrElse(0L) + usage.getCooldownMillis() - System.currentTimeMillis();
        } else {
            remainingCooldownTime = null;
            isFreeze = false;
            this.cooldownRepository.updateGlobal(customItemId, id, false);
            this.cooldownRepository.updateGlobal(customItemId, id, true);
        }
        return new CooldownQueryDomain(isOnCooldown, isFreeze, remainingCooldownTime, (Long)lastUsage.getOrNull());
    }

    private CooldownQueryDomain queryPerPlayer(String customItemId, Player player, UsageEntity usage, int id) {
        Long remainingCooldownTime;
        boolean isFreeze;
        Option<Long> lastUsage = this.cooldownRepository.lastUsagePerPlayer(customItemId, player.getUniqueId(), id, false);
        boolean isOnCooldown = lastUsage.map(l -> l + usage.getCooldownMillis() > System.currentTimeMillis()).getOrElse(false);
        if (isOnCooldown) {
            isFreeze = this.cooldownRepository.lastUsagePerPlayer(customItemId, player.getUniqueId(), id, true).map(l -> l + usage.getCooldownFreezeTimeMillis() > System.currentTimeMillis()).getOrElse(false);
            if (!isFreeze) {
                this.cooldownRepository.updatePerPlayer(customItemId, player.getUniqueId(), id, true);
            }
            remainingCooldownTime = lastUsage.getOrElse(0L) + usage.getCooldownMillis() - System.currentTimeMillis();
        } else {
            isFreeze = false;
            this.cooldownRepository.updatePerPlayer(customItemId, player.getUniqueId(), id, false);
            this.cooldownRepository.updatePerPlayer(customItemId, player.getUniqueId(), id, true);
            remainingCooldownTime = null;
        }
        return new CooldownQueryDomain(isOnCooldown, isFreeze, remainingCooldownTime, (Long)lastUsage.getOrNull());
    }

    private CooldownQueryDomain getAndUpdateCooldown(ItemStack item, UsageEntity usage, Player player) {
        String customItemId = NBTCustomItem.getCustomItemId(item).get();
        CustomItemEntity customItem = this.itemRepository.getItem(customItemId).get();
        int id = customItem.getUsages().indexOf(usage);
        CooldownType cooldownType = usage.getCooldownType();
        return switch (cooldownType) {
            default -> throw new IncompatibleClassChangeError();
            case CooldownType.PER_ITEM -> this.queryPerItem(item, usage, id);
            case CooldownType.GLOBAL -> this.queryGlobal(customItemId, usage, id);
            case CooldownType.PER_PLAYER -> this.queryPerPlayer(customItemId, player, usage, id);
        };
    }

    private ItemUsageResultDTO applyCooldown(UsageEntity usage, ItemStack item, Player player, PredicateInput predicateInput, Map<String, String> placeholders, PipelineDebug pipelineDebug) {
        boolean isInventoryClick;
        PipelineDebug subPipeline = pipelineDebug.append("Cooldown", new PipelineDebug.Tag[0]);
        String customItemId = NBTCustomItem.getCustomItemId(item).get();
        CustomItemEntity customItem = this.itemRepository.getItem(customItemId).get();
        CooldownQueryDomain cooldownQueryDomain = this.getAndUpdateCooldown(item, usage, player);
        int id = customItem.getUsages().indexOf(usage);
        if (cooldownQueryDomain.isFreeze()) {
            return ItemUsageResultDTO.CANCELLED.withPipelineDebug(subPipeline.appendAndReturnSelf("Cancelled by freeze " + id, new PipelineDebug.Tag[0]));
        }
        if (cooldownQueryDomain.isOnCooldown()) {
            return usage.prepareCooldownCommands(cooldownQueryDomain, player, placeholders, subPipeline);
        }
        boolean shouldCancel = false;
        boolean bl = isInventoryClick = predicateInput.getTrigger() == PredicateInput.Trigger.INVENTORY_CLICK;
        if (!customItem.isPlainItem() && !isInventoryClick) {
            subPipeline.append("Not plain item and not inventory click. Setting it to " + usage.isCancel(), new PipelineDebug.Tag[0]);
            shouldCancel = usage.isCancel();
        } else if (usage.isCancel()) {
            subPipeline.append("Usage is cancelled", new PipelineDebug.Tag[0]);
            shouldCancel = true;
        }
        subPipeline.appendAndReturnSelf("Cooldown, is cancelled " + shouldCancel + " id: " + id, new PipelineDebug.Tag[0]);
        return ItemUsageResultDTO.CANCELLED.withCommands(usage.prepareCommands(player, placeholders)).withShouldCancel(shouldCancel).withConsume(usage.getConsume()).withPipelineDebug(pipelineDebug);
    }

    private ItemUsageResultDTO useItem0(Player player, ItemStack item, PredicateInput predicateInput, Map<String, String> placeholders, PipelineDebug pipelineDebug) {
        ItemUsageResultDTO nop = ItemUsageResultDTO.EMPTY.withPipelineDebug(pipelineDebug);
        if (!NBTCustomItem.hasCustomItemId(item)) {
            return nop;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return nop;
        }
        PipelineDebug prependedDebug = PipelineDebug.prepend(pipelineDebug, customItemId, new PipelineDebug.Tag[0]);
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            prependedDebug.append("Can't find custom item in config", new PipelineDebug.Tag[0]);
            boolean isItemUsage = predicateInput.getTrigger() != PredicateInput.Trigger.TICK && predicateInput.getTrigger() != PredicateInput.Trigger.INVENTORY_CLICK;
            boolean shouldSendMessage = isItemUsage && this.config().isSendInvalidItemMessage();
            Component message = this.lang().getInvalidItem().replaceText("%key%", customItemId).bakeInternal();
            return ItemUsageResultDTO.EMPTY.withMessage(shouldSendMessage ? message : null).withShouldCancel(true).withPipelineDebug(prependedDebug);
        }
        this.infoService.updatePluginActivity();
        List<UsageEntity> usages = customItem.getUsages().stream().filter(usageFilter -> {
            UsageEntity.AcceptResult result = usageFilter.accepts(predicateInput);
            prependedDebug.append("Usage result (" + result.isAccepted() + ") - " + customItem.getUsages().indexOf(usageFilter), new PipelineDebug.Tag[0]).appendAllAndReturnSelf(result.getPipelineDebugs());
            return result.isAccepted();
        }).toList();
        return usages.stream().map(usage -> this.applyCooldown((UsageEntity)usage, item, player, predicateInput, placeholders, prependedDebug)).reduce((acc, e) -> this.mergeUsages((ItemUsageResultDTO)acc, (ItemUsageResultDTO)e, customItem.isPlainItem(), prependedDebug)).orElseGet(() -> ItemUsageResultDTO.EMPTY.withShouldCancel(!customItem.isPlainItem()).withPipelineDebug(prependedDebug.appendAndReturnSelf("Usages weren't found", new PipelineDebug.Tag[0])));
    }

    private CommandExecutionDTO prepare(UsageEntity.Command command, Player player, Map<String, String> placeholders) {
        String rawCommand = PlaceholdersHelper.replacePlayer(command.getCommand(), player);
        AtomicReference<String> strAtomic = new AtomicReference<String>(rawCommand);
        placeholders.forEach((placeholder, value) -> strAtomic.set(((String)strAtomic.get()).replace((CharSequence)placeholder, (CharSequence)value)));
        return new CommandExecutionDTO(command.isExecuteAsConsole(), strAtomic.get());
    }

    public ItemUsageResultDTO useItemAt(ItemUsageEntityDTO itemUsageEntityDTO, PipelineDebug pipelineDebug) {
        Entity clicked = itemUsageEntityDTO.getClicked();
        ItemStack item = itemUsageEntityDTO.getItem();
        Player player = itemUsageEntityDTO.getPlayer();
        boolean isRightClicked = itemUsageEntityDTO.isRightClicked();
        boolean isPlayer = clicked instanceof Player;
        PredicateInput clickType = new PredicateInput(player, clicked.getLocation(), isRightClicked ? ClickButton.RIGHT : ClickButton.LEFT, isPlayer ? ClickAt.PLAYER : ClickAt.ENTITY, new PredicateInput.Amount(this.getTotalItems(item, player), item == null ? 0 : item.getAmount()), itemUsageEntityDTO.getCurrentTick(), itemUsageEntityDTO.getSlot(), PredicateInput.Trigger.ENTITY_CLICK);
        Map<String, String> placeholders = isPlayer ? PlaceholdersHelper.placeholdersFor((Player)clicked) : PlaceholdersHelper.placeholdersFor(clicked);
        return this.useItem0(player, item, clickType, placeholders, pipelineDebug);
    }

    private RaytraceResultDomain raytrace(Player player) {
        ClickAt clickAt;
        int playerReach = 3;
        IRayTraceResult result = RayTraceHelper.rayTrace((LivingEntity)player, Arrays.stream(Material.values()).filter(material -> material.isBlock() && (material.name().endsWith("AIR") || material.name().endsWith("WATER") || material.name().endsWith("LAVA"))).collect(Collectors.toSet()), playerReach, playerReach + 1);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Location useLoc = null;
        if (result.hitBlock()) {
            RayTraceBlockResult castesResult = (RayTraceBlockResult)result;
            clickAt = ClickAt.BLOCK;
            useLoc = castesResult.getHitBlock().getLocation();
            placeholders.putAll(PlaceholdersHelper.placeholdersFor(castesResult.getHitBlock(), castesResult.getSide()));
        } else if (result.hitEntity()) {
            RayTraceEntityResult castesResult = (RayTraceEntityResult)result;
            useLoc = castesResult.getEntity().getLocation();
            if (castesResult.getEntity() instanceof Player) {
                placeholders.putAll(PlaceholdersHelper.placeholdersFor((Player)castesResult.getEntity()));
                clickAt = ClickAt.PLAYER;
            } else {
                placeholders.putAll(PlaceholdersHelper.placeholdersFor(castesResult.getEntity()));
                clickAt = ClickAt.ENTITY;
            }
        } else {
            clickAt = ClickAt.AIR;
        }
        return new RaytraceResultDomain(clickAt, useLoc, placeholders);
    }

    public ItemUsageResultDTO tickItem(ItemUsageGeneralDTO itemUsageGeneralDTO, PipelineDebug pipelineDebug) {
        boolean shouldPrint = itemUsageGeneralDTO.getCurrentTick() % 20L == 0L;
        Player player = itemUsageGeneralDTO.getPlayer();
        ItemStack item = itemUsageGeneralDTO.getItemStack();
        ItemUsageResultDTO nop = ItemUsageResultDTO.EMPTY.withPipelineDebug(pipelineDebug);
        if (item == null || !NBTCustomItem.hasCustomItemId(item)) {
            return nop;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        PipelineDebug prependedDebug = PipelineDebug.prepend(pipelineDebug, customItemId, new PipelineDebug.Tag[0]);
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            prependedDebug.append("Can't find custom item in config[tick]", new PipelineDebug.Tag[0]);
            return ItemUsageResultDTO.EMPTY.withShouldCancel(true).withPipelineDebug(prependedDebug);
        }
        if (!customItem.hasTick()) {
            return nop;
        }
        RaytraceResultDomain raytraceResultDomain = this.raytrace(player);
        return this.useItem0(player, item, new PredicateInput(player, raytraceResultDomain.useLoc, null, raytraceResultDomain.clickAt, new PredicateInput.Amount(this.getTotalItems(item, player), item.getAmount()), itemUsageGeneralDTO.getCurrentTick(), itemUsageGeneralDTO.getSlot(), PredicateInput.Trigger.TICK), raytraceResultDomain.placeholders, pipelineDebug);
    }

    public ItemUsageResultDTO moveItem(Player player, SlotChangeDTO slotChanges, PipelineDebug pipelineDebug) {
        ItemStack item = slotChanges.getItemStack().getRealItem();
        RaytraceResultDomain raytraceResultDomain = this.raytrace(player);
        return this.useItem0(player, item, new PredicateInput(player, raytraceResultDomain.useLoc, null, raytraceResultDomain.clickAt, new PredicateInput.Amount(this.getTotalItems(item, player), item == null ? 0 : item.getAmount()), slotChanges.getTick(), slotChanges.getSlot(), PredicateInput.Trigger.INVENTORY_CLICK), raytraceResultDomain.placeholders, pipelineDebug);
    }

    public boolean canBePutInInventory(ItemStack item) {
        if (item == null || !NBTCustomItem.hasCustomItemId(item)) {
            return true;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return true;
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            return true;
        }
        return customItem.canBePutInInventory();
    }

    public boolean canBeMoved(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().name().endsWith("AIR")) {
            return true;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(itemStack).getOrNull();
        if (customItemId == null) {
            return true;
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            return true;
        }
        return customItem.canMove();
    }

    public boolean shouldRemoveOnDeath(ItemStack item) {
        if (item == null || item.getType().name().endsWith("AIR")) {
            return false;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return false;
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            return false;
        }
        return customItem.removeOnDeath();
    }

    public boolean areNotEqual(ItemStack item, ItemStack item2) {
        if (item == null || item2 == null) {
            return true;
        }
        String customItemId1 = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        String customItemId2 = (String)NBTCustomItem.getCustomItemId(item2).getOrNull();
        if (customItemId1 == null || customItemId2 == null) {
            return true;
        }
        return !Objects.equals(customItemId1, customItemId2);
    }

    public Option<ItemStack> updateItem(ItemStack itemStack, @Nullable Player player) {
        boolean itemHasChanged = this.itemRepository.updateItem(itemStack, player);
        if (itemHasChanged) {
            return Option.some(itemStack);
        }
        return Option.none();
    }

    public boolean canBeUsedInCraft(ItemStack item) {
        if (item == null || !NBTCustomItem.hasCustomItemId(item)) {
            return true;
        }
        String customItemId = (String)NBTCustomItem.getCustomItemId(item).getOrNull();
        if (customItemId == null) {
            return true;
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(customItemId).getOrNull();
        if (customItem == null) {
            return true;
        }
        return customItem.isIngredient();
    }

    public GiveItemDTO giveItem(String key, @Nullable Player player) {
        return this.giveItem(key, player, null);
    }

    public GiveItemDTO giveItem(String key, @Nullable Player player, Integer slot) {
        if (player == null) {
            return new GiveItemDTO(this.lang().getSenderNotPlayer().bakeInternal(), this.lang().getDroppedItem().bakeInternal(), null);
        }
        if (slot != null && player.getInventory().getSize() <= slot) {
            return new GiveItemDTO(this.lang().getSlotNotExist().replaceText("%slot%", "" + slot).bakeInternal(), this.lang().getDroppedItem().bakeInternal(), null);
        }
        ItemStack itemStack = (ItemStack)this.itemRepository.bakeItem(key, player).getOrNull();
        RawComponent message = itemStack == null ? this.lang().getItemDoesntExist() : this.lang().getGiveItemSuccessfully();
        message = message.replaceText("%player%", player.getName()).replaceText("%key%", key);
        return new GiveItemDTO(message.bakeInternal(), this.lang().getDroppedItem().bakeInternal(), itemStack);
    }

    public WithdrawItemDTO withdrawItem(String key, @Nullable Player player, int amount) {
        boolean success;
        if (player == null) {
            return new WithdrawItemDTO(this.lang().getSenderNotPlayer().bakeInternal(), null, false);
        }
        CustomItemEntity customItem = (CustomItemEntity)this.itemRepository.getItem(key).getOrNull();
        if (customItem == null) {
            return new WithdrawItemDTO(this.lang().getItemDoesntExist().replaceText("%key%", key).bakeInternal(), null, false);
        }
        int totalItems = Arrays.stream(player.getInventory().getContents()).filter(item -> NBTCustomItem.getCustomItemId(item).map(s -> s.equals(key)).getOrElse(false)).filter(Objects::nonNull).mapToInt(ItemStack::getAmount).sum();
        ArrayList<RawComponent> messages = new ArrayList<RawComponent>();
        if (totalItems < amount) {
            messages.add(this.lang().getNotEnoughItemsSender());
            messages.add(this.lang().getNotEnoughItemsReceiver());
            success = false;
        } else {
            messages.add(this.lang().getSuccessfullyWithdrewSender());
            messages.add(this.lang().getSuccessfullyWithdrewReceiver());
            success = true;
        }
        Component itemName = Option.of(customItem.getItemStack().getItemMeta().displayName()).map(KyoriHelper::convert).getOrElse(KyoriHelper.parseMiniMessage("<white>" + key + "</white>"));
        List<Component> finalMessages = messages.stream().map(raw -> raw.replaceText("%amount%", "" + amount).replaceText("%item%", itemName).replaceText("%player%", player.getName()).replaceText("%key%", key).bakeInternal()).toList();
        return new WithdrawItemDTO(finalMessages.get(0), finalMessages.get(1), success);
    }

    public Set<String> getItemKeys() {
        return this.itemRepository.getItemKeys();
    }

    public long getPlaceholderUpdatePeriodTicks() {
        return this.config().getPlaceholderUpdatePeriod() / 50L;
    }

    public long getItemUpdatePeriodTicks() {
        return this.config().getItemUpdatePeriod() / 50L;
    }

    public Component reload() {
        boolean result;
        boolean bl = result = this.cooldownRepository.reload() && this.configRepository.reload() && this.itemRepository.reloadItems();
        if (result) {
            Bukkit.getPluginManager().callEvent((Event)new SimpleItemGeneratorReloadEvent());
        }
        return result ? this.lang().getReloadSuccessfully().bakeInternal() : this.lang().getReloadUnsuccessfully().bakeInternal();
    }

    public Component playerNotFound(String input) {
        return this.lang().getInvalidPlayer().replaceText("%player%", input).bakeInternal();
    }

    public void cooldownAutoSave() {
        this.cooldownRepository.save();
    }

    @Generated
    public ItemService(IConfigRepository configRepository, ItemRepository itemRepository, CooldownRepository cooldownRepository, InfoService infoService) {
        this.configRepository = configRepository;
        this.itemRepository = itemRepository;
        this.cooldownRepository = cooldownRepository;
        this.infoService = infoService;
    }

    private static class RaytraceResultDomain {
        private final ClickAt clickAt;
        private final Location useLoc;
        private final Map<String, String> placeholders;

        @Generated
        public RaytraceResultDomain(ClickAt clickAt, Location useLoc, Map<String, String> placeholders) {
            this.clickAt = clickAt;
            this.useLoc = useLoc;
            this.placeholders = placeholders;
        }
    }
}

