/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.service;

import io.vavr.control.Option;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.bukkit.entity.Player;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SigFeatureTag;
import ua.valeriishymchuk.simpleitemgenerator.entity.LangEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.MainConfigEntity;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;
import ua.valeriishymchuk.simpleitemgenerator.repository.IUpdateRepository;

public class InfoService {
    private final IUpdateRepository updateRepository;
    private final IConfigRepository configRepository;
    private final SemanticVersion currentVersion;
    private long lastTimeWasUsed = 0L;

    private MainConfigEntity getConfig() {
        return this.configRepository.getConfig();
    }

    private LangEntity getLang() {
        return this.configRepository.getLang();
    }

    public void updatePluginActivity() {
        this.lastTimeWasUsed = System.currentTimeMillis();
    }

    public boolean isUsedActively() {
        return System.currentTimeMillis() - this.lastTimeWasUsed < 86400000L;
    }

    public boolean isDebug() {
        return this.getConfig().isDebug();
    }

    public boolean isDebugTick() {
        return this.getConfig().isTickDebug();
    }

    public Set<SigFeatureTag> getFeatures() {
        return this.getConfig().getFeatures();
    }

    public Option<Component> getMessage(Player player) {
        if (!player.isOp() || !this.getConfig().isSendWelcomeMessage()) {
            return Option.none();
        }
        return Option.some(this.getLang().getAdminWelcome().replaceText("%version%", this.currentVersion.toFullString()).bakeInternal());
    }

    public CompletableFuture<Option<Component>> getNewUpdateMessage(Player player) {
        if (!player.isOp() || !this.getConfig().isCheckForUpdates()) {
            return CompletableFuture.completedFuture(Option.none());
        }
        return this.updateRepository.getLatestPluginVersion().thenApply(version -> {
            if (this.currentVersion.isAtLeast((SemanticVersion)version)) {
                return Option.none();
            }
            return Option.some(this.getLang().getNewUpdateVersion().replaceText("%new_version%", version.toFullString()).replaceText("%current_version%", this.currentVersion.toFullString()).bakeInternal());
        });
    }

    public Component getUsage() {
        return this.getLang().getSigUsage().replaceText("%version%", this.currentVersion.toFullString()).bakeInternal();
    }

    @Generated
    public InfoService(IUpdateRepository updateRepository, IConfigRepository configRepository, SemanticVersion currentVersion) {
        this.updateRepository = updateRepository;
        this.configRepository = configRepository;
        this.currentVersion = currentVersion;
    }
}

