/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.repository.impl;

import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import ua.valeriishymchuk.simpleitemgenerator.common.config.ConfigLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.error.ConfigurationError;
import ua.valeriishymchuk.simpleitemgenerator.common.error.ErrorVisitor;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.entity.CooldownStorageEntity;

public class CooldownRepository {
    private final ConfigLoader configLoader;
    private CooldownStorageEntity storage;
    private final ErrorVisitor errorVisitor;

    public void save() {
        this.configLoader.save(CooldownStorageEntity.class, "cooldowns", this.storage);
    }

    public boolean reload() {
        Validation<ConfigurationError, CooldownStorageEntity> storageLoadResult = this.configLoader.loadOrSave(CooldownStorageEntity.class, "cooldowns");
        if (storageLoadResult.isInvalid()) {
            KyoriHelper.sendMessage((CommandSender)Bukkit.getConsoleSender(), "<red>[SimpleItemGenerator] Found error in cooldowns.yml:</red>");
            this.errorVisitor.visitError(storageLoadResult.getError().asConfigException());
            return false;
        }
        this.storage = storageLoadResult.get();
        return true;
    }

    public void updateGlobal(String itemKey, int hashCode, boolean isFreeze) {
        Map<String, Map<Integer, CooldownStorageEntity.ItemCooldownInfo>> storage = isFreeze ? this.storage.freeze : this.storage.cooldowns;
        CooldownStorageEntity.ItemCooldownInfo info = storage.computeIfAbsent(itemKey, k -> new HashMap()).computeIfAbsent(hashCode, k -> new CooldownStorageEntity.ItemCooldownInfo());
        info.setCooldownSince(System.currentTimeMillis());
    }

    public void updatePerPlayer(String itemKey, UUID player, int hashCode, boolean isFreeze) {
        Map<String, Map<Integer, CooldownStorageEntity.ItemCooldownInfo>> storage = isFreeze ? this.storage.freeze : this.storage.cooldowns;
        CooldownStorageEntity.ItemCooldownInfo info = storage.computeIfAbsent(itemKey, k -> new HashMap()).computeIfAbsent(hashCode, k -> new CooldownStorageEntity.ItemCooldownInfo());
        info.getPlayerCooldown().put(player, System.currentTimeMillis());
    }

    public Option<Long> lastUsageGlobal(String itemKey, int hashCode, boolean isFreeze) {
        Map<String, Map<Integer, CooldownStorageEntity.ItemCooldownInfo>> storage = isFreeze ? this.storage.freeze : this.storage.cooldowns;
        Map<Integer, CooldownStorageEntity.ItemCooldownInfo> values = storage.get(itemKey);
        if (values == null) {
            return Option.none();
        }
        CooldownStorageEntity.ItemCooldownInfo cooldowns = values.get(hashCode);
        if (cooldowns == null) {
            return Option.none();
        }
        return Option.of(cooldowns.getCooldownSince());
    }

    public Option<Long> lastUsagePerPlayer(String itemKey, UUID player, int hashCode, boolean isFreeze) {
        Map<String, Map<Integer, CooldownStorageEntity.ItemCooldownInfo>> storage = isFreeze ? this.storage.freeze : this.storage.cooldowns;
        Map<Integer, CooldownStorageEntity.ItemCooldownInfo> values = storage.get(itemKey);
        if (values == null) {
            return Option.none();
        }
        CooldownStorageEntity.ItemCooldownInfo cooldowns = values.get(hashCode);
        if (cooldowns == null) {
            return Option.none();
        }
        Long playerInfo = cooldowns.getPlayerCooldown().get(player);
        return Option.of(playerInfo);
    }

    @Generated
    public CooldownRepository(ConfigLoader configLoader, ErrorVisitor errorVisitor) {
        this.configLoader = configLoader;
        this.errorVisitor = errorVisitor;
    }
}

