/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.repository.impl;

import io.vavr.control.Validation;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import ua.valeriishymchuk.simpleitemgenerator.common.config.ConfigLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.error.ConfigurationError;
import ua.valeriishymchuk.simpleitemgenerator.common.error.ErrorVisitor;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.entity.LangEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.MainConfigEntity;
import ua.valeriishymchuk.simpleitemgenerator.repository.IConfigRepository;

public class ConfigRepository
implements IConfigRepository {
    private final ConfigLoader configLoader;
    private MainConfigEntity config = new MainConfigEntity();
    private LangEntity lang = new LangEntity();
    private final ErrorVisitor errorVisitor;

    @Override
    public MainConfigEntity getConfig() {
        return this.config;
    }

    @Override
    public boolean doesMainConfigExist() {
        return this.configLoader.exists("config");
    }

    @Override
    public LangEntity getLang() {
        return this.lang;
    }

    private void handleError(ConfigurationError error, String config) {
        config = (String)config + ".yml";
        KyoriHelper.sendMessage((CommandSender)Bukkit.getConsoleSender(), String.format("<red>[SimpleItemGenerator] Error in configuration <white>%s</white></red>", config));
        this.errorVisitor.visitError(error.asConfigException());
    }

    @Override
    public boolean reload() {
        AtomicBoolean isSuccessful = new AtomicBoolean(true);
        Validation<ConfigurationError, MainConfigEntity> configLoadResult = this.configLoader.loadOrSave(MainConfigEntity.class, "config");
        configLoadResult.peek(newConfig -> {
            this.config = newConfig;
        }).toEither().swap().peek(e -> this.handleError((ConfigurationError)e, "config")).peek(e -> isSuccessful.set(false));
        Validation<ConfigurationError, LangEntity> langLoadResult = this.configLoader.loadOrSave(LangEntity.class, "lang");
        langLoadResult.peek(newConfig -> {
            this.lang = newConfig;
        }).toEither().swap().peek(e -> this.handleError((ConfigurationError)e, "lang")).peek(e -> isSuccessful.set(false));
        return isSuccessful.get();
    }

    @Generated
    public ConfigRepository(ConfigLoader configLoader, ErrorVisitor errorVisitor) {
        this.configLoader = configLoader;
        this.errorVisitor = errorVisitor;
    }
}

