/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.io.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketSendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.ColorUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.LegacyFormat;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerTeams
extends PacketWrapper<WrapperPlayServerTeams> {
    private String teamName;
    private TeamMode teamMode;
    private Collection<String> players;
    private Optional<ScoreBoardTeamInfo> teamInfo;

    public WrapperPlayServerTeams(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerTeams(String teamName, TeamMode teamMode, @Nullable ScoreBoardTeamInfo teamInfo, String ... entities) {
        this(teamName, teamMode, teamInfo, Arrays.asList(entities));
    }

    public WrapperPlayServerTeams(String teamName, TeamMode teamMode, @Nullable ScoreBoardTeamInfo teamInfo, Collection<String> entities) {
        super(PacketType.Play.Server.TEAMS);
        this.teamName = teamName;
        this.teamMode = teamMode;
        this.players = entities;
        this.teamInfo = Optional.ofNullable(teamInfo);
    }

    @Deprecated
    public WrapperPlayServerTeams(String teamName, TeamMode teamMode, Optional<ScoreBoardTeamInfo> teamInfo, String ... entities) {
        this(teamName, teamMode, teamInfo, Arrays.asList(entities));
    }

    @Deprecated
    public WrapperPlayServerTeams(String teamName, TeamMode teamMode, Optional<ScoreBoardTeamInfo> teamInfo, Collection<String> entities) {
        super(PacketType.Play.Server.TEAMS);
        this.teamName = teamName;
        this.teamMode = teamMode;
        this.players = entities;
        this.teamInfo = teamInfo;
    }

    @Override
    public void read() {
        int teamNameLimit = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18) ? Short.MAX_VALUE : 16;
        this.teamName = this.readString(teamNameLimit);
        this.teamMode = TeamMode.values()[this.readByte()];
        ScoreBoardTeamInfo info = null;
        if (this.teamMode == TeamMode.CREATE || this.teamMode == TeamMode.UPDATE) {
            NamedTextColor color;
            NameTagVisibility nameTagVisibility;
            OptionData optionData;
            Component suffix;
            Component prefix;
            Component displayName;
            CollisionRule collisionRule = null;
            if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
                LegacyComponentSerializer serializer = this.getSerializers().legacy();
                displayName = serializer.deserialize(this.readString(32));
                prefix = serializer.deserialize(this.readString(16));
                suffix = serializer.deserialize(this.readString(16));
                optionData = OptionData.values()[this.readByte()];
                if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
                    nameTagVisibility = NameTagVisibility.ALWAYS;
                    color = NamedTextColor.WHITE;
                } else {
                    nameTagVisibility = NameTagVisibility.fromID(this.readString(32));
                    if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                        collisionRule = CollisionRule.fromID(this.readString(32));
                    }
                    if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                        int colorId = this.readVarInt();
                        if (colorId == 21) {
                            colorId = -1;
                        }
                        color = ColorUtil.fromId(colorId);
                    } else {
                        color = ColorUtil.fromId(this.readByte());
                    }
                }
            } else {
                displayName = this.readComponent();
                optionData = OptionData.fromValue(this.readByte());
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
                    nameTagVisibility = this.readEnum(NameTagVisibility.class);
                    collisionRule = this.readEnum(CollisionRule.class);
                } else {
                    nameTagVisibility = NameTagVisibility.fromID(this.readString(40));
                    collisionRule = CollisionRule.fromID(this.readString(40));
                }
                color = ColorUtil.fromId(this.readByte());
                prefix = this.readComponent();
                suffix = this.readComponent();
            }
            info = new ScoreBoardTeamInfo(displayName, prefix, suffix, nameTagVisibility, collisionRule == null ? CollisionRule.ALWAYS : collisionRule, color, optionData);
        }
        this.teamInfo = Optional.ofNullable(info);
        this.players = new ArrayList<String>();
        if (this.teamMode == TeamMode.CREATE || this.teamMode == TeamMode.ADD_ENTITIES || this.teamMode == TeamMode.REMOVE_ENTITIES) {
            int size = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10) ? this.readShort() : this.readVarInt();
            for (int i = 0; i < size; ++i) {
                this.players.add(this.readString(40));
            }
        }
    }

    @Override
    public void write() {
        int teamNameLimit = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18) ? Short.MAX_VALUE : 16;
        this.writeString(this.teamName, teamNameLimit);
        this.writeByte(this.teamMode.ordinal());
        if (this.teamMode == TeamMode.CREATE || this.teamMode == TeamMode.UPDATE) {
            ScoreBoardTeamInfo info = this.teamInfo.orElse(new ScoreBoardTeamInfo(Component.empty(), Component.empty(), Component.empty(), NameTagVisibility.ALWAYS, CollisionRule.ALWAYS, NamedTextColor.WHITE, OptionData.NONE));
            if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
                LegacyComponentSerializer serializer = this.getSerializers().legacy();
                this.writeString(LegacyFormat.trimLegacyFormat(serializer.serialize(info.displayName), 32));
                this.writeString(LegacyFormat.trimLegacyFormat(serializer.serialize(info.prefix), 16));
                this.writeString(LegacyFormat.trimLegacyFormat(serializer.serialize(info.suffix), 16));
                this.writeByte(info.optionData.ordinal());
                if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
                    this.writeString(NameTagVisibility.ALWAYS.getId(), 32);
                    this.writeByte(15);
                } else {
                    this.writeString(info.tagVisibility.id, 32);
                    if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                        this.writeString(info.collisionRule.getId(), 32);
                    }
                    this.writeByte(ColorUtil.getId(info.color));
                }
            } else {
                this.writeComponent(info.displayName);
                this.writeByte(info.optionData.getByteValue());
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
                    this.writeEnum(info.tagVisibility);
                    this.writeEnum(info.collisionRule);
                } else {
                    this.writeString(info.tagVisibility.id);
                    this.writeString(info.collisionRule.getId());
                }
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                    int colorId = ColorUtil.getId(info.color);
                    if (colorId < 0) {
                        colorId = 21;
                    }
                    this.writeVarInt(colorId);
                } else {
                    this.writeByte(ColorUtil.getId(info.color));
                }
                this.writeComponent(info.prefix);
                this.writeComponent(info.suffix);
            }
        }
        if (this.teamMode == TeamMode.CREATE || this.teamMode == TeamMode.ADD_ENTITIES || this.teamMode == TeamMode.REMOVE_ENTITIES) {
            if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
                this.writeShort(this.players.size());
            } else {
                this.writeVarInt(this.players.size());
            }
            for (String playerName : this.players) {
                this.writeString(playerName, 40);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerTeams wrapper) {
        this.teamName = wrapper.teamName;
        this.teamMode = wrapper.teamMode;
        this.players = wrapper.players;
        this.teamInfo = wrapper.teamInfo;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public TeamMode getTeamMode() {
        return this.teamMode;
    }

    public void setTeamMode(TeamMode teamMode) {
        this.teamMode = teamMode;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(Collection<String> players) {
        this.players = players;
    }

    public Optional<ScoreBoardTeamInfo> getTeamInfo() {
        return this.teamInfo;
    }

    public void setTeamInfo(@Nullable ScoreBoardTeamInfo teamInfo) {
        this.teamInfo = Optional.ofNullable(teamInfo);
    }

    public static enum TeamMode {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_ENTITIES,
        REMOVE_ENTITIES;

    }

    public static class ScoreBoardTeamInfo {
        private Component displayName;
        private Component prefix;
        private Component suffix;
        private NameTagVisibility tagVisibility;
        private CollisionRule collisionRule;
        private NamedTextColor color;
        private OptionData optionData;

        public ScoreBoardTeamInfo(Component displayName, @Nullable Component prefix, @Nullable Component suffix, NameTagVisibility tagVisibility, CollisionRule collisionRule, NamedTextColor color, OptionData optionData) {
            this.displayName = displayName;
            if (prefix == null) {
                prefix = Component.empty();
            }
            if (suffix == null) {
                suffix = Component.empty();
            }
            this.prefix = prefix;
            this.suffix = suffix;
            this.tagVisibility = tagVisibility;
            this.collisionRule = collisionRule;
            this.color = color;
            this.optionData = optionData;
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(Component displayName) {
            this.displayName = displayName;
        }

        public Component getPrefix() {
            return this.prefix;
        }

        public void setPrefix(Component prefix) {
            this.prefix = prefix;
        }

        public Component getSuffix() {
            return this.suffix;
        }

        public void setSuffix(Component suffix) {
            this.suffix = suffix;
        }

        public NameTagVisibility getTagVisibility() {
            return this.tagVisibility;
        }

        public void setTagVisibility(NameTagVisibility tagVisibility) {
            this.tagVisibility = tagVisibility;
        }

        public CollisionRule getCollisionRule() {
            return this.collisionRule;
        }

        public void setCollisionRule(CollisionRule collisionRule) {
            this.collisionRule = collisionRule;
        }

        public NamedTextColor getColor() {
            return this.color;
        }

        public void setColor(NamedTextColor color) {
            this.color = color;
        }

        public OptionData getOptionData() {
            return this.optionData;
        }

        public void setOptionData(OptionData optionData) {
            this.optionData = optionData;
        }
    }

    public static enum OptionData {
        NONE(0),
        FRIENDLY_FIRE(1),
        FRIENDLY_CAN_SEE_INVISIBLE(2),
        ALL(3);

        private static final OptionData[] VALUES;
        private final byte byteValue;

        private OptionData(byte value) {
            this.byteValue = value;
        }

        public byte getByteValue() {
            return this.byteValue;
        }

        @Nullable
        public static OptionData fromValue(byte value) {
            for (OptionData data : VALUES) {
                if (data.getByteValue() != value) continue;
                return data;
            }
            return null;
        }

        static {
            VALUES = OptionData.values();
        }
    }

    public static enum NameTagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private final String id;

        private NameTagVisibility(String id) {
            this.id = id;
        }

        @Nullable
        public static NameTagVisibility fromID(String id) {
            for (NameTagVisibility value : NameTagVisibility.values()) {
                if (!value.id.equalsIgnoreCase(id)) continue;
                return value;
            }
            return null;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private final String id;

        private CollisionRule(String id) {
            this.id = id;
        }

        @Nullable
        public static CollisionRule fromID(String id) {
            for (CollisionRule value : CollisionRule.values()) {
                if (!value.id.equalsIgnoreCase(id)) continue;
                return value;
            }
            return null;
        }

        public String getId() {
            return this.id;
        }
    }
}

