/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.client;

import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.DiggingAction;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.BlockFace;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.Vector3i;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientPlayerDigging
extends PacketWrapper<WrapperPlayClientPlayerDigging> {
    private DiggingAction action;
    private Vector3i blockPosition;
    private BlockFace blockFace;
    private int blockFaceId;
    private int sequence;

    public WrapperPlayClientPlayerDigging(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerDigging(DiggingAction action, Vector3i blockPosition, BlockFace blockFace, int sequence) {
        super(PacketType.Play.Client.PLAYER_DIGGING);
        this.action = action;
        this.blockPosition = blockPosition;
        this.blockFace = blockFace;
        this.blockFaceId = blockFace.getFaceValue();
        this.sequence = sequence;
    }

    public WrapperPlayClientPlayerDigging(DiggingAction action, Vector3i blockPosition, int blockFace, int sequence) {
        super(PacketType.Play.Client.PLAYER_DIGGING);
        this.action = action;
        this.blockPosition = blockPosition;
        this.blockFace = BlockFace.getBlockFaceByValue(blockFace);
        this.blockFaceId = blockFace;
        this.sequence = sequence;
    }

    @Override
    public void read() {
        this.action = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? DiggingAction.getById(this.readVarInt()) : DiggingAction.getById(this.readByte());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.blockPosition = this.readBlockPosition();
        } else {
            int x = this.readInt();
            short y = this.readUnsignedByte();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        }
        this.blockFaceId = this.readUnsignedByte();
        this.blockFace = BlockFace.getBlockFaceByValue(this.blockFaceId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.sequence = this.readVarInt();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.writeVarInt(this.action.getId());
            this.writeBlockPosition(this.blockPosition);
        } else {
            this.writeByte(this.action.getId());
            this.writeInt(this.blockPosition.x);
            this.writeByte(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        }
        this.writeByte(this.blockFaceId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(this.sequence);
        }
    }

    @Override
    public void copy(WrapperPlayClientPlayerDigging wrapper) {
        this.action = wrapper.action;
        this.blockPosition = wrapper.blockPosition;
        this.blockFace = wrapper.blockFace;
        this.blockFaceId = wrapper.blockFaceId;
        this.sequence = wrapper.sequence;
    }

    public DiggingAction getAction() {
        return this.action;
    }

    public void setAction(DiggingAction action) {
        this.action = action;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public void setBlockFace(BlockFace blockFace) {
        this.blockFace = blockFace;
        this.blockFaceId = blockFace.getFaceValue();
    }

    public int getBlockFaceId() {
        return this.blockFaceId;
    }

    public void setBlockFaceId(int faceId) {
        this.blockFace = BlockFace.getBlockFaceByValue(faceId);
        this.blockFaceId = faceId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }
}

