/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.client;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientAdvancementTab
extends PacketWrapper<WrapperPlayClientAdvancementTab> {
    private Action action;
    @Nullable
    private String tabID;

    public WrapperPlayClientAdvancementTab(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientAdvancementTab(Action action, @Nullable String tabID) {
        super(PacketType.Play.Client.ADVANCEMENT_TAB);
        this.action = action;
        this.tabID = tabID;
    }

    @Override
    public void read() {
        this.action = Action.getById(this.readVarInt());
        if (this.action == Action.OPENED_TAB) {
            this.tabID = this.readString();
        }
    }

    @Override
    public void copy(WrapperPlayClientAdvancementTab wrapper) {
        this.action = wrapper.action;
        this.tabID = wrapper.tabID;
    }

    @Override
    public void write() {
        this.writeVarInt(this.action.ordinal());
        if (this.action == Action.OPENED_TAB) {
            this.writeString(this.tabID);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Optional<String> getTabId() {
        return Optional.ofNullable(this.tabID);
    }

    public void setTabId(String tabID) {
        this.tabID = tabID;
    }

    public static enum Action {
        OPENED_TAB,
        CLOSED_SCREEN;

        private static final Action[] VALUES;

        public static Action getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = Action.values();
        }
    }
}

