/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.ChatType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.chat.ChatTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.dialog.Dialog;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.dialog.Dialogs;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cat.CatVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cat.CatVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.chicken.ChickenVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.chicken.ChickenVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cow.CowVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.cow.CowVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.frog.FrogVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.frog.FrogVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.nautilus.ZombieNautilusVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.nautilus.ZombieNautilusVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.pig.PigVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.pig.PigVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.wolfvariant.WolfSoundVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.wolfvariant.WolfSoundVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.wolfvariant.WolfVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.wolfvariant.WolfVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.banner.BannerPattern;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.banner.BannerPatterns;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.enchantment.type.EnchantmentType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.instrument.Instrument;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.instrument.Instruments;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.jukebox.IJukeboxSong;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.jukebox.JukeboxSongs;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.trimmaterial.TrimMaterial;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.trimmaterial.TrimMaterials;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.trimpattern.TrimPattern;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.trimpattern.TrimPatterns;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.CopyableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.DeepComparableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.ResolvableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTList;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.User;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtDecoder;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines.Timeline;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines.Timelines;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.biome.Biome;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.biome.Biomes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DamageType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DamageTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.dimension.DimensionType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.dimension.DimensionTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.painting.PaintingVariant;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.painting.PaintingVariants;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.resources.ResourceLocation;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.IRegistry;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.SimpleRegistry;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.SimpleTypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;

@ApiStatus.Internal
public final class SynchronizedRegistriesHandler {
    private static final boolean FORCE_PER_USER_REGISTRIES = Boolean.getBoolean("packetevents.force-per-user-registries");
    private static final Map<ResourceLocation, RegistryEntry<?>> REGISTRY_KEYS = new HashMap();

    private SynchronizedRegistriesHandler() {
    }

    @Nullable
    public static RegistryEntry<?> getRegistryEntry(ResourceLocation registryKey) {
        return REGISTRY_KEYS.get(registryKey);
    }

    public static void handleRegistry(User user, PacketWrapper<?> wrapper, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, wrapper.getServerVersion().toClientVersion());
        SynchronizedRegistriesHandler.handleRegistry(user, wrapper, registryName, elements, cacheKey);
    }

    public static void handleRegistry(User user, PacketWrapper<?> wrapper, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements, Object cacheKey) {
        RegistryEntry<?> registryData = REGISTRY_KEYS.get(registryName);
        if (registryData == null) {
            return;
        }
        SimpleRegistry<?> syncedRegistry = FORCE_PER_USER_REGISTRIES || cacheKey == null ? registryData.createFromElements(elements, wrapper) : registryData.computeSyncedRegistry(cacheKey, () -> registryData.createFromElements(elements, wrapper));
        user.putRegistry(syncedRegistry);
        for (MappedEntity entry : syncedRegistry.getEntries()) {
            if (!(entry instanceof ResolvableEntity)) continue;
            ((ResolvableEntity)((Object)entry)).doResolve(wrapper);
        }
    }

    public static void handleLegacyRegistries(User user, PacketWrapper<?> wrapper, NBTCompound registryData) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, wrapper.getServerVersion().toClientVersion());
        for (NBT tag : registryData.getTags().values()) {
            if (tag instanceof NBTList) {
                NBTList list = (NBTList)tag;
                SynchronizedRegistriesHandler.handleRegistry(user, wrapper, DimensionTypes.getRegistry().getRegistryKey(), WrapperConfigServerRegistryData.RegistryElement.convertNbt(list), cacheKey);
                continue;
            }
            NBTCompound compound = (NBTCompound)tag;
            ResourceLocation registryName = new ResourceLocation(compound.getStringTagValueOrThrow("type"));
            NBTList<NBTCompound> nbtElements = compound.getCompoundListTagOrNull("value");
            if (nbtElements == null) continue;
            SynchronizedRegistriesHandler.handleRegistry(user, wrapper, registryName, WrapperConfigServerRegistryData.RegistryElement.convertNbt(nbtElements), cacheKey);
        }
    }

    static {
        Stream.of(new RegistryEntry<Biome>(Biomes.getRegistry(), Biome.CODEC), new RegistryEntry<ChatType>(ChatTypes.getRegistry(), ChatType::decode), new RegistryEntry<TrimPattern>(TrimPatterns.getRegistry(), TrimPattern::decode), new RegistryEntry<TrimMaterial>(TrimMaterials.getRegistry(), TrimMaterial::decode), new RegistryEntry<WolfVariant>(WolfVariants.getRegistry(), WolfVariant::decode), new RegistryEntry<WolfSoundVariant>(WolfSoundVariants.getRegistry(), WolfSoundVariant::decode), new RegistryEntry<PigVariant>(PigVariants.getRegistry(), PigVariant::decode), new RegistryEntry<FrogVariant>(FrogVariants.getRegistry(), FrogVariant::decode), new RegistryEntry<CatVariant>(CatVariants.getRegistry(), CatVariant::decode), new RegistryEntry<CowVariant>(CowVariants.getRegistry(), CowVariant::decode), new RegistryEntry<ChickenVariant>(ChickenVariants.getRegistry(), ChickenVariant::decode), new RegistryEntry<ZombieNautilusVariant>(ZombieNautilusVariants.getRegistry(), ZombieNautilusVariant::decode), new RegistryEntry<PaintingVariant>(PaintingVariants.getRegistry(), PaintingVariant::decode), new RegistryEntry<DimensionType>(DimensionTypes.getRegistry(), DimensionType.CODEC), new RegistryEntry<DamageType>(DamageTypes.getRegistry(), DamageType::decode), new RegistryEntry<BannerPattern>(BannerPatterns.getRegistry(), BannerPattern::decode), new RegistryEntry<EnchantmentType>(EnchantmentTypes.getRegistry(), EnchantmentType::decode), new RegistryEntry<IJukeboxSong>(JukeboxSongs.getRegistry(), IJukeboxSong::decode), new RegistryEntry<Instrument>(Instruments.getRegistry(), Instrument::decode), new RegistryEntry<Dialog>(Dialogs.getRegistry(), Dialog::decodeDirect), new RegistryEntry<Timeline>(Timelines.getRegistry(), Timeline.CODEC)).forEach(entry -> REGISTRY_KEYS.put(entry.getRegistryKey(), (RegistryEntry<?>)entry));
    }

    @ApiStatus.Internal
    public static final class RegistryEntry<T extends MappedEntity & CopyableEntity<T>> {
        private final IRegistry<T> baseRegistry;
        private final NbtEntryDecoder<T> decoder;
        private final Map<Object, SimpleRegistry<T>> syncedRegistries = new ConcurrentHashMap<Object, SimpleRegistry<T>>(2);

        public RegistryEntry(IRegistry<T> baseRegistry, LegacyNbtEntryDecoder<T> decoder) {
            this(baseRegistry, decoder.upgrade());
        }

        public RegistryEntry(IRegistry<T> baseRegistry, NbtDecoder<T> decoder) {
            this(baseRegistry, (NBT tag, PacketWrapper<?> wrapper, TypesBuilderData data) -> ((CopyableEntity)((Object)((MappedEntity)decoder.decode(tag, wrapper)))).copy(data));
        }

        public RegistryEntry(IRegistry<T> baseRegistry, NbtEntryDecoder<T> decoder) {
            this.baseRegistry = baseRegistry;
            this.decoder = decoder;
        }

        @Nullable
        public SimpleRegistry<T> getSyncedRegistry(Object key) {
            return this.syncedRegistries.get(key);
        }

        public SimpleRegistry<T> computeSyncedRegistry(Object key, Supplier<SimpleRegistry<?>> registry) {
            return this.syncedRegistries.computeIfAbsent(key, $2 -> (SimpleRegistry)registry.get());
        }

        private void handleElement(SimpleRegistry<T> registry, WrapperConfigServerRegistryData.RegistryElement element, int id, PacketWrapper<?> wrapper) {
            MappedEntity value;
            Object copiedBaseEntry;
            ResourceLocation elementName = element.getId();
            ClientVersion version = wrapper.getServerVersion().toClientVersion();
            T baseEntry = this.baseRegistry.getByName(version, elementName);
            SimpleTypesBuilderData data = new SimpleTypesBuilderData(elementName, id);
            Object z = copiedBaseEntry = baseEntry == null ? null : (Object)((CopyableEntity)baseEntry).copy(data);
            if (element.getData() != null && !((DeepComparableEntity)((Object)(value = (MappedEntity)this.decoder.decode(element.getData(), wrapper, data)))).deepEquals(copiedBaseEntry)) {
                registry.define(elementName, id, value);
                return;
            }
            if (copiedBaseEntry != null) {
                registry.define(elementName, id, copiedBaseEntry);
                return;
            }
            PacketEvents.getAPI().getLogger().warning("Unknown registry entry " + elementName + " for " + this.getRegistryKey());
        }

        public SimpleRegistry<T> createFromElements(List<WrapperConfigServerRegistryData.RegistryElement> elements, PacketWrapper<?> wrapper) {
            SimpleRegistry registry = new SimpleRegistry(this.getRegistryKey());
            for (int id = 0; id < elements.size(); ++id) {
                WrapperConfigServerRegistryData.RegistryElement element = elements.get(id);
                this.handleElement(registry, element, id, wrapper);
            }
            return registry;
        }

        public ResourceLocation getRegistryKey() {
            return this.baseRegistry.getRegistryKey();
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface LegacyNbtEntryDecoder<T> {
        public T decode(NBT var1, ClientVersion var2, @Nullable TypesBuilderData var3);

        default public NbtEntryDecoder<T> upgrade() {
            return (nbt, wrapper, data) -> this.decode(nbt, wrapper.getServerVersion().toClientVersion(), data);
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface NbtEntryDecoder<T> {
        public T decode(NBT var1, PacketWrapper<?> var2, @Nullable TypesBuilderData var3);
    }
}

