/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.CopyableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.DeepComparableEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.MappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTFloat;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTString;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DamageEffects;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DamageScaling;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DamageTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.DeathMessageType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.damagetype.StaticDamageType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.adventure.AdventureIndexUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public interface DamageType
extends MappedEntity,
CopyableEntity<DamageType>,
DeepComparableEntity {
    public String getMessageId();

    public DamageScaling getScaling();

    public float getExhaustion();

    public DamageEffects getEffects();

    public DeathMessageType getDeathMessageType();

    public static DamageType read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(DamageTypes.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, DamageType damageType) {
        wrapper.writeMappedEntity(damageType);
    }

    public static DamageType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String messageId = ((NBTCompound)nbt).getStringTagValueOrThrow("message_id");
        DamageScaling scaling = AdventureIndexUtil.indexValueOrThrow(DamageScaling.ID_INDEX, ((NBTCompound)nbt).getStringTagValueOrThrow("scaling"));
        float exhaustion = ((NBTCompound)nbt).getNumberTagOrThrow("exhaustion").getAsFloat();
        DamageEffects effects = Optional.ofNullable(compound.getStringTagValueOrNull("effects")).map(id -> AdventureIndexUtil.indexValueOrThrow(DamageEffects.ID_INDEX, id)).orElse(DamageEffects.HURT);
        DeathMessageType deathMessageType = Optional.ofNullable(compound.getStringTagValueOrNull("death_message_type")).map(id -> AdventureIndexUtil.indexValueOrThrow(DeathMessageType.ID_INDEX, id)).orElse(DeathMessageType.DEFAULT);
        return new StaticDamageType(data, messageId, scaling, exhaustion, effects, deathMessageType);
    }

    public static NBT encode(DamageType damageType, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("message_id", new NBTString(damageType.getMessageId()));
        compound.setTag("scaling", new NBTString(damageType.getScaling().getId()));
        compound.setTag("exhaustion", new NBTFloat(damageType.getExhaustion()));
        if (damageType.getEffects() != DamageEffects.HURT) {
            compound.setTag("effects", new NBTString(damageType.getEffects().getId()));
        }
        if (damageType.getDeathMessageType() != DeathMessageType.DEFAULT) {
            compound.setTag("death_message_type", new NBTString(damageType.getDeathMessageType().getId()));
        }
        return compound;
    }
}

