/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.reader.impl;

import java.util.BitSet;
import org.jetbrains.annotations.ApiStatus;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.netty.buffer.ByteBufHelper;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.BaseChunk;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.reader.ChunkReader;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.chunk.storage.BaseStorage;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.dimension.DimensionType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class ChunkReader_v1_18
implements ChunkReader {
    @ApiStatus.Internal
    public static int getMojangZeroByteSuffixLength(BaseChunk[] chunks) {
        int mojangPleaseFixThisZeroByteSuffixLength = 0;
        for (BaseChunk chunk : chunks) {
            BaseStorage chunkStorage = ((Chunk_v1_18)chunk).getChunkData().storage;
            int chunkStorageLen = ByteBufHelper.getByteSize(chunkStorage != null ? chunkStorage.getData().length : 0);
            BaseStorage biomeStorage = ((Chunk_v1_18)chunk).getBiomeData().storage;
            int biomeStorageLen = ByteBufHelper.getByteSize(biomeStorage != null ? biomeStorage.getData().length : 0);
            mojangPleaseFixThisZeroByteSuffixLength += chunkStorageLen + biomeStorageLen;
        }
        return mojangPleaseFixThisZeroByteSuffixLength;
    }

    @Override
    public BaseChunk[] read(DimensionType dimensionType, BitSet chunkMask, BitSet secondaryChunkMask, boolean fullChunk, boolean hasBlockLight, boolean hasSkyLight, int chunkSize, int arrayLength, PacketWrapper<?> wrapper) {
        int ri = ByteBufHelper.readerIndex(wrapper.buffer);
        BaseChunk[] chunks = new BaseChunk[chunkSize];
        for (int i = 0; i < chunkSize; ++i) {
            chunks[i] = Chunk_v1_18.read(wrapper);
        }
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_6) && wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) && ByteBufHelper.readerIndex(wrapper.buffer) - ri < arrayLength) {
            ByteBufHelper.skipBytes(wrapper.buffer, ChunkReader_v1_18.getMojangZeroByteSuffixLength(chunks));
        }
        return chunks;
    }
}

