/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines;

import java.util.List;
import org.jspecify.annotations.NullMarked;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecException;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtMapCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.easing.EasingType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.easing.EasingTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.timelines.Keyframe;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

@NullMarked
public class KeyframeTrack<T> {
    private final List<Keyframe<T>> keyframes;
    private final EasingType easingType;

    public KeyframeTrack(List<Keyframe<T>> keyframes, EasingType easingType) {
        this.keyframes = keyframes;
        this.easingType = easingType;
    }

    public static <T> NbtMapCodec<KeyframeTrack<T>> mapCodec(NbtCodec<T> valueCodec) {
        final NbtCodec<List<Keyframe<T>>> keyframesCodec = Keyframe.codec(valueCodec).applyList();
        return new NbtMapCodec<KeyframeTrack<T>>(){

            @Override
            public KeyframeTrack<T> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                List keyframes = (List)compound.getOrThrow("keyframes", keyframesCodec, wrapper);
                EasingType easingType = compound.getOr("ease", EasingType.CODEC, EasingTypes.LINEAR, wrapper);
                return new KeyframeTrack(keyframes, easingType);
            }

            @Override
            public void encode(NBTCompound compound, PacketWrapper<?> wrapper, KeyframeTrack<T> value) throws NbtCodecException {
                compound.set("keyframes", value.keyframes, keyframesCodec, wrapper);
                if (value.easingType != EasingTypes.LINEAR) {
                    compound.set("ease", value.easingType, EasingType.CODEC, wrapper);
                }
            }
        };
    }

    public List<Keyframe<T>> getKeyframes() {
        return this.keyframes;
    }

    public EasingType getEasingType() {
        return this.easingType;
    }
}

