/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers;

import org.jspecify.annotations.NullMarked;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.AlphaColor;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.Color;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecs;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.EnvironmentAttribute;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers.AttributeModifier;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.modifiers.BlendToGrayArgument;

@NullMarked
public interface AlphaColorModifier<A>
extends AttributeModifier<AlphaColor, A> {
    public static final AlphaColorModifier<AlphaColor> ALPHA_BLEND = Color::blendWith;
    public static final AlphaColorModifier<Color> ADD = AlphaColor::plus;
    public static final AlphaColorModifier<Color> SUBTRACT = AlphaColor::minus;
    public static final AlphaColorModifier<AlphaColor> MULTIPLY = AlphaColor::times;
    public static final AlphaColorModifier<BlendToGrayArgument> BLEND_TO_GRAY = new AlphaColorModifier<BlendToGrayArgument>(){

        @Override
        public AlphaColor apply(AlphaColor value, BlendToGrayArgument arg) {
            return arg.blend(value);
        }

        @Override
        public NbtCodec<BlendToGrayArgument> argumentCodec(EnvironmentAttribute<AlphaColor> attribute) {
            return BlendToGrayArgument.CODEC;
        }
    };

    @FunctionalInterface
    public static interface ArgbModifier
    extends AlphaColorModifier<AlphaColor> {
        @Override
        default public NbtCodec<AlphaColor> argumentCodec(EnvironmentAttribute<AlphaColor> attribute) {
            return NbtCodecs.ARGB_COLOR;
        }
    }

    @FunctionalInterface
    public static interface RgbModifier
    extends AlphaColorModifier<Color> {
        @Override
        default public NbtCodec<Color> argumentCodec(EnvironmentAttribute<AlphaColor> attribute) {
            return NbtCodecs.RGB_COLOR;
        }
    }
}

